/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjProperty
extends AbstractParseTreeNode
implements JsonMLCompatible {
    public ObjProperty(StringLiteral name, Expression value) {
        this(FilePosition.span(name.getFilePosition(), value.getFilePosition()), name, value);
    }

    public ObjProperty(FilePosition pos, StringLiteral name, Expression value) {
        super(pos, Expression.class);
        this.createMutation().appendChild(name).appendChild(value).execute();
    }

    protected ObjProperty(FilePosition pos, Void value, List<? extends Expression> children) {
        this(pos, (StringLiteral)children.get(0), children.get(1));
        assert (children.size() == 2);
    }

    @Override
    public final Object getValue() {
        return null;
    }

    public List<? extends Expression> children() {
        return this.childrenAs(Expression.class);
    }

    public final StringLiteral getPropertyNameNode() {
        return (StringLiteral)this.children().get(0);
    }

    @Override
    public void childrenChanged() {
        super.childrenChanged();
        if (2 != this.children().size()) {
            throw new IndexOutOfBoundsException();
        }
        this.getPropertyName();
    }

    public final String getPropertyName() {
        return ((StringLiteral)this.children().get(0)).getUnquotedValue();
    }

    public boolean isPropertyNameQuoted() {
        StringLiteral name = (StringLiteral)this.children().get(0);
        String rawName = name.getValue();
        if (rawName.length() == 0) {
            return false;
        }
        char ch0 = rawName.charAt(0);
        return ch0 == '\"' || ch0 == '\'';
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> handler) {
        return new JsPrettyPrinter(new Concatenator(out, handler));
    }

    protected final void renderPropertyName(RenderContext rc, boolean preferUnquoted) {
        String uqVal;
        StringLiteral key = (StringLiteral)this.children().get(0);
        TokenConsumer out = rc.getOut();
        if ((rc.rawObjKeys() || preferUnquoted) && ParserBase.isJavascriptIdentifier(uqVal = key.getUnquotedValue()) && !"get".equals(uqVal) && !"set".equals(uqVal)) {
            out.mark(key.getFilePosition());
            out.consume(uqVal);
            return;
        }
        key.render(rc);
    }
}

