/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.FinallyStmt;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TryStmt
extends AbstractStatement {
    private Block body;
    private CatchStmt cat;
    private FinallyStmt fin;

    @ParseTreeNode.ReflectiveCtor
    public TryStmt(FilePosition pos, Void value, List<? extends Statement> children) {
        super(pos, Statement.class);
        this.createMutation().appendChildren(children).execute();
    }

    public TryStmt(FilePosition pos, Block body, CatchStmt cat, FinallyStmt fin) {
        super(pos, Statement.class);
        MutableParseTreeNode.Mutation m = this.createMutation().appendChild(body);
        if (cat != null) {
            m.appendChild(cat);
        }
        if (fin != null) {
            m.appendChild(fin);
        }
        m.execute();
    }

    @Override
    protected void childrenChanged() {
        Statement stmt2;
        super.childrenChanged();
        List<? extends Statement> children = this.children();
        this.body = (Block)children.get(0);
        Statement stmt1 = children.get(1);
        Statement statement = stmt2 = children.size() >= 3 ? children.get(2) : null;
        if (stmt2 != null) {
            this.cat = (CatchStmt)stmt1;
            this.fin = (FinallyStmt)stmt2;
        } else if (stmt1 instanceof FinallyStmt) {
            this.cat = null;
            this.fin = (FinallyStmt)stmt1;
        } else {
            this.cat = (CatchStmt)stmt1;
            this.fin = null;
        }
    }

    public Block getBody() {
        return this.body;
    }

    public CatchStmt getCatchClause() {
        return this.cat;
    }

    public FinallyStmt getFinallyClause() {
        return this.fin;
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends Statement> children() {
        return this.childrenAs(Statement.class);
    }

    @Override
    public void render(RenderContext rc) {
        rc.getOut().mark(this.getFilePosition());
        rc.getOut().consume("try");
        this.body.renderBlock(rc, false);
        if (null != this.cat) {
            this.cat.renderBlock(rc, null != this.fin);
        }
        if (null != this.fin) {
            this.fin.renderBlock(rc, false);
        }
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public JsonML toJsonML() {
        JsonMLCompatible.JsonMLBuilder builder = JsonMLCompatible.JsonMLBuilder.builder(TagType.TryStmt, this.getFilePosition());
        builder.addChild(this.body);
        builder.addChild(this.cat != null ? this.cat.toJsonML() : JsonMLCompatible.JsonMLBuilder.builder(TagType.Empty, FilePosition.endOf(this.body.getFilePosition())).build());
        if (this.fin != null) {
            builder.addChild(this.fin);
        }
        return builder.build();
    }
}

