/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.CajoledModuleExpression;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CajitaModuleRewriter {
    private final ModuleManager mgr;

    public ModuleManager getModuleManager() {
        return this.mgr;
    }

    public CajoledModule rewrite(List<CajoledModule> modules) {
        List<CajoledModule> byIndex = this.mgr.getModuleMap();
        if (modules.size() == 1 && byIndex.isEmpty()) {
            return modules.get(0);
        }
        FilePosition unk = FilePosition.UNKNOWN;
        BuildInfo buildInfo = this.mgr.getBuildInfo();
        Declaration moduleMap = null;
        if (!byIndex.isEmpty()) {
            List<CajoledModuleExpression> indexModules = Lists.newArrayList();
            int n = byIndex.size();
            for (int i = 0; i < n; ++i) {
                CajoledModule m = byIndex.get(i);
                indexModules.add(new CajoledModuleExpression(m));
            }
            moduleMap = (Declaration)QuasiBuilder.substV("var moduleMap___ = [@modules*];", "modules", new ParseTreeNodeContainer(indexModules));
        }
        Expression moduleInvocations = null;
        for (CajoledModule module : modules) {
            Expression invocation = this.mgr.getPluginMeta().getEnableES53() ? (Expression)QuasiBuilder.substV("___.prepareModule(@moduleBody).instantiate___(___, IMPORTS___)", "moduleBody", module.getModuleBody()) : (Expression)QuasiBuilder.substV("___.prepareModule(@moduleBody)(IMPORTS___)", "moduleBody", module.getModuleBody());
            moduleInvocations = moduleInvocations != null ? Operation.createInfix(Operator.COMMA, moduleInvocations, invocation) : invocation;
        }
        ObjectConstructor oc = (ObjectConstructor)QuasiBuilder.substV("({  instantiate: function (___, IMPORTS___) {    @moduleMap?;    return @moduleInvocations?;  },  cajolerName: @cajolerName,  cajolerVersion: @cajolerVersion,  cajoledDate: @cajoledDate})", "moduleMap", moduleMap, "moduleInvocations", moduleInvocations, "cajolerName", StringLiteral.valueOf(unk, "com.google.caja"), "cajolerVersion", StringLiteral.valueOf(unk, buildInfo.getBuildVersion()), "cajoledDate", new IntegerLiteral(unk, buildInfo.getCurrentTime()));
        return new CajoledModule(oc);
    }

    public CajitaModuleRewriter(ModuleManager mgr) {
        this.mgr = mgr;
    }

    public CajitaModuleRewriter(PluginMeta meta, BuildInfo buildInfo, UriFetcher uriFetcher, boolean isFromValija, MessageQueue mq) {
        this(new ModuleManager(meta, buildInfo, uriFetcher, isFromValija, mq));
    }

    public CajitaModuleRewriter(PluginMeta meta, BuildInfo buildInfo, boolean isFromValija, MessageQueue mq) {
        this(meta, buildInfo, UriFetcher.NULL_NETWORK, isFromValija, mq);
    }
}

