/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.CaseStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.ControlOperation;
import com.google.caja.parser.js.DebuggerStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DefaultCaseStmt;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.SimpleOperation;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SwitchStmt;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.Permit;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.parser.quasiliteral.SyntheticRuleSet;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RulesetDescription(name="Cajita Transformation Rules", synopsis="Default set of transformations used by Cajita")
public class CajitaRewriter
extends Rewriter {
    private final BuildInfo buildInfo;
    private final URI baseUri;
    private final ModuleManager moduleManager;
    private final Set<StringLiteral> includedModules = Sets.newTreeSet(new Comparator<StringLiteral>(){

        @Override
        public int compare(StringLiteral o1, StringLiteral o2) {
            return o1.getUnquotedValue().compareTo(o2.getUnquotedValue());
        }
    });
    private final Set<StringLiteral> inlinedModules = Sets.newTreeSet(new Comparator<StringLiteral>(){

        @Override
        public int compare(StringLiteral o1, StringLiteral o2) {
            return o1.getUnquotedValue().compareTo(o2.getUnquotedValue());
        }
    });
    private static final FilePosition UNK = FilePosition.UNKNOWN;
    private final Rule[] cajaRules = new Rule[]{new Rule(){

        @RuleDescription(name="translatedCode", synopsis="Allow code received from a *->JS translator", reason="Translated code should not be treated as user supplied JS.", matches="<TranslatedCode>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof TranslatedCode) {
                Block rewritten = ((TranslatedCode)this.expandAll(node, scope)).getTranslation();
                Scope.markForSideEffect(rewritten);
                return rewritten;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="labeledStatement", synopsis="Statically reject if a label with `__` suffix is found", reason="Caja reserves the `__` suffix for internal use", matches="@lbl: @stmt;", substitutes="@lbl: @stmt;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String label;
            if (node instanceof LabeledStatement && (label = ((LabeledStatement)node).getLabel()).endsWith("__")) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.LABELS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), MessagePart.Factory.valueOf(label));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="loadmodule", synopsis="rewrites the load function.", reason="", matches="load(@arg)", substitutes="depending on whether moduleManager bundles modules")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isImported("load")) {
                ParseTreeNode arg = bindings.get("arg");
                if (arg instanceof StringLiteral) {
                    StringLiteral name = CajitaRewriter.this.noexpand((StringLiteral)arg);
                    if (CajitaRewriter.this.moduleManager != null) {
                        int moduleIndex = CajitaRewriter.this.moduleManager.getModule(CajitaRewriter.this.baseUri, name);
                        if (moduleIndex >= 0) {
                            CajitaRewriter.this.inlinedModules.add(name);
                            return QuasiBuilder.substV("moduleMap___[@moduleIndex]", "moduleIndex", new IntegerLiteral(UNK, moduleIndex));
                        }
                        CajitaRewriter.requireErrors(CajitaRewriter.this.mq, node);
                        return node;
                    }
                    CajitaRewriter.this.includedModules.add(name);
                    return QuasiBuilder.substV("load(@name)", "name", name);
                }
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_LOAD_A_DYNAMIC_CAJITA_MODULE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="moduleEnvelope", synopsis="Cajole an UncajoledModule into a CajoledModule. Note that the ouptut is a CajoledModule wrapper *around* thecontents of the 'substitutes' of this rule.", reason="So that the module loader can be invoked to load a module.", matches="<an UncajoledModule>", substitutes="(/*@synthetic*/{  instantiate: /*@synthetic*/function (___, IMPORTS___) {    /*var moduleResult___ = ___.NO_RESULT;*/    @rewrittenModuleStmts*;    /*return moduleResult___;*/  },  @metaKeys*: @metaValues*,  cajolerName: @cajolerName,  cajolerVersion: @cajolerVersion,  cajoledDate: @cajoledDate})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof UncajoledModule) {
                Statement returnStmt = (Statement)QuasiBuilder.substV("return moduleResult___;", new Object[0]);
                Scope.markForSideEffect(returnStmt);
                Block inputModuleStmts = (Block)QuasiBuilder.substV("var moduleResult___ = ___./*@synthetic*/NO_RESULT;@moduleBody*;@returnStmt", "moduleBody", new ParseTreeNodeContainer(((UncajoledModule)node).getModuleBody().children()), "returnStmt", returnStmt);
                Block rewrittenModuleStmts = (Block)CajitaRewriter.this.expand(inputModuleStmts, null);
                ParseTreeNodeContainer metaKeys = new ParseTreeNodeContainer();
                ParseTreeNodeContainer metaValues = new ParseTreeNodeContainer();
                if (!CajitaRewriter.this.includedModules.isEmpty()) {
                    metaKeys.appendChild(StringLiteral.valueOf(UNK, "includedModules"));
                    metaValues.appendChild(new ArrayConstructor(UNK, Lists.newArrayList(CajitaRewriter.this.includedModules)));
                }
                if (!CajitaRewriter.this.inlinedModules.isEmpty()) {
                    metaKeys.appendChild(StringLiteral.valueOf(UNK, "inlinedModules"));
                    metaValues.appendChild(new ArrayConstructor(UNK, Lists.newArrayList(CajitaRewriter.this.inlinedModules)));
                }
                ObjectConstructor moduleObjectLiteral = (ObjectConstructor)this.substV("rewrittenModuleStmts", CajitaRewriter.returnLast(rewrittenModuleStmts), "metaKeys", metaKeys, "metaValues", metaValues, "cajolerName", new StringLiteral(UNK, "com.google.caja"), "cajolerVersion", new StringLiteral(UNK, CajitaRewriter.this.buildInfo.getBuildVersion()), "cajoledDate", new IntegerLiteral(UNK, CajitaRewriter.this.buildInfo.getCurrentTime()));
                return new CajoledModule(moduleObjectLiteral);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="module", synopsis="Import free vars. Return last expr-statement", reason="Builds the module body encapsulation around the Cajita code block.", matches="{@ss*;}", substitutes="@importedvars*; @startStmts*; @expanded*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block && scope == null) {
                Scope s2 = Scope.fromProgram((Block)node, CajitaRewriter.this.mq);
                List<ParseTreeNode> expanded = Lists.newArrayList();
                for (ParseTreeNode parseTreeNode : node.children()) {
                    ParseTreeNode expandedC = CajitaRewriter.this.expand(parseTreeNode, s2);
                    if (expandedC instanceof Noop) continue;
                    expanded.add(expandedC);
                }
                List<ParseTreeNode> importedVars = Lists.newArrayList();
                Set<String> set = s2.getImportedVariables();
                Set<String> orderedImportNames = Sets.newLinkedHashSet();
                if (set.contains("Array")) {
                    orderedImportNames.add("Array");
                }
                if (set.contains("Object")) {
                    orderedImportNames.add("Object");
                }
                orderedImportNames.addAll(set);
                for (String k : orderedImportNames) {
                    Identifier kid = new Identifier(UNK, k);
                    Expression permitsUsed = s2.getPermitsUsed(kid);
                    if (null == permitsUsed || "Array".equals(k) || "Object".equals(k)) {
                        importedVars.add(QuasiBuilder.substV("var @vIdent = ___.readImport(IMPORTS___, @vName);", "vIdent", SyntheticNodes.s(kid), "vName", 7.toStringLiteral(kid)));
                        continue;
                    }
                    importedVars.add(QuasiBuilder.substV("var @vIdent = ___.readImport(IMPORTS___, @vName, @permits);", "vIdent", SyntheticNodes.s(kid), "vName", 7.toStringLiteral(kid), "permits", permitsUsed));
                }
                return this.substV("importedvars", new ParseTreeNodeContainer(importedVars), "startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "expanded", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="block", synopsis="Initialize named functions at the beginning of their enclosing block.", reason="Nested named function declarations are illegal in ES3 but are universally supported by all JavaScript implementations, though in different ways. The compromise semantics currently supported by Cajita is to hoist the declaration of a variable with the function's name to the beginning of the enclosing function body or module top level, and to initialize this variable to a new anonymous function every time control re-enters the enclosing block.\nNote that ES-Harmony will specify a better and safer semantics -- block level lexical scoping -- that we'd like to adopt into Cajita eventually. However, it is so challenging to implement this semantics by translation to currently-implemented JavaScript that we provide something quicker and dirtier for now.", matches="{@ss*;}", substitutes="@startStmts*; @ss*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block) {
                List<? extends Statement> expanded = Lists.newArrayList();
                Scope s2 = Scope.fromPlainBlock(scope);
                for (Statement statement : ((Block)node).children()) {
                    ParseTreeNode rewritten = CajitaRewriter.this.expand(statement, s2);
                    if (rewritten.getClass() == Block.class) {
                        expanded.addAll(((Block)rewritten).children());
                        continue;
                    }
                    if (rewritten instanceof Noop) continue;
                    expanded.add((Statement)rewritten);
                }
                return this.substV("startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "ss", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="with", synopsis="Statically reject if a `with` block is found.", reason="`with` violates the assumptions made by Scope, and makes it very hard to write a Scope that works. http://yuiblog.com/blog/2006/04/11/with-statement-considered-harmful/ briefly touches on why `with` is bad for programmers. For reviewers -- matching of references with declarations can only be done at runtime. All other secure JS subsets that we know of (ADSafe, Jacaranda, & FBJS) also disallow `with`.", matches="with (@scope) @body;", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.WITH_BLOCKS_NOT_ALLOWED, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="foreachExpr", synopsis="Get the keys, then iterate over them.", reason="", matches="for (@k in @o) @ss;", substitutes="for (@tkeys = cajita.allKeys(@o),     @tidx = 0,     @tlen = @tkeys.length;\n     @tidx < @tlen; ++@tidx) {\n  @assign;\n  @ss;\n}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Expression k;
                Statement ks = (Statement)bindings.get("k");
                if (ks instanceof ExpressionStmt) {
                    k = ((ExpressionStmt)ks).getExpression();
                } else {
                    Declaration d = (Declaration)ks;
                    if (d.getInitializer() != null || d.getIdentifierName().endsWith("__")) {
                        return NONE;
                    }
                    k = new Reference(d.getIdentifier());
                    k.getAttributes().set(ParseTreeNode.TAINTED, true);
                    scope.addStartOfScopeStatement((Statement)CajitaRewriter.this.expand(d, scope));
                }
                Reference tkeys = new Reference(scope.declareStartOfScopeTempVariable());
                Reference tidx = new Reference(scope.declareStartOfScopeTempVariable());
                Reference tlen = new Reference(scope.declareStartOfScopeTempVariable());
                FilePosition unk = FilePosition.UNKNOWN;
                Operation assign = Operation.create(unk, Operator.ASSIGN, k, Operation.create(unk, Operator.SQUARE_BRACKET, tkeys, Operation.create(unk, Operator.TO_NUMBER, tidx)));
                assign.getAttributes().set(ParseTreeNode.TAINTED, true);
                return this.substV("tidx", tidx, "tlen", tlen, "tkeys", tkeys, "o", CajitaRewriter.this.expand(bindings.get("o"), scope), "assign", 10.newExprStmt((Expression)CajitaRewriter.this.expand(assign, scope)), "ss", CajitaRewriter.this.expand(bindings.get("ss"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryCatch", synopsis="Ensure that only immutable data is thrown, and repair scope confusion in existing JavaScript implementations of try/catch.", reason="When manually reviewing code for vulnerability, experience shows that reviewers cannot pay adequate attention to the pervasive possibility of thrown exceptions. These lead to four dangers: 1) leaking an authority-bearing object, endangering integrity, 2) leaking a secret, endangering secrecy, and 3) aborting a partially completed state update, leaving the state malformed, endangering integrity, and 4) preventing an operation that was needed, endangering availability. Caja only seeks to make strong claims about integrity. By ensuring that only immutable (transitively frozen) data is thrown, we prevent problem #1. For the others, programmer vigilance is still needed. \nCurrent JavaScript implementations fail, in different ways, to implement the scoping of the catch variable specified in ES3. We translate Caja to JavaScript so as to implement the ES3 specified scoping on current JavaScript implementations.", matches="try { @s0*; } catch (@x) { @s1*; }", substitutes="try {\n  @s0*;\n} catch (ex___) {\n  try {\n    throw ___.tameException(ex___); \n  } catch (@x) {\n    @s1*;\n  }\n}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                TryStmt t = (TryStmt)node;
                Identifier exceptionName = t.getCatchClause().getException().getIdentifier();
                if (exceptionName.getName().endsWith("__")) {
                    CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                    return node;
                }
                return this.substV("s0", 11.withoutNoops(this.expandAll(bindings.get("s0"), scope)), "x", CajitaRewriter.this.noexpand((Identifier)bindings.get("x")), "s1", 11.withoutNoops(this.expandAll(bindings.get("s1"), Scope.fromCatchStmt(scope, t.getCatchClause()))));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryCatchFinally", synopsis="Finally adds no special issues beyond those explained in try/catch.", reason="Caja is not attempting to impose determinism, so the reasons for Joe-E to avoid finally do not apply.", matches="try { @s0*; } catch (@x) { @s1*; } finally { @s2*; }", substitutes="try {\n  @s0*;\n} catch (ex___) {\n  try {\n    throw ___.tameException(ex___);\n  } catch (@x) {\n    @s1*;\n  }\n} finally {\n  @s2*;\n}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                TryStmt t = (TryStmt)node;
                Identifier exceptionName = t.getCatchClause().getException().getIdentifier();
                if (exceptionName.getName().endsWith("__")) {
                    CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                    return node;
                }
                return this.substV("s0", 12.withoutNoops(this.expandAll(bindings.get("s0"), scope)), "x", CajitaRewriter.this.noexpand((Identifier)bindings.get("x")), "s1", 12.withoutNoops(this.expandAll(bindings.get("s1"), Scope.fromCatchStmt(scope, t.getCatchClause()))), "s2", 12.withoutNoops(this.expandAll(bindings.get("s2"), scope)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryFinally", synopsis="See bug 383. Otherwise, it's just the trivial translation.", reason="try/finally actually seems to work as needed by current JavaScript implementations.", matches="try { @s0*; } finally { @s1*; }", substitutes="try { @s0*; } finally { @s1*; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="varArgs", synopsis="Make all references to the magic \"arguments\" variable into references to a frozen array containing a snapshot of the actual arguments taken when the function was first entered.", reason="ES3 specifies that the magic \"arguments\" variable is a dynamic (\"joined\") mutable array-like reflection of the values of the parameter variables. However, the typical usage is to pass it to provide access to one's original arguments -- without the intention of providing the ability to mutate the caller's parameter variables. By making a frozen array snapshot with no \"callee\" property, we provide the least authority assumed by this typical use.\nThe snapshot is made with a \"var a___ = ___.args(arguments);\" generated at the beginning of the function body.", matches="arguments", substitutes="a___")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="varThisBad", synopsis="The \"this\" keyword is not permitted in Cajita.", reason="The rules for binding of \"this\" in JavaScript are dangerous.", matches="this", substitutes="<rejected>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.THIS_NOT_IN_CAJITA, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varBadSuffix", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@v__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varBadSuffixDeclaration", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="<approx>(var|function) @v__ ...", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier name;
            if (node instanceof Declaration && (name = ((Declaration)node).getIdentifier()).getValue().endsWith("__")) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varFuncFreeze", synopsis="An escaping occurence of a function name freezes the function.", reason="", matches="@fname", substitutes="___.primFreeze(@fname)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode fname;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isDeclaredFunctionReference(fname = bindings.get("fname"))) {
                return this.substV("fname", CajitaRewriter.this.noexpand((Reference)fname));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varDefault", synopsis="Any remaining uses of a variable name are preserved.", reason="", matches="@v", substitutes="@v")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference) {
                return CajitaRewriter.this.noexpand((Reference)v);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readBadSuffix", synopsis="Statically reject if a property has `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@x.@p__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readBadPrototype", synopsis="Warn that reading the 'prototype' property of a function is useless in Cajita.", reason="A programmer reading the 'prototype' property of a function is most likely attempting classic JavaScript prototypical inheritance, which is not supported in Cajita.", matches="@f.prototype", substitutes="<warning>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("f") instanceof Reference && scope.isFunction(21.getReferenceName(bindings.get("f")))) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROTOTYPICAL_INHERITANCE_NOT_IN_CAJITA, node.getFilePosition(), this, node);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="permittedRead", synopsis="When @o.@m is a statically permitted read, translate directly.", reason="The static permissions check is recorded so that, when the base of @o is imported, we check that this static permission was actually safe to assume.", matches="@o.@m", substitutes="@o.@m")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference m;
            ParseTreeNode o;
            Permit oPermit;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && null != (oPermit = scope.permitRead(o = bindings.get("o"))) && null != oPermit.canRead(m = (Reference)bindings.get("m"))) {
                return this.substV("o", CajitaRewriter.this.expand(o, scope), "m", CajitaRewriter.this.noexpand(m));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readPublicLength", synopsis="", reason="Length is whitelisted on Object.prototype", matches="@o.length", substitutes="@o.length")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="readPublic", synopsis="", reason="", matches="@o.@p", substitutes="@oRef.@fp ? @oRef.@p : ___.readPub(@oRef, '@p')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Reference p = (Reference)bindings.get("p");
                String propertyName = p.getIdentifierName();
                return this.commas((Expression)oPair.b, (Expression)this.substV("oRef", oPair.a, "p", CajitaRewriter.this.noexpand(p), "fp", 24.newReference(p.getFilePosition(), propertyName + "_canRead___"), "rp", 24.toStringLiteral(p)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readNumPublic", synopsis="Recognize that array indexing is inherently safe.", reason="When the developer knows that their index expression is an array index, they can indicate this with the 'absolute value operator', really an expression which coerces to a nonnegative 32-bit integer. Since these properties are necessarily readable, we can pass them  through directly to JavaScript.", matches="@o[@s&(-1>>>1)]", substitutes="@o[@s&(-1>>>1)]")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="readNumWithConstantIndex", synopsis="Recognize that array indexing is inherently safe.", reason="Nonnegative integer properties are always readable; we can pass these through directly to JavaScript.", matches="@o[@numLiteral]", substitutes="@o[@numLiteral]")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            double indexValue;
            ParseTreeNode index;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (index = bindings.get("numLiteral")) instanceof NumberLiteral && (indexValue = ((NumberLiteral)index).getValue().doubleValue()) >= 0.0 && indexValue == Math.floor(indexValue)) {
                return this.substV("o", CajitaRewriter.this.expand(bindings.get("o"), scope), "numLiteral", CajitaRewriter.this.expand(index, scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readIndexPublic", synopsis="", reason="", matches="@o[@s]", substitutes="___.readPub(@o, @s)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="setBadAssignToFunctionName", synopsis="Statically reject if an assignment expression assigns to a function name.", reason="", matches="<approx> @fname @op?= @x", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof AssignOperation && node.children().get(0) instanceof Reference && scope.isFunction(28.getReferenceName(node.children().get(0)))) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadThis", synopsis="The \"this\" keyword is not permitted in Cajita.", reason="The rules for binding of \"this\" in JavaScript are dangerous.", matches="this = @z", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.THIS_NOT_IN_CAJITA, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadFreeVariable", synopsis="Statically reject if an expression assigns to a free variable.", reason="This is still controversial (see bug 375). However, the rationale is to prevent code that's nested lexically within a module to from introducing mutable state outside its local function-body scope. Without this rule, two nested blocks within the same module could communicate via a pseudo-imported variable that is not declared or used at the outer scope of the module body.", matches="@import = @y", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("import") instanceof Reference) {
                String name = ((Reference)bindings.get("import")).getIdentifierName();
                if (Scope.UNMASKABLE_IDENTIFIERS.contains(name)) {
                    CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_MASK_IDENTIFIER, node.getFilePosition(), MessagePart.Factory.valueOf(name));
                } else if (scope.isImported(name)) {
                    CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_ASSIGN_TO_FREE_VARIABLE, node.getFilePosition(), this, node);
                    return node;
                }
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadValueOf", synopsis="Statically reject if assigning to valueOf.", reason="We depend on valueOf returning consistent results.", matches="@x.valueOf = @z", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VALUEOF_PROPERTY_MUST_NOT_BE_SET, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadSuffix", synopsis="Statically reject if a property with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@x.@p__ = @z", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadPrototype", synopsis="Warn that setting the 'prototype' property of a function is useless in Cajita.", reason="A programmer setting the 'prototype' property of a function is most likely attempting classic JavaScript prototypical inheritance, which is not supported in Cajita.", matches="@f.prototype = @rhs", substitutes="<warning>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("f") instanceof Reference && scope.isFunction(33.getReferenceName(bindings.get("f")))) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROTOTYPICAL_INHERITANCE_NOT_IN_CAJITA, node.getFilePosition(), this, node);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setStatic", synopsis="Initialize the direct properties (static members) of a potentially-mutable named function.", reason="", matches="@fname.@p = @r", substitutes="___.setStatic(@fname, @'p', @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("fname") instanceof Reference) {
                Reference fname = (Reference)bindings.get("fname");
                Reference p = (Reference)bindings.get("p");
                if (scope.isDeclaredFunction(34.getReferenceName(fname))) {
                    ParseTreeNode r = bindings.get("r");
                    return QuasiBuilder.substV("___.setStatic(@fname, @rp, @r)", "fname", CajitaRewriter.this.noexpand(fname), "rp", 34.toStringLiteral(p), "r", CajitaRewriter.this.expand(this.nymize(r, p.getIdentifierName(), "static"), scope));
                }
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIndexStatic", synopsis="Initialize the computed direct properties (static members) of a potentially-mutable named function.", reason="", matches="@fname[@s] = @r", substitutes="___.setStatic(@fname, @s, @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference fname;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("fname") instanceof Reference && scope.isDeclaredFunction(35.getReferenceName(fname = (Reference)bindings.get("fname")))) {
                return this.substV("fname", CajitaRewriter.this.noexpand(fname), "s", CajitaRewriter.this.expand(bindings.get("s"), scope), "r", CajitaRewriter.this.expand(bindings.get("r"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setPublic", synopsis="Set a public property.", reason="If the object is an unfrozen JSONContainer (a record or array), then this will create the own property if needed. If it is an unfrozen constructed object, then clients can assign to existing public own properties, but cannot directly create such properties.", matches="@o.@p = @r", substitutes="<approx> ___.setPub(@o, @'p', @r);")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Reference p = (Reference)bindings.get("p");
                String propertyName = p.getIdentifierName();
                ParseTreeNode r = bindings.get("r");
                Pair<Expression, Expression> rPair = this.reuse(this.nymize(r, propertyName, "meth"), scope);
                return this.commas((Expression)oPair.b, (Expression)rPair.b, (Expression)QuasiBuilder.substV("@oRef.@pCanSet === @oRef ? (@oRef.@p = @rRef) :                            ___.setPub(@oRef, @pName, @rRef);", "oRef", oPair.a, "rRef", rPair.a, "pCanSet", 36.newReference(UNK, propertyName + "_canSet___"), "p", CajitaRewriter.this.noexpand(p), "pName", 36.toStringLiteral(p)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIndexPublic", synopsis="", reason="", matches="@o[@s] = @r", substitutes="___.setPub(@o, @s, @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", CajitaRewriter.this.expand(bindings.get("o"), scope), "s", CajitaRewriter.this.expand(bindings.get("s"), scope), "r", CajitaRewriter.this.expand(bindings.get("r"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadInitialize", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="var @v__ = @r", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setInitialize", synopsis="Ensure v is not a function name. Expand the right side.", reason="", matches="var @v = @r", substitutes="@v = @r")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && !scope.isFunction((v = (Identifier)bindings.get("v")).getName())) {
                ParseTreeNode r = bindings.get("r");
                scope.addStartOfScopeStatement(new Declaration(v.getFilePosition(), v, null));
                ExpressionStmt init = new ExpressionStmt(node.getFilePosition(), (Expression)this.substV("v", new Reference(CajitaRewriter.this.noexpand(v)), "r", CajitaRewriter.this.expand(this.nymize(r, v.getName(), "var"), scope)));
                Scope.markForSideEffect(init);
                return init;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadDeclare", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="var @v__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setDeclare", synopsis="Ensure that v isn't a function name.", reason="", matches="var @v", substitutes="var @v")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier id;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && !scope.isFunction((id = (Identifier)bindings.get("v")).getName())) {
                scope.addStartOfScopeStatement((Declaration)this.substV("v", CajitaRewriter.this.noexpand((Identifier)bindings.get("v"))));
                return new Noop(node.getFilePosition());
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadVar", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@v__ = @r", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setVar", synopsis="Only if v isn't a function name.", reason="", matches="@v = @r", substitutes="@v = @r")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String vname;
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference && !scope.isFunction(vname = 43.getReferenceName(v))) {
                ParseTreeNode r = bindings.get("r");
                return this.substV("v", CajitaRewriter.this.noexpand((Reference)v), "r", CajitaRewriter.this.expand(this.nymize(r, vname, "var"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setReadModifyWriteLocalVar", synopsis="", reason="", matches="<approx> @x @op= @y", substitutes="<approx> @x = @x @op @y")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof AssignOperation) {
                AssignOperation aNode = (AssignOperation)node;
                Operator op = aNode.getOperator();
                if (op.getAssignmentDelegate() == null) {
                    return NONE;
                }
                Rule.ReadAssignOperands ops = this.deconstructReadAssignOperand(aNode.children().get(0), scope);
                if (ops == null) {
                    return node;
                }
                Operation rhs = Operation.create(aNode.children().get(0).getFilePosition(), op.getAssignmentDelegate(), ops.getUncajoledLValue(), aNode.children().get(1));
                Operation assignment = ops.makeAssignment(rhs);
                return this.commas(this.newCommaOperation(ops.getTemporaries()), (Expression)CajitaRewriter.this.expand(assignment, scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIncrDecr", synopsis="Handle pre and post ++ and --.", matches="<approx> ++@x but any {pre,post}{in,de}crement will do", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (!(node instanceof AssignOperation)) {
                return NONE;
            }
            AssignOperation op = (AssignOperation)node;
            Expression v = op.children().get(0);
            Rule.ReadAssignOperands ops = this.deconstructReadAssignOperand(v, scope);
            if (ops == null) {
                return node;
            }
            switch (op.getOperator()) {
                case POST_INCREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("@v ++", "v", ops.getCajoledLValue());
                    }
                    Reference tmpVal = new Reference(scope.declareStartOfScopeTempVariable());
                    Expression assign = (Expression)CajitaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@tmpVal + 1", "tmpVal", tmpVal)), scope);
                    return QuasiBuilder.substV("  @tmps,@tmpVal = +@rvalue,@assign,@tmpVal", "tmps", this.newCommaOperation(ops.getTemporaries()), "tmpVal", tmpVal, "rvalue", ops.getCajoledLValue(), "assign", assign);
                }
                case PRE_INCREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("++@v", "v", ops.getCajoledLValue());
                    }
                    if (ops.getTemporaries().isEmpty()) {
                        return CajitaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - -1", "rvalue", ops.getUncajoledLValue())), scope);
                    }
                    return QuasiBuilder.substV("  @tmps,@assign", "tmps", this.newCommaOperation(ops.getTemporaries()), "assign", CajitaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - -1", "rvalue", ops.getUncajoledLValue())), scope));
                }
                case POST_DECREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("@v--", "v", ops.getCajoledLValue());
                    }
                    Reference tmpVal = new Reference(scope.declareStartOfScopeTempVariable());
                    Expression assign = (Expression)CajitaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@tmpVal - 1", "tmpVal", tmpVal)), scope);
                    return QuasiBuilder.substV("  @tmps,@tmpVal = +@rvalue,@assign,@tmpVal;", "tmps", this.newCommaOperation(ops.getTemporaries()), "tmpVal", tmpVal, "rvalue", ops.getCajoledLValue(), "assign", assign);
                }
                case PRE_DECREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("--@v", "v", ops.getCajoledLValue());
                    }
                    if (ops.getTemporaries().isEmpty()) {
                        return CajitaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - 1", "rvalue", ops.getUncajoledLValue())), scope);
                    }
                    return QuasiBuilder.substV("  @tmps,@assign", "tmps", this.newCommaOperation(ops.getTemporaries()), "assign", CajitaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - 1", "rvalue", ops.getUncajoledLValue())), scope));
                }
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="newCalllessCtor", synopsis="Add missing empty argument list.", reason="JavaScript syntax allows constructor calls without \"()\".", matches="new @ctor", substitutes="___.construct(@ctor, [])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="newCtor", synopsis="", reason="", matches="new @ctor(@as*)", substitutes="___.construct(@ctor, [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="deleteBadValueOf", synopsis="Prohibit deletion of valueOf.", reason="Although a non-existent valueOf should behave the same way asthe default one as regards [[DefaultValue]], for simplicity weonly want to have to consider one of those cases.", matches="delete @o.valueOf", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VALUEOF_PROPERTY_MUST_NOT_BE_DELETED, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deleteBadSuffix", synopsis="", reason="", matches="delete @o.@p__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deletePublic", synopsis="", reason="", matches="delete @o.@p", substitutes="___.deletePub(@o, @'p')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Reference p = (Reference)bindings.get("p");
                return QuasiBuilder.substV("___.deletePub(@o, @pname)", "o", CajitaRewriter.this.expand(bindings.get("o"), scope), "pname", 50.toStringLiteral(p));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deleteIndexPublic", synopsis="", reason="", matches="delete @o[@s]", substitutes="___.deletePub(@o, @s)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", CajitaRewriter.this.expand(bindings.get("o"), scope), "s", CajitaRewriter.this.expand(bindings.get("s"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deleteNonProperty", synopsis="", reason="", matches="delete @v", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.NOT_DELETABLE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callBadSuffix", synopsis="Statically reject if a selector with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@o.@p__(@as*)", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.SELECTORS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="permittedCall", synopsis="When @o.@m is a statically permitted call, translate directly.", reason="The static permissions check is recorded so that, when the base of @o is imported, we check that this static permission was actually safe to assume.", matches="@o.@m(@as*)", substitutes="@o.@m(@as*)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference m;
            ParseTreeNode o;
            Permit oPermit;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && null != (oPermit = scope.permitRead(o = bindings.get("o"))) && null != oPermit.canCall(m = (Reference)bindings.get("m"))) {
                return this.substV("o", CajitaRewriter.this.expand(o, scope), "m", CajitaRewriter.this.noexpand(m), "as", this.expandAll(bindings.get("as"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callPublic", synopsis="", reason="", matches="@o.@m(@as*)", substitutes="<approx> ___.callPub(@o, @'m', [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Reference m = (Reference)bindings.get("m");
                Pair<ParseTreeNodeContainer, Expression> argsPair = this.reuseAll(bindings.get("as"), scope);
                String methodName = m.getIdentifierName();
                return this.commas((Expression)oPair.b, (Expression)argsPair.b, (Expression)QuasiBuilder.substV("@oRef.@fm ? @oRef.@m(@argRefs*) : ___.callPub(@oRef, @rm, [@argRefs*]);", "oRef", oPair.a, "argRefs", argsPair.a, "m", CajitaRewriter.this.noexpand(m), "fm", 55.newReference(UNK, methodName + "_canCall___"), "rm", 55.toStringLiteral(m)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callIndexPublic", synopsis="", reason="", matches="@o[@s](@as*)", substitutes="___.callPub(@o, @s, [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="callDeclaredFunc", synopsis="When calling a declared function name, leave the freezing to CALL___.", reason="If @fname is a declared function name, an escaping use as here would normally generate a call to primFreeze it, so that it's frozen on first use. However, since the default CALL___ method now freezes  the function it's called on, if @fname is a declared function name, we avoid expanding it.", matches="@fname(@as*)", substitutes="@fname.CALL___(@as*)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode fname;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isDeclaredFunctionReference(fname = bindings.get("fname"))) {
                return this.substV("fname", CajitaRewriter.this.noexpand((Reference)fname), "as", this.expandAll(bindings.get("as"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callFunc", synopsis="", reason="", matches="@f(@as*)", substitutes="@f.CALL___(@as*)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="funcAnonSimple", synopsis="", reason="", matches="function (@ps*) { @bs*; }", substitutes="___.markFuncFreeze(\n  function (@ps*) {\n    @fh*;\n    @stmts*;\n    @bs*;\n})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                return this.substV("ps", CajitaRewriter.this.noexpandParams(ps), "bs", 59.withoutNoops(CajitaRewriter.this.expand(bindings.get("bs"), s2)), "fh", CajitaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="funcNamedTopDecl", synopsis="A non-nested named function doesn't need a maker", reason="", matches="function @fname(@ps*) { @bs*; }", substitutes="function @fname(@ps*) {\n  @fh*;\n  @stmts*;\n  @bs*;\n}\n@fnameRef.FUNC___ = '@fname';\n")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings;
            if (node instanceof FunctionDeclaration && scope == scope.getClosestDeclarationContainer() && (bindings = this.match(((FunctionDeclaration)node).getInitializer())) != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, ((FunctionDeclaration)node).getInitializer());
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                Identifier fname = CajitaRewriter.this.noexpand((Identifier)bindings.get("fname"));
                Block block = (Block)this.substV("fname", fname, "fnameRef", new Reference(fname), "ps", CajitaRewriter.this.noexpandParams(ps), "bs", 60.withoutNoops(CajitaRewriter.this.expand(bindings.get("bs"), s2)), "fh", CajitaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
                for (Statement statement : block.children()) {
                    scope.addStartStatement(statement);
                }
                return new Noop(FilePosition.UNKNOWN);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="funcNamedSimpleDecl", synopsis="Simulate a nested named function declaration with a top level named function declaration inside an anon function expression.", reason="Current (pre-ES5) browsers have wacky scoping semantics for nested named function declarations.", matches="function @fname(@ps*) { @bs*; }", substitutes="@fname = (function() {\n  function @fself(@ps*) {\n    @fh*;\n    @stmts*;\n    @bs*;\n  }\n  @fself.FUNC___ = @'fname';\n  return @fself;\n})();")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings;
            Map<String, ParseTreeNode> map = bindings = node instanceof FunctionDeclaration ? this.match(((FunctionDeclaration)node).getInitializer()) : null;
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, ((FunctionDeclaration)node).getInitializer());
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                Identifier fname = CajitaRewriter.this.noexpand((Identifier)bindings.get("fname"));
                Identifier fself = new Identifier(UNK, this.nym(node, fname.getName(), "self"));
                scope.declareStartOfScopeVariable(fname);
                Expression expr = (Expression)QuasiBuilder.substV("@fRef = (function() {\n  function @fself(@ps*) {\n    @fh*;\n    @stmts*;\n    @bs*;\n  }\n  @rfself.FUNC___ = @rf;\n  return @rfself;\n})();", "fname", fname, "fRef", new Reference(fname), "fself", fself, "rfself", new Reference(fself), "rf", 61.toStringLiteral(fname), "ps", CajitaRewriter.this.noexpandParams(ps), "bs", 61.withoutNoops(CajitaRewriter.this.expand(bindings.get("bs"), s2)), "fh", CajitaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
                scope.addStartStatement(new ExpressionStmt(node.getFilePosition(), expr));
                return new Noop(FilePosition.UNKNOWN);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="funcNamedSimpleValue", synopsis="", reason="", matches="function @fname(@ps*) { @bs*; }", substitutes="(function() {\n  function @fname(@ps*) {\n    @fh*;\n    @stmts*;\n    @bs*;\n  }\n  return ___.markFuncFreeze(@fRef, '@fname');\n})();")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                Identifier fname = CajitaRewriter.this.noexpand((Identifier)bindings.get("fname"));
                return this.substV("fname", fname, "fRef", new Reference(fname), "rf", 62.toStringLiteral(fname), "ps", CajitaRewriter.this.noexpandParams(ps), "bs", 62.withoutNoops(CajitaRewriter.this.expand(bindings.get("bs"), s2)), "fh", CajitaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="multiDeclaration", synopsis="Consider declarations separately from initializers", reason="", matches="var @a=@b?, @c=@d*", substitutes="{ @decl; @init; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof MultiDeclaration) {
                Expression initializer = null;
                for (Declaration declaration : ((MultiDeclaration)node).children()) {
                    Statement s = (Statement)CajitaRewriter.this.expand(declaration, scope);
                    if (s instanceof Noop) continue;
                    if (s instanceof ExpressionStmt) {
                        Expression init = ((ExpressionStmt)s).getExpression();
                        initializer = initializer == null ? init : Operation.createInfix(Operator.COMMA, initializer, init);
                        continue;
                    }
                    CajitaRewriter.requireErrors(CajitaRewriter.this.mq, s);
                    return node;
                }
                if (initializer == null) {
                    return new Noop(node.getFilePosition());
                }
                ExpressionStmt es = new ExpressionStmt(node.getFilePosition(), initializer);
                Scope.markForSideEffect(es);
                return es;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="mapBadKeyValueOf", synopsis="Statically reject 'valueOf' as a key", reason="We depend on valueOf returning consistent results.", matches="'valueOf': @f", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ObjProperty prop;
            StringLiteral key;
            if (node instanceof ObjProperty && "valueOf".equals((key = (prop = (ObjProperty)node).getPropertyNameNode()).getUnquotedValue())) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VALUEOF_PROPERTY_MUST_NOT_BE_SET, key.getFilePosition(), this, key);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="mapBadKeySuffix", synopsis="Statically reject a property whose name ends with `__`", reason="", matches="\"@k__\": @v", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ObjProperty prop;
            StringLiteral key;
            if (node instanceof ObjProperty && (key = (prop = (ObjProperty)node).getPropertyNameNode()).getUnquotedValue().endsWith("__")) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, key.getFilePosition(), this, key);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="objectProperty", synopsis="nymize object properties", reason="", matches="\"@k\": @v", substitutes="<nymized>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ObjProperty) {
                if (node instanceof ValueProperty) {
                    ValueProperty prop = (ValueProperty)node;
                    return new ParseTreeNodeContainer(Arrays.asList(CajitaRewriter.this.noexpand(prop.getPropertyNameNode()), CajitaRewriter.this.expand(this.nymize(prop.getValueExpr(), prop.getPropertyName(), "lit"), scope)));
                }
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.GETTERS_SETTERS_NOT_SUPPORTED, node.getFilePosition(), this);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="map", synopsis="Turns an object literal into an explicit initialization.", reason="", matches="({@key*: @val*})", substitutes="___.iM([@parts*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ObjectConstructor) {
                ObjectConstructor obj = (ObjectConstructor)node;
                List<? extends ObjProperty> props = obj.children();
                List<Expression> expanded = Lists.newArrayList();
                for (ObjProperty objProperty : props) {
                    ParseTreeNode nymized = CajitaRewriter.this.expand(objProperty, scope);
                    if (!(nymized instanceof ParseTreeNodeContainer)) continue;
                    for (ParseTreeNode parseTreeNode : nymized.children()) {
                        expanded.add((Expression)parseTreeNode);
                    }
                }
                return this.substV("parts", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="otherTypeof", synopsis="Typeof translates simply", reason="One of Caja's deviations from JavaScript is that reading a non-existent imported variable returns 'undefined' rather than throwing a ReferenceError. Therefore, in Caja, 'typeof' can always evaluate its argument.", matches="typeof @f", substitutes="___.typeOf(@f)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="inPublic", synopsis="Is a public property present on the object?", reason="", matches="@i in @o", substitutes="___.inPub(@i, @o)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="voidOp", synopsis="", reason="", matches="void @x", substitutes="void @x")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="commaOp", synopsis="", reason="", matches="(@a, @b)", substitutes="(@a, @b)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="breakStmt", synopsis="disallow labels that end in __", reason="", matches="break @a;", substitutes="break @a;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof BreakStmt) {
                String label = ((BreakStmt)node).getLabel();
                if (label.endsWith("__")) {
                    CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.LABELS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), MessagePart.Factory.valueOf(label));
                }
                return CajitaRewriter.this.noexpand((BreakStmt)node);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="continueStmt", synopsis="disallow labels that end in __", reason="", matches="continue @a;", substitutes="continue @a;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ContinueStmt) {
                String label = ((ContinueStmt)node).getLabel();
                if (label.endsWith("__")) {
                    CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.LABELS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), MessagePart.Factory.valueOf(label));
                }
                return CajitaRewriter.this.noexpand((ContinueStmt)node);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="regexLiteral", synopsis="Cajita requires use of the regular expression constructor", reason="Because JavaScript regex literal instances are shared by default, and regex literal lexing is difficult.", matches="/foo/", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof RegexpLiteral) {
                CajitaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.REGEX_LITERALS_NOT_IN_CAJITA, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="useSubsetDirective", synopsis="replace use subset directives with noops", reason="rewriting changes the block structure of the input, which could lead to a directive appearing in an illegal position since directives must appear at the beginning of a program or function body, not in an arbitrary block", matches="'use';", substitutes=";")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof DirectivePrologue) {
                return new Noop(node.getFilePosition());
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="recurse", synopsis="Automatically recurse into some structures", reason="", matches="<many>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ParseTreeNodeContainer || node instanceof ArrayConstructor || node instanceof CaseStmt || node instanceof Conditional || node instanceof DebuggerStmt || node instanceof DefaultCaseStmt || node instanceof ExpressionStmt || node instanceof FormalParam || node instanceof Identifier || node instanceof LabeledStmtWrapper || node instanceof Literal || node instanceof Loop || node instanceof Noop || node instanceof SimpleOperation || node instanceof ControlOperation || node instanceof ReturnStmt || node instanceof SwitchStmt || node instanceof ThrowStmt) {
                return this.expandAll(node, scope);
            }
            return NONE;
        }
    }};

    private static int lastRealJavascriptChild(List<? extends ParseTreeNode> nodes) {
        int lasti = nodes.size();
        while (--lasti >= 0 && nodes.get(lasti).getAttributes().is(Scope.FOR_SIDE_EFFECT)) {
        }
        return lasti;
    }

    public static ParseTreeNode getFunctionHeadDeclarations(Scope scope) {
        List<ParseTreeNode> stmts = Lists.newArrayList();
        if (scope.hasFreeArguments()) {
            stmts.add(QuasiBuilder.substV("var @la = ___.args(@ga);", "la", SyntheticNodes.s(new Identifier(FilePosition.UNKNOWN, "a___")), "ga", Rule.newReference(FilePosition.UNKNOWN, "arguments")));
        }
        return new ParseTreeNodeContainer(stmts);
    }

    public static ParseTreeNode returnLast(ParseTreeNode node) {
        ParseTreeNode result = null;
        if (node.getAttributes().is(Scope.FOR_SIDE_EFFECT)) {
            return node;
        }
        if (node instanceof ExpressionStmt) {
            result = new ExpressionStmt(node.getFilePosition(), (Expression)QuasiBuilder.substV("moduleResult___ = @result;", "result", ((ExpressionStmt)node).getExpression()));
        } else if (node instanceof ParseTreeNodeContainer) {
            List<? extends ParseTreeNode> nodes = Lists.newArrayList(node.children());
            int lasti = CajitaRewriter.lastRealJavascriptChild(nodes);
            if (lasti >= 0) {
                nodes.set(lasti, CajitaRewriter.returnLast(nodes.get(lasti)));
                result = new ParseTreeNodeContainer(nodes);
            }
        } else if (node instanceof Block) {
            List<? extends ParseTreeNode> stats = Lists.newArrayList();
            stats.addAll(node.children());
            int lasti = CajitaRewriter.lastRealJavascriptChild(stats);
            if (lasti >= 0) {
                stats.set(lasti, (Statement)CajitaRewriter.returnLast((ParseTreeNode)stats.get(lasti)));
                result = new Block(node.getFilePosition(), stats);
            }
        } else if (node instanceof Conditional) {
            List<? extends ParseTreeNode> nodes = Lists.newArrayList();
            nodes.addAll(node.children());
            int lasti = nodes.size() - 1;
            for (int i = 1; i <= lasti; i += 2) {
                nodes.set(i, CajitaRewriter.returnLast((ParseTreeNode)nodes.get(i)));
            }
            if ((lasti & 1) == 0) {
                nodes.set(lasti, CajitaRewriter.returnLast((ParseTreeNode)nodes.get(lasti)));
            }
            result = new Conditional(node.getFilePosition(), null, nodes);
        } else if (node instanceof TryStmt) {
            TryStmt tryer = (TryStmt)node;
            result = new TryStmt(node.getFilePosition(), (Block)CajitaRewriter.returnLast(tryer.getBody()), tryer.getCatchClause(), tryer.getFinallyClause());
        }
        if (null == result) {
            return node;
        }
        result.getAttributes().putAll(node.getAttributes());
        return result;
    }

    public CajitaRewriter(URI baseUri, ModuleManager moduleManager, boolean logging) {
        super(null == moduleManager ? null : moduleManager.getMessageQueue(), true, logging);
        this.buildInfo = null == moduleManager ? null : moduleManager.getBuildInfo();
        this.baseUri = baseUri;
        this.moduleManager = moduleManager;
        this.initRules();
    }

    public CajitaRewriter(BuildInfo buildInfo, MessageQueue mq, boolean logging) {
        super(mq, true, logging);
        this.buildInfo = buildInfo;
        this.baseUri = null;
        this.moduleManager = null;
        this.initRules();
    }

    private void initRules() {
        this.addRules(SyntheticRuleSet.syntheticRules(this));
        this.addRules(this.cajaRules);
    }

    private static void requireErrors(MessageQueue mq, ParseTreeNode n) {
        if (!mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            mq.addMessage((MessageTypeInt)RewriterMessageType.BAD_RESULT_FROM_RECURSIVE_CALL, n.getFilePosition(), n);
        }
    }
}

