/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.CaseStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.ControlOperation;
import com.google.caja.parser.js.DebuggerStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DefaultCaseStmt;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.GetterProperty;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.SimpleOperation;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SwitchStmt;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.parser.quasiliteral.SyntheticRuleSet;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RulesetDescription(name="ES5/3 Transformation Rules", synopsis="Default set of transformations used by ES5/3")
public class ES53Rewriter
extends Rewriter {
    private final BuildInfo buildInfo;
    private final URI baseUri;
    private final ModuleManager moduleManager;
    private final Set<StringLiteral> includedModules = Sets.newTreeSet(new Comparator<StringLiteral>(){

        @Override
        public int compare(StringLiteral o1, StringLiteral o2) {
            return o1.getUnquotedValue().compareTo(o2.getUnquotedValue());
        }
    });
    private final Set<StringLiteral> inlinedModules = Sets.newTreeSet(new Comparator<StringLiteral>(){

        @Override
        public int compare(StringLiteral o1, StringLiteral o2) {
            return o1.getUnquotedValue().compareTo(o2.getUnquotedValue());
        }
    });
    private static final FilePosition UNK = FilePosition.UNKNOWN;
    private final Rule[] cajaRules = new Rule[]{new Rule(){

        @RuleDescription(name="translatedCode", synopsis="Allow code received from a *->JS translator", reason="Translated code should not be treated as user supplied JS.", matches="<TranslatedCode>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof TranslatedCode) {
                Block rewritten = ((TranslatedCode)this.expandAll(node, scope)).getTranslation();
                Scope.markForSideEffect(rewritten);
                return rewritten;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="labeledStatement", synopsis="Statically reject if a label with `__` suffix is found", reason="Caja reserves the `__` suffix for internal use", matches="@lbl: @stmt;", substitutes="@lbl: @stmt;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String label;
            if (node instanceof LabeledStatement && (label = ((LabeledStatement)node).getLabel()).endsWith("__")) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.LABELS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), MessagePart.Factory.valueOf(label));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="loadmodule", synopsis="rewrites the load function.", reason="", matches="load(@arg)", substitutes="depending on whether moduleManager bundles modules")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isImported("load")) {
                ParseTreeNode arg = bindings.get("arg");
                if (arg instanceof StringLiteral) {
                    StringLiteral name = ES53Rewriter.this.noexpand((StringLiteral)arg);
                    if (ES53Rewriter.this.moduleManager != null) {
                        int moduleIndex = ES53Rewriter.this.moduleManager.getModule(ES53Rewriter.this.baseUri, name);
                        if (moduleIndex >= 0) {
                            ES53Rewriter.this.inlinedModules.add(name);
                            return QuasiBuilder.substV("moduleMap___[@moduleIndex]", "moduleIndex", new IntegerLiteral(UNK, moduleIndex));
                        }
                        ES53Rewriter.requireErrors(ES53Rewriter.this.mq, node);
                        return node;
                    }
                    ES53Rewriter.this.includedModules.add(name);
                    return QuasiBuilder.substV("load(@name)", "name", name);
                }
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_LOAD_A_DYNAMIC_ES53_MODULE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="moduleEnvelope", synopsis="Cajole an UncajoledModule into a CajoledModule. Note that the ouptut is a CajoledModule wrapper *around* thecontents of the 'substitutes' of this rule.", reason="So that the module loader can be invoked to load a module.", matches="<an UncajoledModule>", substitutes="(/*@synthetic*/{  instantiate: /*@synthetic*/function (___, IMPORTS___) {    /*var moduleResult___ = ___.NO_RESULT;*/    @rewrittenModuleStmts*;    /*return moduleResult___;*/  },  @metaKeys*: @metaValues*,  cajolerName: @cajolerName,  cajolerVersion: @cajolerVersion,  cajoledDate: @cajoledDate})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof UncajoledModule) {
                Statement returnStmt = (Statement)QuasiBuilder.substV("return moduleResult___;", new Object[0]);
                Scope.markForSideEffect(returnStmt);
                Block inputModuleStmts = (Block)QuasiBuilder.substV("var moduleResult___ = ___./*@synthetic*/NO_RESULT;@moduleBody*;@returnStmt", "moduleBody", new ParseTreeNodeContainer(((UncajoledModule)node).getModuleBody().children()), "returnStmt", returnStmt);
                Block rewrittenModuleStmts = (Block)ES53Rewriter.this.expand(inputModuleStmts, null);
                ParseTreeNodeContainer metaKeys = new ParseTreeNodeContainer();
                ParseTreeNodeContainer metaValues = new ParseTreeNodeContainer();
                if (!ES53Rewriter.this.includedModules.isEmpty()) {
                    metaKeys.appendChild(StringLiteral.valueOf(UNK, "includedModules"));
                    metaValues.appendChild(new ArrayConstructor(UNK, Lists.newArrayList(ES53Rewriter.this.includedModules)));
                }
                if (!ES53Rewriter.this.inlinedModules.isEmpty()) {
                    metaKeys.appendChild(StringLiteral.valueOf(UNK, "inlinedModules"));
                    metaValues.appendChild(new ArrayConstructor(UNK, Lists.newArrayList(ES53Rewriter.this.inlinedModules)));
                }
                ObjectConstructor moduleObjectLiteral = (ObjectConstructor)this.substV("rewrittenModuleStmts", ES53Rewriter.returnLast(rewrittenModuleStmts), "metaKeys", metaKeys, "metaValues", metaValues, "cajolerName", new StringLiteral(UNK, "com.google.caja"), "cajolerVersion", new StringLiteral(UNK, ES53Rewriter.this.buildInfo.getBuildVersion()), "cajoledDate", new IntegerLiteral(UNK, ES53Rewriter.this.buildInfo.getCurrentTime()));
                return new CajoledModule(moduleObjectLiteral);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="module", synopsis="Return last expr-statement", reason="Builds the module body encapsulation around the ES5/3 code block.", matches="{@ss*;}", substitutes="var dis___ = IMPORTS___; @startStmts*; @expanded*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block && scope == null) {
                Scope s2 = Scope.fromProgram((Block)node, ES53Rewriter.this.mq);
                List<ParseTreeNode> expanded = Lists.newArrayList();
                for (ParseTreeNode parseTreeNode : node.children()) {
                    ParseTreeNode expandedC = ES53Rewriter.this.expand(parseTreeNode, s2);
                    if (expandedC instanceof Noop) continue;
                    expanded.add(expandedC);
                }
                return this.substV("startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "expanded", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="block", synopsis="Initialize named functions at the beginning of their enclosing block.", reason="Nested named function declarations are illegal in ES3 but are universally supported by all JavaScript implementations, though in different ways. The compromise semantics currently supported by ES5/3 is to hoist the declaration of a variable with the function's name to the beginning of the enclosing function body or module top level, and to initialize this variable to a new anonymous function every time control re-enters the enclosing block.\nNote that ES-Harmony will specify a better and safer semantics -- block level lexical scoping -- that we'd like to adopt into ES5/3 eventually. However, it is so challenging to implement this semantics by translation to currently-implemented JavaScript that we provide something quicker and dirtier for now.", matches="{@ss*;}", substitutes="@startStmts*; @ss*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block) {
                List<? extends Statement> expanded = Lists.newArrayList();
                Scope s2 = Scope.fromPlainBlock(scope);
                for (Statement statement : ((Block)node).children()) {
                    ParseTreeNode rewritten = ES53Rewriter.this.expand(statement, s2);
                    if (rewritten.getClass() == Block.class) {
                        expanded.addAll(((Block)rewritten).children());
                        continue;
                    }
                    if (rewritten instanceof Noop) continue;
                    expanded.add((Statement)rewritten);
                }
                return this.substV("startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "ss", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="with", synopsis="Statically reject if a `with` block is found.", reason="`with` violates the assumptions made by Scope, and makes it very hard to write a Scope that works. http://yuiblog.com/blog/2006/04/11/with-statement-considered-harmful/ briefly touches on why `with` is bad for programmers. For reviewers: matching of references with declarations can only be done at runtime. All other secure JS subsets that we know of (ADSafe, Jacaranda, & FBJS) also disallow `with`.", matches="with (@scope) @body;", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.WITH_BLOCKS_NOT_ALLOWED, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="foreachExpr", synopsis="Get the keys, then iterate over them.", reason="", matches="for (@k in @o) @ss;", substitutes="for (@tkeys = ___.allEnumKeys(@o),     @tidx = 0,     @tlen = @tkeys.length;\n     @tidx < @tlen; ++@tidx) {\n  @assign;\n  @ss;\n}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Expression k;
                Statement ks = (Statement)bindings.get("k");
                if (ks instanceof ExpressionStmt) {
                    k = ((ExpressionStmt)ks).getExpression();
                } else {
                    Declaration d = (Declaration)ks;
                    if (d.getInitializer() != null || d.getIdentifierName().endsWith("__")) {
                        return NONE;
                    }
                    k = new Reference(d.getIdentifier());
                    k.getAttributes().set(ParseTreeNode.TAINTED, true);
                    scope.addStartOfScopeStatement((Statement)ES53Rewriter.this.expand(d, scope));
                }
                Reference tkeys = new Reference(scope.declareStartOfScopeTempVariable());
                Reference tidx = new Reference(scope.declareStartOfScopeTempVariable());
                Reference tlen = new Reference(scope.declareStartOfScopeTempVariable());
                FilePosition unk = FilePosition.UNKNOWN;
                Operation assign = Operation.create(unk, Operator.ASSIGN, k, Operation.create(unk, Operator.SQUARE_BRACKET, tkeys, Operation.create(unk, Operator.TO_NUMBER, tidx)));
                assign.getAttributes().set(ParseTreeNode.TAINTED, true);
                return this.substV("tidx", tidx, "tlen", tlen, "tkeys", tkeys, "o", ES53Rewriter.this.expand(bindings.get("o"), scope), "assign", 10.newExprStmt((Expression)ES53Rewriter.this.expand(assign, scope)), "ss", ES53Rewriter.this.expand(bindings.get("ss"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryCatch", synopsis="Ensure that only immutable data is thrown, and repair scope confusion in existing JavaScript implementations of try/catch.", reason="When manually reviewing code for vulnerability, experience shows that reviewers cannot pay adequate attention to the pervasive possibility of thrown exceptions. These lead to four dangers: 1) leaking an authority-bearing object, endangering integrity, 2) leaking a secret, endangering secrecy, and 3) aborting a partially completed state update, leaving the state malformed, endangering integrity, and 4) preventing an operation that was needed, endangering availability. Caja only seeks to make strong claims about integrity. By ensuring that only immutable (transitively frozen) data is thrown, we prevent problem #1. For the others, programmer vigilance is still needed. \nCurrent JavaScript implementations fail, in different ways, to implement the scoping of the catch variable specified in ES3. We translate Caja to JavaScript so as to implement the ES3 specified scoping on current JavaScript implementations.", matches="try { @s0*; } catch (@x) { @s1*; }", substitutes="try {\n  @s0*;\n} catch (ex___) {\n  try {\n    throw ___.tameException(ex___); \n  } catch (@x) {\n    @s1*;\n  }\n}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                TryStmt t = (TryStmt)node;
                Identifier exceptionName = t.getCatchClause().getException().getIdentifier();
                if (exceptionName.getName().endsWith("__")) {
                    ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                    return node;
                }
                return this.substV("s0", 11.withoutNoops(this.expandAll(bindings.get("s0"), scope)), "x", ES53Rewriter.this.noexpand((Identifier)bindings.get("x")), "s1", 11.withoutNoops(this.expandAll(bindings.get("s1"), Scope.fromCatchStmt(scope, t.getCatchClause()))));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryCatchFinally", synopsis="Finally adds no special issues beyond those explained in try/catch.", reason="Caja is not attempting to impose determinism, so the reasons for Joe-E to avoid finally do not apply.", matches="try { @s0*; } catch (@x) { @s1*; } finally { @s2*; }", substitutes="try {\n  @s0*;\n} catch (ex___) {\n  try {\n    throw ___.tameException(ex___);\n  } catch (@x) {\n    @s1*;\n  }\n} finally {\n  @s2*;\n}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                TryStmt t = (TryStmt)node;
                Identifier exceptionName = t.getCatchClause().getException().getIdentifier();
                if (exceptionName.getName().endsWith("__")) {
                    ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                    return node;
                }
                return this.substV("s0", 12.withoutNoops(this.expandAll(bindings.get("s0"), scope)), "x", ES53Rewriter.this.noexpand((Identifier)bindings.get("x")), "s1", 12.withoutNoops(this.expandAll(bindings.get("s1"), Scope.fromCatchStmt(scope, t.getCatchClause()))), "s2", 12.withoutNoops(this.expandAll(bindings.get("s2"), scope)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryFinally", synopsis="See bug 383. Otherwise, it's just the trivial translation.", reason="try/finally actually seems to work as needed by current JavaScript implementations.", matches="try { @s0*; } finally { @s1*; }", substitutes="try { @s0*; } finally { @s1*; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="varArgs", synopsis="Make all references to the magic \"arguments\" variable into references to a fake arguments object", reason="ES3 specifies that the magic \"arguments\" variable is a dynamic (\"joined\") mutable array-like reflection of the values of the parameter variables. However, the typical usage is to pass it to provide access to one's original arguments, without the intention of providing the ability to mutate the caller's parameter variables. By making a fake arguments object with no \"callee\" property, we provide the least authority assumed by this typical use.\nThe fake is made with a \"var a___ = ___.args(arguments);\" generated at the beginning of the function body.", matches="arguments", substitutes="a___")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="varThis", synopsis="Replace \"this\" with \"dis___\".", reason="The rules for binding of \"this\" in JavaScript are dangerous.", matches="this", substitutes="dis___")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="varBadSuffix", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@v__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varBadSuffixDeclaration", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="<approx>(var|function) @v__ ...", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier name;
            if (node instanceof Declaration && (name = ((Declaration)node).getIdentifier()).getValue().endsWith("__")) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varGlobal", synopsis="Global vars are rewritten to be properties of IMPORTS___.", reason="", matches="@v", substitutes="IMPORTS___.@fp ?IMPORTS___.@v :___.ri(IMPORTS___, @vname)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference vRef;
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference && scope.isOuter((vRef = (Reference)v).getIdentifierName())) {
                return this.substV("fp", 18.newReference(vRef.getFilePosition(), vRef.getIdentifierName() + "_v___"), "v", ES53Rewriter.this.noexpand(vRef), "vname", 18.toStringLiteral(v));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="varDefault", synopsis="Any remaining uses of a variable name are preserved.", reason="", matches="@v", substitutes="@v")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference) {
                return ES53Rewriter.this.noexpand((Reference)v);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readBadSuffix", synopsis="Statically reject if a property has `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@x.@p__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="getLength", synopsis="", reason="Length is whitelisted on Object.prototype", matches="@o.length", substitutes="@o.length")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="get", synopsis="", reason="", matches="@o.@p", substitutes="@oRef.@fp ? @oRef.@p : @oRef.v___('@p')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Reference p = (Reference)bindings.get("p");
                String propertyName = p.getIdentifierName();
                return this.commas((Expression)oPair.b, (Expression)this.substV("oRef", oPair.a, "p", ES53Rewriter.this.noexpand(p), "fp", 22.newReference(p.getFilePosition(), propertyName + "_v___"), "rp", 22.toStringLiteral(p)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readNum", synopsis="Recognize that array indexing is inherently safe.", reason="When the developer knows that their index expression is an array index, they can indicate this with the 'known-numeric operator'. Since these properties are necessarily readable, we can pass them  through directly to JavaScript. We don't support Firefox 2, which exposes authority on negative indices of some objects.", matches="@o[+@s]", substitutes="@o[+@s]")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="readNumWithConstantIndex", synopsis="Recognize that array indexing is inherently safe.", reason="Numeric properties are always readable; we can pass these through directly to JavaScript. We don't support Firefox 2 or 3, which expose authority on negative indices of some objects.", matches="@o[@numLiteral]", substitutes="@o[@numLiteral]")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode index;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (index = bindings.get("numLiteral")) instanceof NumberLiteral) {
                return this.substV("o", ES53Rewriter.this.expand(bindings.get("o"), scope), "numLiteral", ES53Rewriter.this.expand(index, scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readIndex", synopsis="", reason="", matches="@o[@s]", substitutes="@o.v___(@s)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="setBadVariable", synopsis="Statically reject if an expression assigns to an unmaskable variable.", reason="arguments and eval are not allowed to be written to.", matches="@import = @y", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String name;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("import") instanceof Reference && Scope.UNMASKABLE_IDENTIFIERS.contains(name = ((Reference)bindings.get("import")).getIdentifierName())) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_MASK_IDENTIFIER, node.getFilePosition(), MessagePart.Factory.valueOf(name));
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="initGlobalVar", synopsis="", reason="", matches="/* in outer scope */ var @v = @r", substitutes="IMPORTS___.w___('@v', @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier v;
            String vname;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isOuter(vname = (v = (Identifier)bindings.get("v")).getName())) {
                ParseTreeNode r = bindings.get("r");
                return 27.newExprStmt((Expression)this.substV("v", v, "r", ES53Rewriter.this.expand(this.nymize(r, vname, "var"), scope)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setGlobalVar", synopsis="", reason="", matches="/* declared in outer scope */ @v = @r", substitutes="IMPORTS___.@fp ?IMPORTS___.@v = @r :___.wi(IMPORTS___, '@v', @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference vRef;
            String vname;
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference && scope.isOuter(vname = (vRef = (Reference)v).getIdentifierName())) {
                ParseTreeNode r = bindings.get("r");
                return this.substV("v", ES53Rewriter.this.noexpand(vRef), "fp", 28.newReference(vRef.getFilePosition(), vRef.getIdentifierName() + "_w___"), "r", ES53Rewriter.this.expand(this.nymize(r, vname, "var"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="declGlobalVar", synopsis="", reason="", matches="/* in outer scope */ var @v", substitutes="___.di(IMPORTS___, '@v')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("v") instanceof Identifier && scope.isOuter(((Identifier)bindings.get("v")).getName())) {
                ExpressionStmt es = 29.newExprStmt((Expression)this.substV("v", bindings.get("v")));
                Scope.markForSideEffect(es);
                return es;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadSuffix", synopsis="Statically reject if a property with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@x.@p__ = @z", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="set", synopsis="Set a property.", reason="", matches="@o.@p = @r", substitutes="<approx> @o.w___(@'p', @r);")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Reference p = (Reference)bindings.get("p");
                String propertyName = p.getIdentifierName();
                ParseTreeNode r = bindings.get("r");
                Pair<Expression, Expression> rPair = this.reuse(this.nymize(r, propertyName, "meth"), scope);
                return this.commas((Expression)oPair.b, (Expression)rPair.b, (Expression)QuasiBuilder.substV("@oRef.@pWritable === @oRef ? (@oRef.@p = @rRef) :                            @oRef.w___(@pName, @rRef);", "oRef", oPair.a, "rRef", rPair.a, "pWritable", 31.newReference(UNK, propertyName + "_w___"), "p", ES53Rewriter.this.noexpand(p), "pName", 31.toStringLiteral(p)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setNumericIndex", synopsis="Set a property marked as numeric.", reason="", matches="@o[+@p] = @r", substitutes="<approx> @o.w___(+@p, @r);")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Expression p = (Expression)bindings.get("p");
                ParseTreeNode r = bindings.get("r");
                Pair<Expression, Expression> rPair = this.reuse(this.nymize(r, "", "meth"), scope);
                return this.commas((Expression)oPair.b, (Expression)rPair.b, (Expression)QuasiBuilder.substV("@oRef.NUM____w___ === @oRef ? (@oRef[+@p] = @rRef) :                            @oRef.w___(+@p, @rRef);", "oRef", oPair.a, "rRef", rPair.a, "p", ES53Rewriter.this.expand(p, scope)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setNumericLiteralIndex", synopsis="Set a numeric literal property.", reason="", matches="@o[@numLiteral] = @r", substitutes="<approx> @o.w___(@numLiteral, @r);")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode index;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (index = bindings.get("numLiteral")) instanceof NumberLiteral) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                ParseTreeNode r = bindings.get("r");
                Pair<Expression, Expression> rPair = this.reuse(this.nymize(r, index.toString(), "meth"), scope);
                return this.commas((Expression)oPair.b, (Expression)rPair.b, (Expression)QuasiBuilder.substV("(@oRef.NUM____w___ === @oRef) ?     (@oRef[@numLiteral] = @rRef) :     @oRef.w___(@numLiteral, @rRef);", "oRef", oPair.a, "rRef", rPair.a, "numLiteral", ES53Rewriter.this.noexpand((NumberLiteral)index)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIndex", synopsis="", reason="", matches="@o[@s] = @r", substitutes="@o.w___(@s, @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", ES53Rewriter.this.expand(bindings.get("o"), scope), "s", ES53Rewriter.this.expand(bindings.get("s"), scope), "r", ES53Rewriter.this.expand(bindings.get("r"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadInitialize", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="var @v__ = @r", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setInitialize", synopsis="Ensure v is not a function name. Expand the right side.", reason="vars and functions have different scoping.", matches="var @v = @r", substitutes="@v = @r")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && !scope.isFunction((v = (Identifier)bindings.get("v")).getName())) {
                ParseTreeNode r = bindings.get("r");
                scope.addStartOfScopeStatement(new Declaration(v.getFilePosition(), v, null));
                ExpressionStmt init = new ExpressionStmt(node.getFilePosition(), (Expression)this.substV("v", new Reference(ES53Rewriter.this.noexpand(v)), "r", ES53Rewriter.this.expand(this.nymize(r, v.getName(), "var"), scope)));
                Scope.markForSideEffect(init);
                return init;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadDeclare", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="var @v__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setDeclare", synopsis="Ensure that v isn't a function name.", reason="vars and functions have different scoping.", matches="var @v", substitutes="var @v")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier id;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && !scope.isFunction((id = (Identifier)bindings.get("v")).getName())) {
                scope.addStartOfScopeStatement((Declaration)this.substV("v", ES53Rewriter.this.noexpand((Identifier)bindings.get("v"))));
                return new Noop(node.getFilePosition());
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setBadVar", synopsis="Statically reject if a variable with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@v__ = @r", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setVar", synopsis="Plain old assignment.", reason="", matches="@v = @r", substitutes="@v = @r")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference) {
                String vname = 40.getReferenceName(v);
                ParseTreeNode r = bindings.get("r");
                return this.substV("v", ES53Rewriter.this.noexpand((Reference)v), "r", ES53Rewriter.this.expand(this.nymize(r, vname, "var"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setReadModifyWriteLocalVar", synopsis="", reason="", matches="<approx> @x @op= @y", substitutes="<approx> @x = @x @op @y")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof AssignOperation) {
                AssignOperation aNode = (AssignOperation)node;
                Operator op = aNode.getOperator();
                if (op.getAssignmentDelegate() == null) {
                    return NONE;
                }
                Rule.ReadAssignOperands ops = this.deconstructReadAssignOperand(aNode.children().get(0), scope);
                if (ops == null) {
                    return node;
                }
                Operation rhs = Operation.create(aNode.children().get(0).getFilePosition(), op.getAssignmentDelegate(), ops.getUncajoledLValue(), aNode.children().get(1));
                Operation assignment = ops.makeAssignment(rhs);
                return this.commas(this.newCommaOperation(ops.getTemporaries()), (Expression)ES53Rewriter.this.expand(assignment, scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIncrDecr", synopsis="Handle pre and post ++ and --.", matches="<approx> ++@x but any {pre,post}{in,de}crement will do", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (!(node instanceof AssignOperation)) {
                return NONE;
            }
            AssignOperation op = (AssignOperation)node;
            Expression v = op.children().get(0);
            Rule.ReadAssignOperands ops = this.deconstructReadAssignOperand(v, scope);
            if (ops == null) {
                return node;
            }
            switch (op.getOperator()) {
                case POST_INCREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("@v ++", "v", ops.getCajoledLValue());
                    }
                    Reference tmpVal = new Reference(scope.declareStartOfScopeTempVariable());
                    Expression assign = (Expression)ES53Rewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@tmpVal + 1", "tmpVal", tmpVal)), scope);
                    return QuasiBuilder.substV("  @tmps,@tmpVal = +@rvalue,@assign,@tmpVal", "tmps", this.newCommaOperation(ops.getTemporaries()), "tmpVal", tmpVal, "rvalue", ops.getCajoledLValue(), "assign", assign);
                }
                case PRE_INCREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("++@v", "v", ops.getCajoledLValue());
                    }
                    if (ops.getTemporaries().isEmpty()) {
                        return ES53Rewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - -1", "rvalue", ops.getUncajoledLValue())), scope);
                    }
                    return QuasiBuilder.substV("  @tmps,@assign", "tmps", this.newCommaOperation(ops.getTemporaries()), "assign", ES53Rewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - -1", "rvalue", ops.getUncajoledLValue())), scope));
                }
                case POST_DECREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("@v--", "v", ops.getCajoledLValue());
                    }
                    Reference tmpVal = new Reference(scope.declareStartOfScopeTempVariable());
                    Expression assign = (Expression)ES53Rewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@tmpVal - 1", "tmpVal", tmpVal)), scope);
                    return QuasiBuilder.substV("  @tmps,@tmpVal = +@rvalue,@assign,@tmpVal;", "tmps", this.newCommaOperation(ops.getTemporaries()), "tmpVal", tmpVal, "rvalue", ops.getCajoledLValue(), "assign", assign);
                }
                case PRE_DECREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("--@v", "v", ops.getCajoledLValue());
                    }
                    if (ops.getTemporaries().isEmpty()) {
                        return ES53Rewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - 1", "rvalue", ops.getUncajoledLValue())), scope);
                    }
                    return QuasiBuilder.substV("  @tmps,@assign", "tmps", this.newCommaOperation(ops.getTemporaries()), "assign", ES53Rewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - 1", "rvalue", ops.getUncajoledLValue())), scope));
                }
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="newCalllessCtor", synopsis="Add missing empty argument list.", reason="JavaScript syntax allows constructor calls without \"()\".", matches="new @ctor", substitutes="new @ctor.new___()")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="newCtor", synopsis="", reason="", matches="new @ctor(@as*)", substitutes="new @ctor.new___(@as*)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="deleteBadSuffix", synopsis="", reason="", matches="delete @o.@p__", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="delete", synopsis="", reason="", matches="delete @o.@p", substitutes="@o.c___(@'p')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Reference p = (Reference)bindings.get("p");
                return QuasiBuilder.substV("@o.c___(@pname)", "o", ES53Rewriter.this.expand(bindings.get("o"), scope), "pname", 46.toStringLiteral(p));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deleteIndex", synopsis="", reason="", matches="delete @o[@s]", substitutes="@o.c___(@s)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", ES53Rewriter.this.expand(bindings.get("o"), scope), "s", ES53Rewriter.this.expand(bindings.get("s"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deleteNonProperty", synopsis="", reason="", matches="delete @v", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.NOT_DELETABLE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callBadSuffix", synopsis="Statically reject if a selector with `__` suffix is found.", reason="Caja reserves the `__` suffix for internal use.", matches="@o.@p__(@as*)", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.SELECTORS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), this, node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callMethod", synopsis="", reason="", matches="@o.@m(@as*)", substitutes="<approx> @o.m___(@'m', [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Pair<Expression, Expression> oPair = this.reuse(bindings.get("o"), scope);
                Reference m = (Reference)bindings.get("m");
                Pair<ParseTreeNodeContainer, Expression> argsPair = this.reuseAll(bindings.get("as"), scope);
                String methodName = m.getIdentifierName();
                return this.commas((Expression)oPair.b, (Expression)argsPair.b, (Expression)QuasiBuilder.substV("@oRef.@fm ? @oRef.@m(@argRefs*) : @oRef.m___(@rm, [@argRefs*]);", "oRef", oPair.a, "argRefs", argsPair.a, "m", ES53Rewriter.this.noexpand(m), "fm", 50.newReference(UNK, methodName + "_m___"), "rm", 50.toStringLiteral(m)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callIndexedMethod", synopsis="", reason="", matches="@o[@s](@as*)", substitutes="@o.m___(@s, [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="callFunc", synopsis="", reason="", matches="@f(@as*)", substitutes="@f.i___(@as*)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="funcAnonSimple", synopsis="", reason="", matches="function (@ps*) { @bs*; }", substitutes="___.f(function (@ps*) {\n  @fh*;\n  @stmts*;\n  @bs*;\n})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                return this.substV("ps", ES53Rewriter.this.noexpandParams(ps), "bs", 53.withoutNoops(ES53Rewriter.this.expand(bindings.get("bs"), s2)), "fh", ES53Rewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="funcNamedDecl", synopsis="", reason="", matches="function @fname(@ps*) { @bs*; }", substitutes="function @fname(@ps*) {\n  @fh*;\n  @stmts*;\n  @bs*;\n}\n___.f(@fRef, '@fname');")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings;
            if (node instanceof FunctionDeclaration && !scope.isOuter() && (bindings = this.match(((FunctionDeclaration)node).getInitializer())) != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, ((FunctionDeclaration)node).getInitializer());
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                Identifier fname = ES53Rewriter.this.noexpand((Identifier)bindings.get("fname"));
                scope.declareStartOfScopeVariable(fname);
                Statement stmt = (Statement)this.substV("fname", fname, "fRef", new Reference(fname), "ps", ES53Rewriter.this.noexpandParams(ps), "bs", 54.withoutNoops(ES53Rewriter.this.expand(bindings.get("bs"), s2)), "fh", ES53Rewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
                scope.addStartStatement(stmt);
                return new Noop(FilePosition.UNKNOWN);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="funcNamedTopDecl", synopsis="", reason="", matches="function @fname(@ps*) { @bs*; }", substitutes="function @fname(@ps*) {\n  @fh*;\n  @stmts*;\n  @bs*;\n}\nIMPORTS___.w___('@fname', ___.f(@fRef, '@fname'));")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings;
            if (node instanceof FunctionDeclaration && scope.isOuter() && (bindings = this.match(((FunctionDeclaration)node).getInitializer())) != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, ((FunctionDeclaration)node).getInitializer());
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                Identifier fname = ES53Rewriter.this.noexpand((Identifier)bindings.get("fname"));
                Statement stmt = (Statement)this.substV("fname", fname, "fRef", new Reference(fname), "ps", ES53Rewriter.this.noexpandParams(ps), "bs", 55.withoutNoops(ES53Rewriter.this.expand(bindings.get("bs"), s2)), "fh", ES53Rewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
                scope.addStartStatement(stmt);
                return new Noop(FilePosition.UNKNOWN);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="funcNamedValue", synopsis="", reason="", matches="function @fname(@ps*) { @bs*; }", substitutes="(function () {\n  function @fname(@ps*) {\n    @fh*;\n    @stmts*;\n    @bs*;\n  }\n  return ___.f(@fRef, '@fname');})()")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                ParseTreeNodeContainer ps = (ParseTreeNodeContainer)bindings.get("ps");
                this.checkFormals(ps);
                Identifier fname = ES53Rewriter.this.noexpand((Identifier)bindings.get("fname"));
                return this.substV("fname", fname, "fRef", new Reference(fname), "ps", ES53Rewriter.this.noexpandParams(ps), "bs", 56.withoutNoops(ES53Rewriter.this.expand(bindings.get("bs"), s2)), "fh", ES53Rewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="multiDeclaration", synopsis="Consider declarations separately from initializers", reason="", matches="var @a=@b?, @c=@d*", substitutes="{ @decl; @init; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof MultiDeclaration) {
                Expression initializer = null;
                for (Declaration declaration : ((MultiDeclaration)node).children()) {
                    Statement s = (Statement)ES53Rewriter.this.expand(declaration, scope);
                    if (s instanceof Noop) continue;
                    if (s instanceof ExpressionStmt) {
                        Expression init = ((ExpressionStmt)s).getExpression();
                        initializer = initializer == null ? init : Operation.createInfix(Operator.COMMA, initializer, init);
                        continue;
                    }
                    ES53Rewriter.requireErrors(ES53Rewriter.this.mq, s);
                    return node;
                }
                if (initializer == null) {
                    return new Noop(node.getFilePosition());
                }
                ExpressionStmt es = new ExpressionStmt(node.getFilePosition(), initializer);
                Scope.markForSideEffect(es);
                return es;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="mapBadKeySuffix", synopsis="Statically reject a property whose name ends with `__`", reason="", matches="\"@k__\": @v", substitutes="<reject>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            ObjProperty prop;
            StringLiteral key;
            if (node instanceof ObjProperty && (key = (prop = (ObjProperty)node).getPropertyNameNode()).getUnquotedValue().endsWith("__")) {
                ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE, key.getFilePosition(), this, key);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="objectProperty", synopsis="nymize object properties", reason="", matches="\"@k\": @v", substitutes="<nymized>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ObjProperty) {
                if (node instanceof ValueProperty) {
                    ValueProperty prop = (ValueProperty)node;
                    return new ParseTreeNodeContainer(Arrays.asList(ES53Rewriter.this.noexpand(prop.getPropertyNameNode()), ES53Rewriter.this.expand(this.nymize(prop.getValueExpr(), prop.getPropertyName(), "lit"), scope)));
                }
                StringLiteral k = (StringLiteral)node.children().get(0);
                String kType = node instanceof GetterProperty ? "get" : "set";
                String kName = k.getUnquotedValue() + (node instanceof GetterProperty ? "_g___" : "_s___");
                Expression v = (Expression)node.children().get(1);
                return new ParseTreeNodeContainer(Arrays.asList(QuasiBuilder.substV("[@k, '" + kType + "']", "k", ES53Rewriter.this.noexpand(k)), ES53Rewriter.this.expand(this.nymize(v, kName, "lit"), scope)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="map", synopsis="Turns an object literal into an explicit initialization.", reason="", matches="({@key*: @val*})", substitutes="___.iM([@parts*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ObjectConstructor) {
                ObjectConstructor obj = (ObjectConstructor)node;
                List<? extends ObjProperty> props = obj.children();
                List<Expression> expanded = Lists.newArrayList();
                for (ObjProperty objProperty : props) {
                    ParseTreeNode nymized = ES53Rewriter.this.expand(objProperty, scope);
                    if (!(nymized instanceof ParseTreeNodeContainer)) continue;
                    for (ParseTreeNode parseTreeNode : nymized.children()) {
                        expanded.add((Expression)parseTreeNode);
                    }
                }
                return this.substV("parts", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="typeofGlobal", synopsis="Don't throw a ReferenceError", reason="", matches="typeof @v", substitutes="typeof @v")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference vRef;
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference && scope.isOuter((vRef = (Reference)v).getIdentifierName())) {
                return QuasiBuilder.substV("typeof IMPORTS___.v___(@vname)", "vname", 61.toStringLiteral(v));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="typeof", synopsis="Typeof translates simply", reason="", matches="typeof @v", substitutes="typeof @v")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="in", synopsis="Is a property present on the object?", reason="", matches="@i in @o", substitutes="___.i('' + @i, @o)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="voidOp", synopsis="", reason="", matches="void @x", substitutes="void @x")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="commaOp", synopsis="", reason="", matches="(@a, @b)", substitutes="(@a, @b)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="breakStmt", synopsis="disallow labels that end in __", reason="", matches="break @a;", substitutes="break @a;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof BreakStmt) {
                String label = ((BreakStmt)node).getLabel();
                if (label.endsWith("__")) {
                    ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.LABELS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), MessagePart.Factory.valueOf(label));
                }
                return ES53Rewriter.this.noexpand((BreakStmt)node);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="continueStmt", synopsis="disallow labels that end in __", reason="", matches="continue @a;", substitutes="continue @a;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ContinueStmt) {
                String label = ((ContinueStmt)node).getLabel();
                if (label.endsWith("__")) {
                    ES53Rewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.LABELS_CANNOT_END_IN_DOUBLE_UNDERSCORE, node.getFilePosition(), MessagePart.Factory.valueOf(label));
                }
                return ES53Rewriter.this.noexpand((ContinueStmt)node);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="regexLiteral", synopsis="Use the regular expression constructor", reason="So that every use of a regex literal creates a new instance to prevent state from leaking via interned literals. This is consistent with the way ES4 treates regex literals.", substitutes="new RegExp.new___(@pattern, @modifiers?)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof RegexpLiteral) {
                RegexpLiteral.RegexpWrapper re = ((RegexpLiteral)node).getValue();
                FilePosition pos = node.getFilePosition();
                StringLiteral pattern = StringLiteral.valueOf(pos, re.getMatchText());
                StringLiteral modifiers = !"".equals(re.getModifiers()) ? StringLiteral.valueOf(pos, re.getModifiers()) : null;
                return this.substV("pattern", pattern, "modifiers", modifiers);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="useSubsetDirective", synopsis="replace use subset directives with noops", reason="rewriting changes the block structure of the input, which could lead to a directive appearing in an illegal position since directives must appear at the beginning of a program or function body, not in an arbitrary block", matches="'use';", substitutes=";")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof DirectivePrologue) {
                return new Noop(node.getFilePosition());
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="recurse", synopsis="Automatically recurse into some structures", reason="", matches="<many>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ParseTreeNodeContainer || node instanceof ArrayConstructor || node instanceof CaseStmt || node instanceof Conditional || node instanceof DebuggerStmt || node instanceof DefaultCaseStmt || node instanceof ExpressionStmt || node instanceof FormalParam || node instanceof Identifier || node instanceof LabeledStmtWrapper || node instanceof Literal || node instanceof Loop || node instanceof Noop || node instanceof SimpleOperation || node instanceof ControlOperation || node instanceof ReturnStmt || node instanceof SwitchStmt || node instanceof ThrowStmt) {
                return this.expandAll(node, scope);
            }
            return NONE;
        }
    }};

    private static int lastRealJavascriptChild(List<? extends ParseTreeNode> nodes) {
        int lasti = nodes.size();
        while (--lasti >= 0 && nodes.get(lasti).getAttributes().is(Scope.FOR_SIDE_EFFECT)) {
        }
        return lasti;
    }

    public static ParseTreeNode getFunctionHeadDeclarations(Scope scope) {
        List<ParseTreeNode> stmts = Lists.newArrayList();
        if (scope.hasFreeArguments()) {
            stmts.add(QuasiBuilder.substV("___.deodorize(@ga, -6);var @la = ___.args(@ga);", "la", SyntheticNodes.s(new Identifier(FilePosition.UNKNOWN, "a___")), "ga", Rule.newReference(FilePosition.UNKNOWN, "arguments")));
        }
        if (scope.hasFreeThis()) {
            stmts.add(QuasiBuilder.substV("var dis___ = (this && this.___) ? void 0 : this;", new Object[0]));
        }
        return new ParseTreeNodeContainer(stmts);
    }

    public static ParseTreeNode returnLast(ParseTreeNode node) {
        ParseTreeNode result = null;
        if (node.getAttributes().is(Scope.FOR_SIDE_EFFECT)) {
            return node;
        }
        if (node instanceof ExpressionStmt) {
            result = new ExpressionStmt(node.getFilePosition(), (Expression)QuasiBuilder.substV("moduleResult___ = @result;", "result", ((ExpressionStmt)node).getExpression()));
        } else if (node instanceof ParseTreeNodeContainer) {
            List<? extends ParseTreeNode> nodes = Lists.newArrayList(node.children());
            int lasti = ES53Rewriter.lastRealJavascriptChild(nodes);
            if (lasti >= 0) {
                nodes.set(lasti, ES53Rewriter.returnLast(nodes.get(lasti)));
                result = new ParseTreeNodeContainer(nodes);
            }
        } else if (node instanceof Block) {
            List<? extends ParseTreeNode> stats = Lists.newArrayList();
            stats.addAll(node.children());
            int lasti = ES53Rewriter.lastRealJavascriptChild(stats);
            if (lasti >= 0) {
                stats.set(lasti, (Statement)ES53Rewriter.returnLast((ParseTreeNode)stats.get(lasti)));
                result = new Block(node.getFilePosition(), stats);
            }
        } else if (node instanceof Conditional) {
            List<? extends ParseTreeNode> nodes = Lists.newArrayList();
            nodes.addAll(node.children());
            int lasti = nodes.size() - 1;
            for (int i = 1; i <= lasti; i += 2) {
                nodes.set(i, ES53Rewriter.returnLast((ParseTreeNode)nodes.get(i)));
            }
            if ((lasti & 1) == 0) {
                nodes.set(lasti, ES53Rewriter.returnLast((ParseTreeNode)nodes.get(lasti)));
            }
            result = new Conditional(node.getFilePosition(), null, nodes);
        } else if (node instanceof TryStmt) {
            TryStmt tryer = (TryStmt)node;
            result = new TryStmt(node.getFilePosition(), (Block)ES53Rewriter.returnLast(tryer.getBody()), tryer.getCatchClause(), tryer.getFinallyClause());
        }
        if (null == result) {
            return node;
        }
        result.getAttributes().putAll(node.getAttributes());
        return result;
    }

    public ES53Rewriter(URI baseUri, ModuleManager moduleManager, boolean logging) {
        super(null == moduleManager ? null : moduleManager.getMessageQueue(), true, logging);
        this.buildInfo = null == moduleManager ? null : moduleManager.getBuildInfo();
        this.baseUri = baseUri;
        this.moduleManager = moduleManager;
        this.initRules();
    }

    public ES53Rewriter(BuildInfo buildInfo, MessageQueue mq, boolean logging) {
        super(mq, true, logging);
        this.buildInfo = buildInfo;
        this.baseUri = null;
        this.moduleManager = null;
        this.initRules();
    }

    private void initRules() {
        this.addRules(SyntheticRuleSet.syntheticRules(this));
        this.addRules(this.cajaRules);
    }

    private static void requireErrors(MessageQueue mq, ParseTreeNode n) {
        if (!mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            mq.addMessage((MessageTypeInt)RewriterMessageType.BAD_RESULT_FROM_RECURSIVE_CALL, n.getFilePosition(), n);
        }
    }
}

