/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Planner {
    private final List<String> IDENTS = Collections.synchronizedList(Lists.newArrayList());
    public static final PlanState EMPTY = new PlanState();

    public PlanState planState(boolean novelPropNames, String ... strs) {
        Set<Long> prods = Sets.newHashSet();
        for (String s : strs) {
            if (s == null) continue;
            if (!s.matches("\\w+(?:\\+\\w+)*")) {
                throw new IllegalArgumentException(s);
            }
            String[] parts = s.split("\\+");
            long properties = 0L;
            for (String part : parts) {
                properties |= 1L << this.identIndex(part, novelPropNames);
            }
            prods.add(properties);
        }
        long union = 0L;
        long[] props = new long[prods.size()];
        int k = 0;
        for (Long p : prods) {
            props[k++] = p;
            union |= p.longValue();
        }
        Arrays.sort(props);
        return new PlanState(this, props, union);
    }

    public <TOOL extends Tool> List<TOOL> plan(List<TOOL> tools, PlanState inputs, PlanState goals) throws UnsatisfiableGoalException {
        assert (inputs.getPlanner() == this);
        assert (goals.getPlanner() == this);
        PartialPlan<Object> start = new PartialPlan<Object>(inputs, null, null);
        PlanState state = start.apply(goals);
        if (state != null && state.isEmpty()) {
            return Planner.toPlan(start);
        }
        LinkedList<PartialPlan<Object>> stack = Lists.newLinkedList();
        stack.add(start);
        while (!stack.isEmpty()) {
            PartialPlan plan = (PartialPlan)stack.remove(0);
            for (Tool tool : tools) {
                if (plan.used.contains(tool) || (state = plan.apply(tool.preconds)) == null) continue;
                state = state.with(tool.postconds);
                PartialPlan<Tool> next = new PartialPlan<Tool>(state, plan, tool);
                if ((state = next.apply(goals)) != null && state.isEmpty()) {
                    return Planner.toPlan(next);
                }
                stack.add(next);
            }
        }
        throw new UnsatisfiableGoalException("No path from " + inputs + " to " + goals);
    }

    private static <TOOL extends Tool> List<TOOL> toPlan(PartialPlan<TOOL> partialPlan) {
        List plan = Lists.newArrayList();
        while (partialPlan != null) {
            if (partialPlan.tool != null) {
                plan.add(partialPlan.tool);
            }
            partialPlan = partialPlan.prior;
        }
        Collections.reverse(plan);
        return plan;
    }

    private int identIndex(String ident, boolean allocNew) {
        if (this.IDENTS.size() == 64) {
            throw new Error();
        }
        int index = this.IDENTS.indexOf(ident);
        if (index < 0) {
            if (allocNew) {
                index = this.IDENTS.size();
                this.IDENTS.add(ident);
            } else {
                throw new IllegalArgumentException(ident);
            }
        }
        return index;
    }

    private void propertiesToBuf(long properties, StringBuilder sb) {
        long l = properties;
        String delim = "";
        for (int i = 0; i < 63; ++i) {
            if ((l & 1L << i) == 0L) continue;
            sb.append(delim);
            delim = "+";
            sb.append(this.IDENTS.get(i));
            if ((l &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) == 0L) break;
        }
    }

    static final class UnsatisfiableGoalException
    extends Exception {
        UnsatisfiableGoalException(String msg) {
            super(msg);
        }
    }

    public static final class PlanState {
        final Planner planner;
        final long[] properties;
        final long union;

        private PlanState() {
            this.planner = null;
            this.properties = new long[0];
            this.union = 0L;
        }

        private PlanState(Planner planner, long[] properties, long union) {
            assert (union != 0L || properties.length == 0);
            this.planner = planner;
            this.properties = properties;
            this.union = union;
        }

        public boolean isEmpty() {
            return this.union == 0L;
        }

        public PlanState with(PlanState that) {
            int m = this.properties.length;
            int n = that.properties.length;
            if (n == 0) {
                return this;
            }
            if (m == 0) {
                return that;
            }
            assert (this.getPlanner() == that.getPlanner());
            int count = this.properties.length;
            int i = 0;
            int j = 0;
            while (i < m && j < n) {
                long a = this.properties[i];
                long b = that.properties[j];
                if (a < b) {
                    ++i;
                    continue;
                }
                if (a == b) {
                    ++i;
                    ++j;
                    continue;
                }
                ++j;
                ++count;
            }
            long[] newProperties = new long[count += n - j];
            long union = this.union;
            int i2 = 0;
            int j2 = 0;
            int k = -1;
            while (i2 < m && j2 < n) {
                long el;
                long a = this.properties[i2];
                long b = that.properties[j2];
                if (a < b) {
                    ++i2;
                    el = a;
                } else if (a == b) {
                    ++i2;
                    ++j2;
                    el = a;
                } else {
                    ++j2;
                    el = b;
                    union |= b;
                }
                newProperties[++k] = el;
            }
            if (i2 < m) {
                do {
                    newProperties[++k] = this.properties[i2];
                } while (++i2 < m);
            } else if (j2 < n) {
                do {
                    long el = that.properties[j2];
                    newProperties[++k] = el;
                    union |= el;
                } while (++j2 < n);
            }
            return new PlanState(this.planner, newProperties, union);
        }

        public PlanState without(PlanState that) {
            int n;
            if (this.isEmpty() || that.isEmpty()) {
                return this;
            }
            assert (this.getPlanner() == that.getPlanner());
            long[] newProperties = (long[])this.properties.clone();
            int nZero = 0;
            int i = n = newProperties.length;
            block0: while (--i >= 0) {
                int j = that.properties.length;
                while (--j >= 0) {
                    if (newProperties[i] != that.properties[j]) continue;
                    newProperties[i] = 0L;
                    ++nZero;
                    continue block0;
                }
            }
            if (nZero == 0) {
                return this;
            }
            if (nZero == n) {
                return EMPTY;
            }
            long[] newPropertiesTrim = new long[n - nZero];
            long union = 0L;
            int i2 = 0;
            int k = 0;
            while (k < newPropertiesTrim.length) {
                if (newProperties[i2] != 0L) {
                    int n2 = k++;
                    long l = newProperties[i2];
                    newPropertiesTrim[n2] = l;
                    union |= l;
                }
                ++i2;
            }
            return new PlanState(this.planner, newPropertiesTrim, union);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String delim = "";
            for (long p : this.properties) {
                sb.append(delim);
                delim = " ";
                this.planner.propertiesToBuf(p, sb);
            }
            return sb.toString();
        }

        private Planner getPlanner() {
            return this.planner;
        }
    }

    public static abstract class Tool {
        PlanState preconds = EMPTY;
        PlanState postconds = EMPTY;

        Tool given(PlanState preconds) {
            this.preconds = this.preconds.with(preconds);
            return this;
        }

        Tool exceptNotGiven(PlanState exceptions) {
            this.preconds = this.preconds.without(exceptions);
            return this;
        }

        Tool produces(PlanState postconds) {
            this.postconds = this.postconds.with(postconds);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PartialPlan<TOOL extends Tool> {
        final PlanState state;
        final PartialPlan<TOOL> prior;
        final TOOL tool;
        final Set<TOOL> used;

        PartialPlan(PlanState state, PartialPlan<TOOL> prior, TOOL tool) {
            this.state = state;
            this.prior = prior;
            this.tool = tool;
            if (tool == null) {
                this.used = Collections.emptySet();
            } else if (prior == null) {
                this.used = Collections.singleton(tool);
            } else {
                this.used = Sets.newIdentityHashSet(prior.used);
                this.used.add(tool);
            }
        }

        PlanState apply(PlanState reqs) {
            if ((reqs.union & this.state.union) != reqs.union) {
                return null;
            }
            boolean[] used = new boolean[this.state.properties.length];
            int nUsed = 0;
            for (long p : reqs.properties) {
                boolean satisfied = false;
                int i = 0;
                for (long q : this.state.properties) {
                    if ((q & p) == p) {
                        if (!used[i]) {
                            used[i] = true;
                            ++nUsed;
                        }
                        satisfied = true;
                    }
                    ++i;
                }
                if (satisfied) continue;
                return null;
            }
            int n = this.state.properties.length;
            if (n == nUsed) {
                return EMPTY;
            }
            int nUnused = n - nUsed;
            long[] unused = new long[nUnused];
            long union = 0L;
            int i = 0;
            int k = 0;
            while (k < nUnused) {
                if (!used[i]) {
                    long p = this.state.properties[i];
                    unused[k++] = p;
                    union |= p;
                }
                ++i;
            }
            return new PlanState(this.state.planner, unused, union);
        }
    }
}

