/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.stages.CajaRuntimeDebuggingRewriter;
import com.google.caja.plugin.stages.DebuggingSymbols;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebuggingSymbolsStage
implements Pipeline.Stage<Jobs> {
    private static final boolean DEBUG = false;

    @Override
    public boolean apply(Jobs jobs) {
        MessageQueue mq = jobs.getMessageQueue();
        ListIterator<JobEnvelope> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            JobEnvelope env = it.next();
            Job job = env.job;
            if (job.getType() != ContentType.JS || !(job.getRoot() instanceof CajoledModule)) continue;
            DebuggingSymbols symbols = new DebuggingSymbols();
            CajoledModule js = this.addSymbols((CajoledModule)job.getRoot(), symbols, mq);
            if (symbols.isEmpty()) continue;
            it.set(env.withJob(Job.cajoledJob(this.attachSymbols(symbols, js, mq))));
        }
        return jobs.hasNoFatalErrors();
    }

    private CajoledModule addSymbols(CajoledModule js, DebuggingSymbols symbols, MessageQueue mq) {
        return (CajoledModule)new CajaRuntimeDebuggingRewriter(symbols, mq).expand(js);
    }

    private CajoledModule attachSymbols(DebuggingSymbols symbols, CajoledModule js, MessageQueue mq) {
        LinkedHashMap<String, ParseTreeNode> envelopeBindings = new LinkedHashMap<String, ParseTreeNode>();
        if (!QuasiBuilder.match("({@keys*: @values*})", js.getModuleBody(), envelopeBindings)) {
            mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_ENVELOPE, js.getFilePosition());
            return js;
        }
        ParseTreeNode functionValue = this.getObjectLiteralValue(envelopeBindings, "instantiate");
        if (functionValue == null) {
            mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_ENVELOPE, js.getFilePosition());
            return js;
        }
        LinkedHashMap<String, ParseTreeNode> functionBindings = new LinkedHashMap<String, ParseTreeNode>();
        if (!QuasiBuilder.match("function (___, IMPORTS___) { @body* }", functionValue, functionBindings)) {
            mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_ENVELOPE, js.getFilePosition());
            return js;
        }
        functionValue = QuasiBuilder.substV("  function (___, IMPORTS___) {  ___.useDebugSymbols(@symbols*);  @body*}", "symbols", symbols.toJavascriptSideTable(), "body", functionBindings.get("body"));
        this.setObjectLiteralValue(envelopeBindings, "instantiate", functionValue);
        return new CajoledModule((ObjectConstructor)QuasiBuilder.substV("({@keys*: @values*})", "keys", envelopeBindings.get("keys"), "values", envelopeBindings.get("values")));
    }

    private ParseTreeNode getObjectLiteralValue(Map<String, ParseTreeNode> keyValuePairs, String key) {
        List<? extends ParseTreeNode> keys = keyValuePairs.get("keys").children();
        List<? extends ParseTreeNode> values = keyValuePairs.get("values").children();
        for (int i = 0; i < keys.size(); ++i) {
            String candidateKey = ((StringLiteral)keys.get(i)).getUnquotedValue();
            if (!key.equals(candidateKey)) continue;
            return values.get(i);
        }
        return null;
    }

    private void setObjectLiteralValue(Map<String, ParseTreeNode> keyValuePairs, String key, ParseTreeNode value) {
        List<? extends ParseTreeNode> keys = keyValuePairs.get("keys").children();
        ArrayList<? extends ParseTreeNode> values = new ArrayList<ParseTreeNode>(keyValuePairs.get("values").children());
        for (int i = 0; i < keys.size(); ++i) {
            String candidateKey = ((StringLiteral)keys.get(i)).getUnquotedValue();
            if (!key.equals(candidateKey)) continue;
            values.set(i, value);
            keyValuePairs.put("values", new ParseTreeNodeContainer(values));
            return;
        }
    }
}

