/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.TokenClassification;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SideBySideRenderer
implements TokenConsumer {
    private final Map<InputSource, String[]> originalSourceLines;
    private final Map<InputSource, Integer> maxLineSeen = Maps.newHashMap();
    private final TokenConsumer renderer;
    private FilePosition lastPos;
    private FilePosition mark;
    private FilePosition chunkStart;
    private final List<Chunk> chunks = Lists.newArrayList();
    private StringBuilder renderedBuf;

    public SideBySideRenderer(Map<InputSource, ? extends CharSequence> originalSource) {
        this.originalSourceLines = Maps.newHashMap();
        for (Map.Entry<InputSource, ? extends CharSequence> e : originalSource.entrySet()) {
            this.originalSourceLines.put(e.getKey(), ((Object)e.getValue()).toString().split("\r\n?|\n"));
        }
        this.renderedBuf = new StringBuilder();
        this.renderer = this.makeRenderer(this.renderedBuf);
    }

    protected abstract void emitLine(FilePosition var1, String var2, String var3);

    protected void switchSource(InputSource previous, InputSource next) {
    }

    protected abstract TokenConsumer makeRenderer(StringBuilder var1);

    @Override
    public void mark(@Nullable FilePosition pos) {
        if (pos != null) {
            this.mark = pos;
        }
        this.renderer.mark(pos);
    }

    @Override
    public void consume(String text) {
        if (TokenClassification.isComment(text)) {
            return;
        }
        if (!(this.mark == null ? this.lastPos == null : this.lastPos != null && this.mark.source().equals(this.lastPos.source()))) {
            this.emitLine();
        } else if (this.lastPos != null && this.mark.startLineNo() > this.lastPos.startLineNo() && this.mark.startLineNo() >= this.lastLineNo(this.mark.source())) {
            this.emitLine();
        }
        this.renderer.consume(text);
        this.lastPos = this.mark;
    }

    @Override
    public void noMoreTokens() {
        this.emitLine();
        this.renderer.noMoreTokens();
        String renderedSrc = this.renderedBuf.toString();
        this.renderedBuf.setLength(0);
        InputSource lastSource = null;
        for (Pair<String, Integer> chunk : SideBySideRenderer.splitChunks(renderedSrc)) {
            InputSource source;
            String renderedChunk = (String)chunk.a;
            int chunkIndex = (Integer)chunk.b;
            Chunk originalChunk = chunkIndex >= 0 ? this.chunks.get(chunkIndex) : new Chunk("", null);
            InputSource inputSource = source = originalChunk.start != null ? originalChunk.start.source() : null;
            if (!"".equals(renderedChunk) || !"".equals(originalChunk.src)) {
                if (!(source == null ? lastSource == null : lastSource != null && source.equals(lastSource))) {
                    this.switchSource(lastSource, source);
                }
                this.emitLine(originalChunk.start, originalChunk.src, renderedChunk);
            }
            lastSource = source;
        }
    }

    private void emitLine() {
        String originalSrc = "";
        if (this.chunkStart != null) {
            int startLine = this.lastLineNo(this.chunkStart.source()) + 1;
            int endLine = this.lastPos.endLineNo();
            if (this.lastPos.endCharInLine() == 1) {
                --endLine;
            }
            originalSrc = this.originalSourceSnippet(this.chunkStart.source(), startLine, endLine);
            this.maxLineSeen.put(this.chunkStart.source(), endLine);
        }
        int chunkId = this.chunks.size();
        this.chunks.add(new Chunk(originalSrc, this.chunkStart));
        this.renderer.consume("/*@" + chunkId + "*/");
        this.renderer.consume("\n");
        this.chunkStart = this.mark;
    }

    private static List<Pair<String, Integer>> splitChunks(String renderedSrc) {
        Pattern p = Pattern.compile(" */\\*@([0-9]+)\\*/(?:\n|\r\n?|$)");
        Matcher m = p.matcher(renderedSrc);
        int start = 0;
        List<Pair<String, Integer>> chunks = Lists.newArrayList();
        while (m.find()) {
            int chunkIndex = Integer.parseInt(m.group(1));
            chunks.add(Pair.pair(renderedSrc.substring(start, m.start()), chunkIndex));
            start = m.end();
        }
        chunks.add(Pair.pair(renderedSrc.substring(start), -1));
        return chunks;
    }

    private String originalSourceSnippet(InputSource src, int startLine, int endLine) {
        --endLine;
        String[] lines = this.originalSourceLines.get(src);
        if (lines == null || --startLine >= lines.length) {
            return "";
        }
        endLine = Math.min(endLine, lines.length - 1);
        return Join.join((CharSequence)"\n", Arrays.asList(lines).subList(startLine, endLine + 1));
    }

    private int lastLineNo(InputSource src) {
        Integer ln = this.maxLineSeen.get(src);
        return ln != null ? ln : 0;
    }

    private static final class Chunk {
        private final String src;
        private final FilePosition start;

        Chunk(String src, FilePosition start) {
            this.start = start;
            this.src = src;
        }
    }
}

