/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.OrigSourceRendererTestCase;
import com.google.caja.render.SourceSpansRenderer;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import java.net.URI;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSpansRendererTest
extends OrigSourceRendererTestCase {
    public final void testRendering() throws Exception {
        this.runTest("ssp-golden.txt", "ssp-rewritten-tokens.txt", "ssp-test-input.js");
    }

    @Override
    protected TokenConsumer createRenderer(Map<InputSource, ? extends CharSequence> originalSource, MessageContext mc, RenderContext rc) {
        return new WrapperRenderer(rc);
    }

    private static final class WrapperRenderer
    implements TokenConsumer {
        private final RenderContext rc;
        private final SourceSpansRenderer delegate;

        public WrapperRenderer(RenderContext rc) {
            this.rc = rc;
            this.delegate = new SourceSpansRenderer(new InputSource(URI.create("file://foo/bar.js")), rc);
        }

        public void mark(FilePosition pos) {
            this.delegate.mark(pos);
        }

        public void consume(String text) {
            this.delegate.consume(text);
        }

        public void noMoreTokens() {
            this.delegate.noMoreTokens();
            this.dumpResults();
        }

        private void dumpResults() {
            Concatenator out = (Concatenator)this.rc.getOut();
            out.consume(this.delegate.getProgramText());
            for (String slmLine : this.delegate.getSourceLocationMap()) {
                out.consume(slmLine);
                out.consume("\n");
            }
        }
    }
}

