/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.service.ServiceTestCase;
import junit.framework.AssertionFailedError;

public class JsHandlerTest
extends ServiceTestCase {
    public final void testJs() throws Exception {
        this.registerUri("http://foo/bar.js", "g(1);", "text/javascript");
        JsHandlerTest.assertSubstringsInJson((String)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript"), "js", "moduleResult___=$v.cf($v.ro('g'),[1]);");
    }

    public final void testJsWithJsonpCallback() throws Exception {
        this.registerUri("http://foo/bar.js", "g(1);", "text/javascript");
        String s = (String)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript&alt=json-in-script&callback=foo");
        JsHandlerTest.assertCallbackInJsonp(s, "foo");
        JsHandlerTest.assertSubstringsInJsonp(s, "js", "moduleResult___=$v.cf($v.ro('g'),[1]);");
        try {
            JsHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript&alt=json-in-script&callback=foo.bar"), "foo.bar");
            JsHandlerTest.fail((String)"Failed to reject non-identifier JSONP callback");
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
        try {
            JsHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript&callback=foo.bar"), "foo.bar");
            JsHandlerTest.fail((String)"Added JSONP callback when not requested");
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
        try {
            JsHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript&alt=json&callback=foo.bar"), "foo.bar");
            JsHandlerTest.fail((String)"Added JSONP callback when not requested");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testCajitaJs() throws Exception {
        this.registerUri("http://foo/bar.js", "g(1);", "text/javascript");
        JsHandlerTest.assertSubstringsInJson((String)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript&directive=CAJITA"), "js", "var g=___.readImport(IMPORTS___,'g');", "moduleResult___=g.CALL___(1);");
    }
}

