/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.api.ui.DirectoryUI;
import org.nuxeo.ecm.directory.api.ui.DirectoryUIDeleteConstraint;
import org.nuxeo.ecm.directory.api.ui.DirectoryUIManager;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="directoryUIActions")
@Scope(value=ScopeType.CONVERSATION)
public class DirectoryUIActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DIRECTORY_DEFAULT_VIEW = "view_directory";
    @In(create=true)
    protected transient DirectoryUIManager directoryUIManager;
    protected transient DirectoryService dirService;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    protected List<String> directoryNames;
    protected DirectoryUI currentDirectoryInfo;
    protected DocumentModelList currentDirectoryEntries;
    protected DocumentModel selectedDirectoryEntry;
    protected boolean showAddForm = false;
    protected DocumentModel creationDirectoryEntry;

    @Begin(join=true)
    @Create
    public void initialize() {
        this.initDirService();
    }

    private void initDirService() {
        if (this.dirService == null) {
            this.dirService = DirectoryHelper.getDirectoryService();
        }
    }

    public List<String> getDirectoryNames() throws ClientException {
        if (this.directoryNames == null) {
            this.directoryNames = this.directoryUIManager.getDirectoryNames();
        }
        return this.directoryNames;
    }

    public String selectDirectory(String directoryName) throws ClientException {
        this.resetSelectedDirectoryData();
        this.currentDirectoryInfo = this.directoryUIManager.getDirectoryInfo(directoryName);
        String view = this.currentDirectoryInfo.getView();
        if (view == null) {
            view = DIRECTORY_DEFAULT_VIEW;
        }
        return view;
    }

    public DirectoryUI getCurrentDirectory() throws ClientException {
        return this.currentDirectoryInfo;
    }

    public DocumentModelList getCurrentDirectoryEntries() throws ClientException {
        if (this.currentDirectoryEntries == null) {
            this.currentDirectoryEntries = new DocumentModelListImpl();
            Session dirSession = null;
            try {
                String sortField;
                String dirName = this.currentDirectoryInfo.getName();
                dirSession = this.dirService.open(dirName);
                Map emptyMap = Collections.emptyMap();
                Set emptySet = Collections.emptySet();
                DocumentModelList entries = dirSession.query(emptyMap, emptySet, null, true);
                if (entries != null && !entries.isEmpty()) {
                    this.currentDirectoryEntries.addAll((Collection)entries);
                }
                if ((sortField = this.currentDirectoryInfo.getSortField()) == null) {
                    sortField = this.dirService.getDirectoryIdField(dirName);
                }
                HashMap<String, String> orderBy = new HashMap<String, String>();
                orderBy.put(sortField, "asc");
                Collections.sort(this.currentDirectoryEntries, new DocumentModelComparator(this.dirService.getDirectorySchema(dirName), orderBy));
            }
            catch (DirectoryException e) {
                throw new ClientException((ClientException)((Object)e));
            }
            finally {
                if (dirSession != null) {
                    dirSession.close();
                }
            }
        }
        return this.currentDirectoryEntries;
    }

    public void resetSelectedDirectoryData() {
        this.currentDirectoryInfo = null;
        this.currentDirectoryEntries = null;
        this.selectedDirectoryEntry = null;
        this.showAddForm = false;
        this.creationDirectoryEntry = null;
    }

    public boolean getShowAddForm() {
        return this.showAddForm;
    }

    public void toggleShowAddForm() {
        this.showAddForm = !this.showAddForm;
    }

    public DocumentModel getCreationDirectoryEntry() throws ClientException {
        if (this.creationDirectoryEntry == null) {
            Object dirSession = null;
            try {
                String dirName = this.currentDirectoryInfo.getName();
                String schema = this.dirService.getDirectorySchema(dirName);
                this.creationDirectoryEntry = BaseSession.createEntryModel(null, (String)schema, null, null);
            }
            catch (DirectoryException e) {
                throw new ClientException((ClientException)((Object)e));
            }
            finally {
                if (dirSession != null) {
                    dirSession.close();
                }
            }
        }
        return this.creationDirectoryEntry;
    }

    public void createDirectoryEntry() throws ClientException {
        Session dirSession = null;
        try {
            String dirName = this.currentDirectoryInfo.getName();
            String schema = this.dirService.getDirectorySchema(dirName);
            String idField = this.dirService.getDirectoryIdField(dirName);
            Object id = this.creationDirectoryEntry.getProperty(schema, idField);
            dirSession = this.dirService.open(dirName);
            if (id instanceof String && dirSession.hasEntry((String)id)) {
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("vocabulary.entry.identifier.already.exists"), new Object[0]);
                return;
            }
            dirSession.createEntry(this.creationDirectoryEntry);
            this.resetCreateDirectoryEntry();
            this.currentDirectoryEntries = null;
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("vocabulary.entry.added"), new Object[0]);
        }
        catch (DirectoryException e) {
            throw new ClientException((ClientException)((Object)e));
        }
        finally {
            if (dirSession != null) {
                dirSession.close();
            }
        }
    }

    public void resetCreateDirectoryEntry() {
        this.creationDirectoryEntry = null;
        this.showAddForm = false;
    }

    public void selectDirectoryEntry(String entryId) throws ClientException {
        Session dirSession = null;
        try {
            String dirName = this.currentDirectoryInfo.getName();
            dirSession = this.dirService.open(dirName);
            this.selectedDirectoryEntry = dirSession.getEntry(entryId);
        }
        catch (DirectoryException e) {
            throw new ClientException((ClientException)((Object)e));
        }
        finally {
            if (dirSession != null) {
                dirSession.close();
            }
        }
    }

    public DocumentModel getSelectedDirectoryEntry() throws ClientException {
        return this.selectedDirectoryEntry;
    }

    public void resetSelectedDirectoryEntry() {
        this.selectedDirectoryEntry = null;
    }

    public void editSelectedDirectoryEntry() throws ClientException {
        Session dirSession = null;
        try {
            String dirName = this.currentDirectoryInfo.getName();
            dirSession = this.dirService.open(dirName);
            dirSession.updateEntry(this.selectedDirectoryEntry);
            this.selectedDirectoryEntry = null;
            this.currentDirectoryEntries = null;
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("vocabulary.entry.edited"), new Object[0]);
        }
        catch (DirectoryException e) {
            throw new ClientException((ClientException)((Object)e));
        }
        finally {
            if (dirSession != null) {
                dirSession.close();
            }
        }
    }

    public void deleteDirectoryEntry(String entryId) throws ClientException {
        String dirName = this.currentDirectoryInfo.getName();
        List deleteConstraints = this.currentDirectoryInfo.getDeleteConstraints();
        if (deleteConstraints != null && !deleteConstraints.isEmpty()) {
            for (DirectoryUIDeleteConstraint deleteConstraint : deleteConstraints) {
                if (deleteConstraint.canDelete(this.dirService, entryId)) continue;
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.directory.deleteEntry.constraintError"), new Object[0]);
                return;
            }
        }
        Session dirSession = null;
        try {
            dirSession = this.dirService.open(dirName);
            dirSession.deleteEntry(entryId);
            this.currentDirectoryEntries = null;
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("vocabulary.entry.deleted"), new Object[0]);
        }
        catch (DirectoryException e) {
            throw new ClientException((ClientException)((Object)e));
        }
        finally {
            if (dirSession != null) {
                dirSession.close();
            }
        }
    }

    public boolean isReadOnly() throws ClientException {
        Session dirSession = null;
        boolean isReadOnly = false;
        try {
            String dirName = this.currentDirectoryInfo.getName();
            dirSession = this.dirService.open(dirName);
            boolean dirReadOnly = dirSession.isReadOnly();
            boolean dirUIReadOnly = this.currentDirectoryInfo.isReadOnly() == null ? false : this.currentDirectoryInfo.isReadOnly();
            isReadOnly = dirReadOnly || dirUIReadOnly;
        }
        catch (DirectoryException e) {
            throw new ClientException((ClientException)((Object)e));
        }
        finally {
            if (dirSession != null) {
                dirSession.close();
            }
        }
        return isReadOnly;
    }
}

