/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.versioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.versioning.DocumentVersioning;
import org.nuxeo.ecm.webapp.versioning.VersionedActions;

@Name(value="versionedActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class VersionedActionsBean
implements VersionedActions,
Serializable {
    private static final long serialVersionUID = 4472648747609642493L;
    private static final Log log = LogFactory.getLog(VersionedActionsBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true, required=false)
    protected transient ResourcesAccessor resourcesAccessor;
    @In
    protected transient Context sessionContext;
    @In(create=true)
    protected transient DocumentVersioning documentVersioning;
    protected transient List<VersionModel> versionModelList;
    protected String checkedOut;

    @Override
    @Create
    public void initialize() {
    }

    @Override
    @Observer(value={"documentSelectionChanged", "documentChanged", "documentSubmitedForPublication", "documentPublished"}, create=false)
    @BypassInterceptors
    public void resetVersions() {
        this.versionModelList = null;
    }

    @Override
    @Factory(value="versionList", scope=ScopeType.EVENT)
    public List<VersionModel> getVersionList() throws ClientException {
        if (this.versionModelList == null || this.versionModelList.isEmpty()) {
            this.retrieveVersions();
        }
        return this.versionModelList;
    }

    @Override
    public void retrieveVersions() throws ClientException {
        DocumentModel doc;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.isProxy()) {
            DocumentRef ref = currentDocument.getRef();
            DocumentModel version = this.documentManager.getSourceDocument(ref);
            doc = this.documentManager.getSourceDocument(version.getRef());
        } else {
            doc = currentDocument;
        }
        this.versionModelList = new ArrayList<VersionModel>(this.documentVersioning.getItemVersioningHistory(doc));
    }

    @Override
    public String restoreToVersion(VersionModel selectedVersion) throws ClientException {
        DocumentModel restoredDocument = this.documentManager.restoreToVersion(this.navigationContext.getCurrentDocument().getRef(), (DocumentRef)new IdRef(selectedVersion.getId()), true, true);
        this.documentManager.save();
        EventManager.raiseEventsOnDocumentChange((DocumentModel)restoredDocument);
        return this.navigationContext.navigateToDocument(restoredDocument, "after-edit");
    }

    @Override
    public String viewArchivedVersion(VersionModel selectedVersion) throws ClientException {
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument(), selectedVersion);
    }

    @Override
    public boolean getCanRestore() throws ClientException {
        return this.documentManager.hasPermission(this.navigationContext.getCurrentDocument().getRef(), "WriteProperties");
    }

    @Override
    public String getCheckedOut() throws ClientException {
        this.checkedOut = this.documentManager.isCheckedOut(this.navigationContext.getCurrentDocument().getRef()) ? "Checked-out" : "Checked-in";
        return this.checkedOut;
    }

    @Override
    public void setCheckedOut(String checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public String checkOut() throws ClientException {
        this.documentManager.checkOut(this.navigationContext.getCurrentDocument().getRef());
        return null;
    }

    @Override
    public String checkIn() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.documentManager.checkIn(currentDocument.getRef(), null, null);
        this.retrieveVersions();
        return this.navigationContext.getActionResult(currentDocument, UserAction.AFTER_EDIT);
    }

    @Override
    public DocumentModel getSourceDocument() throws ClientException {
        return this.documentManager.getSourceDocument(this.navigationContext.getCurrentDocument().getRef());
    }

    @Override
    public boolean canRemoveArchivedVersion(VersionModel selectedVersion) {
        try {
            DocumentRef docRef = this.navigationContext.getCurrentDocument().getRef();
            DocumentModel docVersion = this.documentManager.getDocumentWithVersion(docRef, selectedVersion);
            if (docVersion == null) {
                log.warn((Object)("Unexpectedly couldn't find the version " + selectedVersion.getLabel()));
                return false;
            }
            return this.documentManager.canRemoveDocument(docVersion.getRef());
        }
        catch (ClientException e) {
            log.debug((Object)("ClientException in canRemoveArchivedVersion: " + e.getMessage()));
            return false;
        }
    }

    @Override
    public String removeArchivedVersion(VersionModel selectedVersion) throws ClientException {
        DocumentRef docRef = this.navigationContext.getCurrentDocument().getRef();
        DocumentModel docVersion = this.documentManager.getDocumentWithVersion(docRef, selectedVersion);
        if (docVersion == null) {
            log.warn((Object)("Unexpectedly couldn't find the version " + selectedVersion.getLabel()));
            return null;
        }
        this.documentManager.removeDocument(docVersion.getRef());
        this.documentManager.save();
        this.resetVersions();
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.versioning.versionRemoved"), new Object[0]);
        return null;
    }
}

