/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.NuxeoGroupImpl;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.VirtualUser;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;

public class UserManagerImpl
implements UserManager {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserManagerImpl.class);
    public static final String USERMANAGER_TOPIC = "usermanager";
    public static final String USERCHANGED_EVENT_ID = "user_changed";
    public static final String USERCREATED_EVENT_ID = "user_created";
    public static final String USERDELETED_EVENT_ID = "user_deleted";
    public static final String USERMODIFIED_EVENT_ID = "user_modified";
    public static final String GROUPCHANGED_EVENT_ID = "group_changed";
    public static final String GROUPCREATED_EVENT_ID = "group_created";
    public static final String GROUPDELETED_EVENT_ID = "group_deleted";
    public static final String GROUPMODIFIED_EVENT_ID = "group_modified";
    public static final String DEFAULT_ANONYMOUS_USER_ID = "Anonymous";
    public static final String VIRTUAL_FIELD_FILTER_PREFIX = "__";
    protected final DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
    protected String userDirectoryName;
    protected String userSchemaName;
    protected String userIdField;
    protected String userEmailField;
    protected Map<String, UserManager.MatchType> userSearchFields;
    protected String groupDirectoryName;
    protected String groupSchemaName;
    protected String groupIdField;
    protected String groupMembersField;
    protected String groupSubGroupsField;
    protected String groupParentGroupsField;
    protected String groupSortField;
    protected String defaultGroup;
    protected List<String> administratorIds;
    protected List<String> administratorGroups;
    protected Boolean disableDefaultAdministratorsGroup;
    protected String userSortField;
    protected String userListingMode;
    protected String groupListingMode;
    protected Pattern userPasswordPattern;
    protected VirtualUser anonymousUser;
    protected final Map<String, VirtualUserDescriptor> virtualUsers = new HashMap<String, VirtualUserDescriptor>();

    public void setConfiguration(UserManagerDescriptor descriptor) {
        this.defaultGroup = descriptor.defaultGroup;
        this.administratorIds = descriptor.defaultAdministratorIds;
        this.disableDefaultAdministratorsGroup = false;
        if (descriptor.disableDefaultAdministratorsGroup != null) {
            this.disableDefaultAdministratorsGroup = descriptor.disableDefaultAdministratorsGroup;
        }
        this.administratorGroups = new ArrayList<String>();
        if (!this.disableDefaultAdministratorsGroup.booleanValue()) {
            this.administratorGroups.add("administrators");
        }
        if (descriptor.administratorsGroups != null) {
            this.administratorGroups.addAll(descriptor.administratorsGroups);
        }
        if (this.administratorGroups.isEmpty()) {
            log.warn((Object)"No administrators group has been defined: at least one should be set to avoid lockups when blocking rights for instance");
        }
        this.userSortField = descriptor.userSortField;
        this.groupSortField = descriptor.groupSortField;
        this.userListingMode = descriptor.userListingMode;
        this.groupListingMode = descriptor.groupListingMode;
        this.userEmailField = descriptor.userEmailField;
        this.userSearchFields = descriptor.userSearchFields;
        this.userPasswordPattern = descriptor.userPasswordPattern;
        this.groupMembersField = descriptor.groupMembersField;
        this.groupSubGroupsField = descriptor.groupSubGroupsField;
        this.groupParentGroupsField = descriptor.groupParentGroupsField;
        this.anonymousUser = descriptor.anonymousUser;
        this.setUserDirectoryName(descriptor.userDirectoryName);
        this.setGroupDirectoryName(descriptor.groupDirectoryName);
        this.setVirtualUsers(descriptor.virtualUsers);
    }

    protected void setUserDirectoryName(String userDirectoryName) {
        this.userDirectoryName = userDirectoryName;
        try {
            this.userSchemaName = this.dirService.getDirectorySchema(userDirectoryName);
            this.userIdField = this.dirService.getDirectoryIdField(userDirectoryName);
        }
        catch (ClientException e) {
            throw new RuntimeException("Unkown user directory " + userDirectoryName, e);
        }
    }

    public String getUserDirectoryName() {
        return this.userDirectoryName;
    }

    public String getUserIdField() throws ClientException {
        return this.userIdField;
    }

    public String getUserSchemaName() throws ClientException {
        return this.userSchemaName;
    }

    public String getUserEmailField() {
        return this.userEmailField;
    }

    public Set<String> getUserSearchFields() {
        return Collections.unmodifiableSet(this.userSearchFields.keySet());
    }

    protected void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
        try {
            this.groupSchemaName = this.dirService.getDirectorySchema(groupDirectoryName);
            this.groupIdField = this.dirService.getDirectoryIdField(groupDirectoryName);
        }
        catch (ClientException e) {
            throw new RuntimeException("Unkown group directory " + groupDirectoryName, e);
        }
    }

    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    public String getGroupIdField() throws ClientException {
        return this.groupIdField;
    }

    public String getGroupSchemaName() throws ClientException {
        return this.groupSchemaName;
    }

    public String getGroupMembersField() {
        return this.groupMembersField;
    }

    public String getGroupSubGroupsField() {
        return this.groupSubGroupsField;
    }

    public String getGroupParentGroupsField() {
        return this.groupParentGroupsField;
    }

    public String getUserListingMode() {
        return this.userListingMode;
    }

    public String getGroupListingMode() {
        return this.groupListingMode;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public Pattern getUserPasswordPattern() {
        return this.userPasswordPattern;
    }

    public String getAnonymousUserId() {
        if (this.anonymousUser == null) {
            return null;
        }
        String anonymousUserId = this.anonymousUser.getId();
        if (anonymousUserId == null) {
            return DEFAULT_ANONYMOUS_USER_ID;
        }
        return anonymousUserId;
    }

    protected void setVirtualUsers(Map<String, VirtualUserDescriptor> virtualUsers) {
        this.virtualUsers.clear();
        if (virtualUsers != null) {
            this.virtualUsers.putAll(virtualUsers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUsernamePassword(String username, String password) throws ClientException {
        if (username == null || password == null) {
            log.warn((Object)"Trying to authenticate against null username or password");
            return false;
        }
        String anonymousUserId = this.getAnonymousUserId();
        if (username.equals(anonymousUserId)) {
            log.warn((Object)String.format("Trying to authenticate anonymous user (%s)", anonymousUserId));
            return false;
        }
        if (this.virtualUsers.containsKey(username)) {
            VirtualUser user = (VirtualUser)this.virtualUsers.get(username);
            String expected = user.getPassword();
            if (expected == null) {
                return false;
            }
            return expected.equals(password);
        }
        Session userDir = null;
        try {
            String userDirName = "userDirectory".equals(this.userDirectoryName) && this.dirService.getDirectory("userAuthentication") != null ? "userAuthentication" : this.userDirectoryName;
            userDir = this.dirService.open(userDirName);
            if (!userDir.isAuthenticating()) {
                log.error((Object)("Trying to authenticate against a non authenticating directory: " + userDirName));
                boolean bl = false;
                return bl;
            }
            boolean bl = userDir.authenticate(username, password);
            return bl;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public boolean validatePassword(String password) {
        if (this.userPasswordPattern == null) {
            return true;
        }
        Matcher userPasswordMatcher = this.userPasswordPattern.matcher(password);
        return userPasswordMatcher.find();
    }

    protected NuxeoPrincipal makeAnonymousPrincipal() throws ClientException {
        DocumentModel userEntry = this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser);
        return this.makePrincipal(userEntry, true, this.anonymousUser.getGroups());
    }

    protected NuxeoPrincipal makeVirtualPrincipal(VirtualUser user) throws ClientException {
        DocumentModel userEntry = this.makeVirtualUserEntry(user.getId(), user);
        return this.makePrincipal(userEntry, false, user.getGroups());
    }

    protected DocumentModel makeVirtualUserEntry(String id, VirtualUser user) throws ClientException {
        DocumentModel userEntry = BaseSession.createEntryModel(null, (String)this.userSchemaName, (String)id, null);
        userEntry.setProperty(this.userSchemaName, this.userIdField, (Object)id);
        for (Map.Entry prop : user.getProperties().entrySet()) {
            try {
                userEntry.setProperty(this.userSchemaName, (String)prop.getKey(), prop.getValue());
            }
            catch (ClientException ce) {
                log.error((Object)("Property: " + (String)prop.getKey() + " does not exists. Check your " + "UserService configuration."), (Throwable)ce);
            }
        }
        return userEntry;
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry) throws ClientException {
        return this.makePrincipal(userEntry, false, null);
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, List<String> groups) throws ClientException {
        boolean admin = false;
        String username = userEntry.getId();
        LinkedList<String> virtualGroups = new LinkedList<String>();
        if (!anonymous) {
            if (this.defaultGroup != null) {
                virtualGroups.add(this.defaultGroup);
            }
            if (groups != null) {
                virtualGroups.addAll(groups);
            }
            if (this.administratorIds != null && this.administratorIds.contains(username)) {
                admin = true;
                if (this.administratorGroups != null) {
                    virtualGroups.addAll(this.administratorGroups);
                }
            }
        }
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl(username, anonymous, admin, false);
        principal.setModel(userEntry, false);
        principal.setVirtualGroups(virtualGroups, true);
        List<String> roles = Arrays.asList("regular");
        principal.setRoles(roles);
        return principal;
    }

    public NuxeoPrincipal getPrincipal(String username) throws ClientException {
        if (username == null) {
            return null;
        }
        String anonymousUserId = this.getAnonymousUserId();
        if (username.equals(anonymousUserId)) {
            return this.makeAnonymousPrincipal();
        }
        if (this.virtualUsers.containsKey(username)) {
            return this.makeVirtualPrincipal((VirtualUser)this.virtualUsers.get(username));
        }
        DocumentModel userModel = this.getUserModel(username);
        if (userModel != null) {
            return this.makePrincipal(userModel);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel getUserModel(String userName) throws ClientException {
        if (userName == null) {
            return null;
        }
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            DocumentModel documentModel = userDir.getEntry(userName);
            return documentModel;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public DocumentModel getBareUserModel() throws ClientException {
        String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    public NuxeoGroup getGroup(String groupName) throws ClientException {
        DocumentModel groupEntry = this.getGroupModel(groupName);
        if (groupEntry != null) {
            return this.makeGroup(groupEntry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel getGroupModel(String groupName) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            DocumentModel documentModel = groupDir.getEntry(groupName);
            return documentModel;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    protected NuxeoGroup makeGroup(DocumentModel groupEntry) {
        List list;
        NuxeoGroupImpl group = new NuxeoGroupImpl(groupEntry.getId());
        try {
            list = (List)groupEntry.getProperty(this.groupSchemaName, this.groupMembersField);
        }
        catch (ClientException e) {
            list = null;
        }
        if (list != null) {
            group.setMemberUsers(list);
        }
        try {
            list = (List)groupEntry.getProperty(this.groupSchemaName, this.groupSubGroupsField);
        }
        catch (ClientException e) {
            list = null;
        }
        if (list != null) {
            group.setMemberGroups(list);
        }
        try {
            list = (List)groupEntry.getProperty(this.groupSchemaName, this.groupParentGroupsField);
        }
        catch (ClientException e) {
            list = null;
        }
        if (list != null) {
            group.setParentGroups(list);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTopLevelGroups() throws ClientException {
        Session groupDir = null;
        try {
            LinkedList<String> topLevelGroups = new LinkedList<String>();
            groupDir = this.dirService.open(this.groupDirectoryName);
            DocumentModelList groups = groupDir.query(Collections.emptyMap(), null, null, true);
            for (DocumentModel group : groups) {
                List parents = (List)group.getProperty(this.groupSchemaName, this.groupParentGroupsField);
                if (parents != null && !parents.isEmpty()) continue;
                topLevelGroups.add(group.getId());
            }
            LinkedList<String> linkedList = topLevelGroups;
            return linkedList;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public List<String> getGroupsInGroup(String parentId) throws ClientException {
        return this.getGroup(parentId).getMemberGroups();
    }

    public List<String> getUsersInGroup(String groupId) throws ClientException {
        return this.getGroup(groupId).getMemberUsers();
    }

    public List<String> getUsersInGroupAndSubGroups(String groupId) throws ClientException {
        HashSet<String> groups = new HashSet<String>();
        groups.add(groupId);
        this.appendSubgroups(groupId, groups);
        HashSet users = new HashSet();
        for (String groupid : groups) {
            users.addAll(this.getGroup(groupid).getMemberUsers());
        }
        return new ArrayList<String>(users);
    }

    protected void appendSubgroups(String groupId, Set<String> groups) throws ClientException {
        List<String> groupsToAppend = this.getGroupsInGroup(groupId);
        groups.addAll(groupsToAppend);
        for (String subgroupId : groupsToAppend) {
            groups.add(subgroupId);
            if (groups.contains(subgroupId)) continue;
            this.appendSubgroups(subgroupId, groups);
        }
    }

    protected boolean isAnonymousMatching(Map<String, Serializable> filter, Set<String> fulltext) {
        String anonymousUserId = this.getAnonymousUserId();
        if (anonymousUserId == null) {
            return false;
        }
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        Map anonymousUserMap = this.anonymousUser.getProperties();
        anonymousUserMap.put(this.userIdField, anonymousUserId);
        for (Map.Entry<String, Serializable> e : filter.entrySet()) {
            String fieldName = e.getKey();
            Serializable expected = e.getValue();
            Object value = anonymousUserMap.get(fieldName);
            if (!(value == null ? expected != null : (fulltext != null && fulltext.contains(fieldName) ? !value.toString().toLowerCase().startsWith(expected.toString().toLowerCase()) : !value.equals(expected)))) continue;
            return false;
        }
        return true;
    }

    public List<NuxeoPrincipal> searchPrincipals(String pattern) throws ClientException {
        DocumentModelList entries = this.searchUsers(pattern);
        ArrayList<NuxeoPrincipal> principals = new ArrayList<NuxeoPrincipal>(entries.size());
        for (DocumentModel entry : entries) {
            principals.add(this.makePrincipal(entry));
        }
        return principals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NuxeoGroup> searchGroups(String pattern) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
            if (pattern != null && pattern != "") {
                filter.put(groupDir.getIdField(), (Serializable)((Object)pattern));
            }
            DocumentModelList groupEntries = this.searchGroups(filter, new HashSet<String>(filter.keySet()));
            ArrayList<NuxeoGroup> groups = new ArrayList<NuxeoGroup>(groupEntries.size());
            for (DocumentModel groupEntry : groupEntries) {
                groups.add(this.makeGroup(groupEntry));
            }
            ArrayList<NuxeoGroup> arrayList = groups;
            return arrayList;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public String getUserSortField() {
        return this.userSortField;
    }

    protected Map<String, String> getUserSortMap() {
        String sortField = this.userSortField != null ? this.userSortField : this.userIdField;
        HashMap<String, String> orderBy = new HashMap<String, String>();
        orderBy.put(sortField, "asc");
        return orderBy;
    }

    protected void notify(String userOrGroupName, String eventId) throws ClientException {
        try {
            EventService eventService = (EventService)Framework.getService(EventService.class);
            eventService.sendEvent(new Event(USERMANAGER_TOPIC, eventId, (Object)this, (Object)userOrGroupName));
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void notifyUserChanged(String userName) throws ClientException {
        this.notify(userName, USERCHANGED_EVENT_ID);
    }

    protected void notifyGroupChanged(String groupName) throws ClientException {
        this.notify(groupName, GROUPCHANGED_EVENT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean areGroupsReadOnly() throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            Boolean bl = groupDir.isReadOnly();
            return bl;
        }
        catch (DirectoryException e) {
            log.error((Object)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (groupDir != null) {
                    groupDir.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean areUsersReadOnly() throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            Boolean bl = userDir.isReadOnly();
            return bl;
        }
        catch (DirectoryException e) {
            log.error((Object)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (userDir != null) {
                    userDir.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected String getGroupId(DocumentModel groupModel) throws ClientException {
        Object groupIdValue = groupModel.getProperty(this.groupSchemaName, this.groupIdField);
        if (groupIdValue != null && !(groupIdValue instanceof String)) {
            throw new ClientException("Invalid group id " + groupIdValue);
        }
        return (String)groupIdValue;
    }

    protected String getUserId(DocumentModel userModel) throws ClientException {
        Object userIdValue = userModel.getProperty(this.userSchemaName, this.userIdField);
        if (userIdValue != null && !(userIdValue instanceof String)) {
            throw new ClientException("Invalid user id " + userIdValue);
        }
        return (String)userIdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel createGroup(DocumentModel groupModel) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            String groupId = this.getGroupId(groupModel);
            if (groupDir.hasEntry(groupId)) {
                throw new GroupAlreadyExistsException();
            }
            groupModel = groupDir.createEntry(groupModel);
            groupDir.commit();
            this.notifyGroupChanged(groupId);
            this.notify(groupId, GROUPCREATED_EVENT_ID);
            DocumentModel documentModel = groupModel;
            return documentModel;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel createUser(DocumentModel userModel) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            String userId = this.getUserId(userModel);
            if (userDir.hasEntry(userId)) {
                throw new UserAlreadyExistsException();
            }
            userModel = userDir.createEntry(userModel);
            userDir.commit();
            this.notifyUserChanged(userId);
            this.notify(userId, USERCREATED_EVENT_ID);
            DocumentModel documentModel = userModel;
            return documentModel;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(String groupId) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            if (!groupDir.hasEntry(groupId)) {
                throw new DirectoryException("Group does not exist: " + groupId);
            }
            groupDir.deleteEntry(groupId);
            groupDir.commit();
            this.notifyGroupChanged(groupId);
            this.notify(groupId, GROUPDELETED_EVENT_ID);
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public void deleteGroup(DocumentModel groupModel) throws ClientException {
        String groupId = this.getGroupId(groupModel);
        this.deleteGroup(groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String userId) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            if (!userDir.hasEntry(userId)) {
                throw new DirectoryException("User does not exist: " + userId);
            }
            userDir.deleteEntry(userId);
            userDir.commit();
            this.notifyUserChanged(userId);
            this.notify(userId, USERDELETED_EVENT_ID);
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public void deleteUser(DocumentModel userModel) throws ClientException {
        String userId = this.getUserId(userModel);
        this.deleteUser(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupIds() throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            List groupIds = groupDir.getProjection(Collections.emptyMap(), groupDir.getIdField());
            Collections.sort(groupIds);
            List list = groupIds;
            return list;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserIds() throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            List userIds = userDir.getProjection(Collections.emptyMap(), userDir.getIdField());
            Collections.sort(userIds);
            List list = userIds;
            return list;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    protected void removeVirtualFilters(Map<String, Serializable> filter) {
        if (filter == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(filter.keySet());
        for (String key : keys) {
            if (!key.startsWith(VIRTUAL_FIELD_FILTER_PREFIX)) continue;
            filter.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList searchGroups(Map<String, Serializable> filter, HashSet<String> fulltext) throws ClientException {
        Session groupDir = null;
        try {
            DocumentModelList entries;
            this.removeVirtualFilters(filter);
            groupDir = this.dirService.open(this.groupDirectoryName);
            String sortField = this.groupSortField != null ? this.groupSortField : groupDir.getIdField();
            HashMap<String, String> orderBy = new HashMap<String, String>();
            orderBy.put(sortField, "asc");
            DocumentModelList documentModelList = entries = groupDir.query(filter, fulltext, orderBy, false);
            return documentModelList;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            this.removeVirtualFilters(filter);
            DocumentModelList entries = userDir.query(filter, fulltext, null, false);
            if (this.isAnonymousMatching(filter, fulltext)) {
                entries.add((Object)this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser));
            }
            if (orderBy != null && !orderBy.isEmpty()) {
                Collections.sort(entries, new DocumentModelComparator(this.userSchemaName, orderBy));
            }
            DocumentModelList documentModelList = entries;
            return documentModelList;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public DocumentModelList searchUsers(String pattern) throws ClientException {
        DocumentModelListImpl entries = new DocumentModelListImpl();
        if (pattern == null || pattern.length() == 0) {
            entries = this.searchUsers(Collections.<String, Serializable>emptyMap(), null);
        } else {
            HashMap<String, DocumentModel> uniqueEntries = new HashMap<String, DocumentModel>();
            for (Map.Entry<String, UserManager.MatchType> fieldEntry : this.userSearchFields.entrySet()) {
                HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
                filter.put(fieldEntry.getKey(), (Serializable)((Object)pattern));
                DocumentModelList fetchedEntries = fieldEntry.getValue() == UserManager.MatchType.SUBSTRING ? this.searchUsers(filter, filter.keySet(), null) : this.searchUsers(filter, null, null);
                for (DocumentModel entry : fetchedEntries) {
                    uniqueEntries.put(entry.getId(), entry);
                }
            }
            log.debug((Object)String.format("found %d unique entries", uniqueEntries.size()));
            entries.addAll(uniqueEntries.values());
        }
        Collections.sort(entries, new DocumentModelComparator(this.userSchemaName, this.getUserSortMap()));
        return entries;
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        return this.searchUsers(filter, fulltext, this.getUserSortMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroup(DocumentModel groupModel) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            String groupId = this.getGroupId(groupModel);
            if (!groupDir.hasEntry(groupId)) {
                throw new DirectoryException("group does not exist: " + groupId);
            }
            groupDir.updateEntry(groupModel);
            groupDir.commit();
            this.notifyGroupChanged(groupId);
            this.notify(groupId, GROUPMODIFIED_EVENT_ID);
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(DocumentModel userModel) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            String userId = this.getUserId(userModel);
            if (!userDir.hasEntry(userId)) {
                throw new DirectoryException("user does not exist: " + userId);
            }
            userDir.updateEntry(userModel);
            userDir.commit();
            this.notifyUserChanged(userId);
            this.notify(userId, USERMODIFIED_EVENT_ID);
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public DocumentModel getBareGroupModel() throws ClientException {
        String schema = this.dirService.getDirectorySchema(this.groupDirectoryName);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    public void createGroup(NuxeoGroup group) throws ClientException {
        DocumentModel newGroupModel = this.getBareGroupModel();
        newGroupModel.setProperty(this.groupSchemaName, this.groupIdField, (Object)group.getName());
        newGroupModel.setProperty(this.groupSchemaName, this.groupMembersField, (Object)group.getMemberUsers());
        newGroupModel.setProperty(this.groupSchemaName, this.groupSubGroupsField, (Object)group.getMemberGroups());
        this.createGroup(newGroupModel);
    }

    public void createPrincipal(NuxeoPrincipal principal) throws ClientException {
        this.createUser(principal.getModel());
    }

    public void deleteGroup(NuxeoGroup group) throws ClientException {
        this.deleteGroup(group.getName());
    }

    public void deletePrincipal(NuxeoPrincipal principal) throws ClientException {
        this.deleteUser(principal.getName());
    }

    public List<NuxeoGroup> getAvailableGroups() throws ClientException {
        DocumentModelList groupModels = this.searchGroups(Collections.<String, Serializable>emptyMap(), null);
        ArrayList<NuxeoGroup> groups = new ArrayList<NuxeoGroup>(groupModels.size());
        for (DocumentModel groupModel : groupModels) {
            groups.add(this.makeGroup(groupModel));
        }
        return groups;
    }

    public List<NuxeoPrincipal> getAvailablePrincipals() throws ClientException {
        DocumentModelList userModels = this.searchUsers(Collections.<String, Serializable>emptyMap(), null);
        ArrayList<NuxeoPrincipal> users = new ArrayList<NuxeoPrincipal>(userModels.size());
        for (DocumentModel userModel : userModels) {
            users.add(this.makePrincipal(userModel));
        }
        return users;
    }

    public DocumentModel getModelForUser(String name) throws ClientException {
        return this.getUserModel(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NuxeoPrincipal> searchByMap(Map<String, Serializable> filter, Set<String> pattern) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            this.removeVirtualFilters(filter);
            DocumentModelList entries = userDir.query(filter, pattern);
            ArrayList<NuxeoPrincipal> principals = new ArrayList<NuxeoPrincipal>(entries.size());
            for (DocumentModel entry : entries) {
                principals.add(this.makePrincipal(entry));
            }
            if (this.isAnonymousMatching(filter, pattern)) {
                principals.add(this.makeAnonymousPrincipal());
            }
            ArrayList<NuxeoPrincipal> arrayList = principals;
            return arrayList;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public void updateGroup(NuxeoGroup group) throws ClientException {
        DocumentModel newGroupModel = this.getGroupModel(group.getName());
        newGroupModel.setProperty(this.groupSchemaName, this.groupIdField, (Object)group.getName());
        newGroupModel.setProperty(this.groupSchemaName, this.groupMembersField, (Object)group.getMemberUsers());
        newGroupModel.setProperty(this.groupSchemaName, this.groupSubGroupsField, (Object)group.getMemberGroups());
        this.updateGroup(newGroupModel);
    }

    public void updatePrincipal(NuxeoPrincipal principal) throws ClientException {
        this.updateUser(principal.getModel());
    }

    public List<String> getAdministratorsGroups() {
        return this.administratorGroups;
    }
}

