/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl.adapters;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.TypeAdaptException;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;

public class StringToDocModel
implements TypeAdapter {
    public DocumentModel getAdaptedValue(OperationContext ctx, Object objectToAdapt) throws TypeAdaptException {
        try {
            String value = (String)objectToAdapt;
            if (value.startsWith(".")) {
                Object obj = Scripting.newExpression("Document.resolvePathAsRef(\"" + value + "\")").eval(ctx);
                if (obj instanceof DocumentModel) {
                    return (DocumentModel)obj;
                }
                if (obj instanceof DocumentRef) {
                    return ctx.getCoreSession().getDocument((DocumentRef)obj);
                }
                throw new TypeAdaptException(String.format("Cannot adapt value '%s' to a DocumentModel instance", value));
            }
            return ctx.getCoreSession().getDocument(StringToDocModel.createRef(value));
        }
        catch (TypeAdaptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeAdaptException(e);
        }
    }

    public static DocumentRef createRef(String value) throws Exception {
        return value.startsWith("/") ? new PathRef(value) : new IdRef(value);
    }
}

