/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Context.FetchDocument", category="Fetch", label="Context Document", description="Fetch the input of the context as a document. The document will become the input for the next operation.")
public class FetchContextDocument {
    public static final String ID = "Context.FetchDocument";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run() throws Exception {
        Object input = this.ctx.getInput();
        if (input instanceof DocumentModel) {
            return (DocumentModel)input;
        }
        if (input instanceof DocumentRef) {
            return this.ctx.getCoreSession().getDocument((DocumentRef)input);
        }
        throw new OperationException("Unsupported context for FetchDocument operation. No document available as input in the context");
    }
}

