/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Blob.Get", category="Files", label="Get Document File", description="Gets a file attached to the input document. The file location is specified using an xpath to the blob property of the document. Returns the file.")
public class GetDocumentBlob {
    public static final String ID = "Blob.Get";
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(DocumentModel doc) throws Exception {
        Blob blob = (Blob)doc.getPropertyValue(this.xpath);
        if (blob == null) {
            blob = new StringBlob("");
            blob.setMimeType("text/plain");
            blob.setFilename(doc.getName() + ".null");
        }
        return blob;
    }
}

