/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.text.DateFormat;
import java.util.Date;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Lock", category="Document", label="Lock", description="Lock the input document in the name of the given 'owner'. The lock owner is an username and identifies the user that owns the lock on the document. If the owner is not specified, the current user will be used as the owner. Returns back the locked document.")
public class LockDocument {
    public static final String ID = "Document.Lock";
    @Context
    protected CoreSession session;
    @Param(name="owner", required=false)
    protected String owner;

    protected String getDocumentLockKey(String owner) {
        StringBuilder result = new StringBuilder();
        result.append(owner).append(':').append(DateFormat.getDateInstance(2).format(new Date()));
        return result.toString();
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        if (this.owner == null) {
            this.owner = this.session.getPrincipal().getName();
        }
        this.session.setLock(doc, this.getDocumentLockKey(this.owner));
        return this.session.getDocument(doc);
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (this.owner == null) {
            this.owner = this.session.getPrincipal().getName();
        }
        this.session.setLock(doc.getRef(), this.getDocumentLockKey(this.owner));
        return this.session.getDocument(doc.getRef());
    }
}

