/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.DocumentType;

public class DocumentWrapper
extends HashMap<String, Serializable> {
    private static final long serialVersionUID = 1L;
    protected final CoreSession session;
    protected final DocumentModel doc;

    public DocumentWrapper(CoreSession session, DocumentModel doc) {
        this.session = session;
        this.doc = doc;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public DocumentWrapper getParent() throws Exception {
        DocumentModel parent = this.session.getParentDocument(this.doc.getRef());
        return parent != null ? new DocumentWrapper(this.session, parent) : null;
    }

    public DocumentWrapper getParent(String type) throws Exception {
        DocumentModel parent = this.doc;
        while (parent != null && !type.equals(parent.getType())) {
            parent = this.session.getParentDocument(this.doc.getRef());
        }
        return parent != null ? new DocumentWrapper(this.session, parent) : null;
    }

    public DocumentWrapper getWorkspace() throws Exception {
        return this.getParent("Workspace");
    }

    public DocumentWrapper getDomain() throws Exception {
        return this.getParent("Domain");
    }

    public String getTitle() throws Exception {
        return this.doc.getTitle();
    }

    public String getPath() throws Exception {
        return this.doc.getPathAsString();
    }

    public String resolvePath(String relative) throws Exception {
        return this.doc.getPath().append(relative).toString();
    }

    public DocumentRef resolvePathAsRef(String relative) throws Exception {
        return new PathRef(this.doc.getPath().append(relative).toString());
    }

    public String getDescription() throws Exception {
        return (String)((Object)this.doc.getPropertyValue("dc:description"));
    }

    public boolean hasFacet(String facet) {
        return this.doc.hasFacet(facet);
    }

    public boolean hasSchema(String schema) {
        return this.doc.hasSchema(schema);
    }

    public String getType() {
        return this.doc.getType();
    }

    public DocumentType getDocumentType() {
        return this.doc.getDocumentType();
    }

    public String getLifeCycle() throws Exception {
        return this.doc.getCurrentLifeCycleState();
    }

    public boolean isLocked() throws Exception {
        return this.doc.isLocked();
    }

    public boolean isFolder() throws Exception {
        return this.doc.isFolder();
    }

    public boolean isImmutable() throws Exception {
        return this.doc.isImmutable();
    }

    public boolean isProxy() throws Exception {
        return this.doc.isProxy();
    }

    public boolean isVersion() throws Exception {
        return this.doc.isVersion();
    }

    public boolean isDownloadable() throws Exception {
        return this.doc.isDownloadable();
    }

    public boolean isVersionable() throws Exception {
        return this.doc.isVersionable();
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getName() {
        return this.doc.getName();
    }

    public String[] getSchemas() {
        return this.doc.getDeclaredSchemas();
    }

    public Set<String> getFacets() {
        return this.doc.getDeclaredFacets();
    }

    public Serializable getProperty(String key) throws Exception {
        return this.doc.getPropertyValue(key);
    }

    public void setProperty(String key, Serializable value) throws Exception {
        this.doc.setPropertyValue(key, value);
    }

    public String getVersionLabel() throws Exception {
        return this.doc.getVersionLabel();
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.doc.getProperty(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.doc.getProperty(value.toString()).getValue() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Serializable get(Object key) {
        try {
            return this.doc.getProperty(key.toString()).getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Collection<Serializable> values() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Serializable put(String key, Serializable value) {
        try {
            Property p = this.doc.getProperty(key);
            Serializable v = p.getValue();
            p.setValue((Object)value);
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Serializable> m) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public Serializable remove(Object key) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read Only Map.");
    }
}

