/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyScripting {
    protected final GroovyClassLoader loader;
    protected Map<File, Entry> cache;

    public static ClassLoader getParentLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? GroovyScripting.class.getClassLoader() : cl;
    }

    public GroovyScripting() {
        this(GroovyScripting.getParentLoader(), new CompilerConfiguration());
    }

    public GroovyScripting(boolean debug) {
        this(GroovyScripting.getParentLoader(), debug);
    }

    public GroovyScripting(ClassLoader parent, boolean debug) {
        CompilerConfiguration cfg = new CompilerConfiguration();
        cfg.setDebug(debug);
        if (debug) {
            cfg.setRecompileGroovySource(true);
        }
        this.loader = new GroovyClassLoader(parent, cfg);
        this.cache = new ConcurrentHashMap<File, Entry>();
    }

    public GroovyScripting(ClassLoader parent, CompilerConfiguration cfg) {
        this.loader = new GroovyClassLoader(parent, cfg);
        this.cache = new ConcurrentHashMap<File, Entry>();
    }

    public void addClasspath(String cp) {
        this.loader.addClasspath(cp);
    }

    public void addClasspathUrl(URL cp) {
        this.loader.addURL(cp);
    }

    public void clearCache() {
        this.cache = new ConcurrentHashMap<File, Entry>();
        this.loader.clearCache();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.loader;
    }

    public Object eval(File file, Map<String, Object> context) throws IOException {
        return this.eval(file, context == null ? new Binding() : new Binding(context));
    }

    public Object eval(File file, Binding context) throws IOException {
        context.setVariable("out", (Object)System.out);
        return this.getScript(file, context).run();
    }

    public Class<?> compile(File file) throws IOException {
        GroovyCodeSource codeSource = new GroovyCodeSource(file);
        return this.loader.parseClass(codeSource, false);
    }

    public Script getScript(File file, Binding context) throws IOException {
        Class<?> klass = null;
        long lastModified = file.lastModified();
        Entry entry = this.cache.get(file);
        if (entry != null && entry.lastModified == lastModified) {
            klass = entry.klass;
        } else {
            klass = this.compile(file);
            this.cache.put(file, new Entry(klass, lastModified));
        }
        return InvokerHelper.createScript(klass, (Binding)context);
    }

    public Script getScript(String content, Binding context) throws IOException {
        Class klass = this.loader.parseClass(content);
        return InvokerHelper.createScript((Class)klass, (Binding)context);
    }

    static class Entry {
        final long lastModified;
        final Class<?> klass;

        Entry(Class<?> klass, long lastModified) {
            this.klass = klass;
            this.lastModified = lastModified;
        }
    }
}

