/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.Instance;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.SeamResourceBundle;
import org.jboss.seam.el.EL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.core.validators")
@BypassInterceptors
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=0, classDependencies={"org.hibernate.validator.ClassValidator"})
public class Validators {
    private Map<Key, ClassValidator> classValidators = new ConcurrentHashMap<Key, ClassValidator>();

    public <T> ClassValidator<T> getValidator(T model) {
        Class<?> modelClass = model instanceof Instance ? ((Instance)model).getComponent().getBeanClass() : model.getClass();
        return this.getValidator(modelClass);
    }

    public <T> ClassValidator<T> getValidator(Class<T> modelClass) {
        ResourceBundle bundle = SeamResourceBundle.getBundle();
        Locale none = bundle == null ? new Locale("NONE") : bundle.getLocale();
        Key key = new Key(modelClass, none);
        ClassValidator<T> result = this.classValidators.get(key);
        if (result == null) {
            result = this.createValidator(modelClass);
            this.classValidators.put(key, result);
        }
        return result;
    }

    protected <T> ClassValidator<T> createValidator(Class<T> modelClass) {
        ResourceBundle bundle = SeamResourceBundle.getBundle();
        return bundle == null ? new ClassValidator(modelClass) : new ClassValidator(modelClass, bundle);
    }

    public InvalidValue[] validate(ValueExpression valueExpression, ELContext elContext, Object value) {
        ValidatingResolver validatingResolver = new ValidatingResolver(elContext.getELResolver());
        ELContext decoratedContext = EL.createELContext(elContext, validatingResolver);
        valueExpression.setValue(decoratedContext, value);
        return validatingResolver.getInvalidValues();
    }

    public static Validators instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        return (Validators)Component.getInstance(Validators.class, ScopeType.APPLICATION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValidatingResolver
    extends ELResolver {
        private ELResolver delegate;
        private InvalidValue[] invalidValues;

        public ValidatingResolver(ELResolver delegate) {
            this.delegate = delegate;
        }

        public InvalidValue[] getInvalidValues() {
            return this.invalidValues;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object value) {
            return this.delegate.getCommonPropertyType(context, value);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object value) {
            return this.delegate.getFeatureDescriptors(context, value);
        }

        public Class<?> getType(ELContext context, Object x, Object y) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.delegate.getType(context, x, y);
        }

        public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.delegate.getValue(context, base, property);
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.delegate.isReadOnly(context, base, property);
        }

        public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
            if (base != null && property != null) {
                context.setPropertyResolved(true);
                this.invalidValues = Validators.this.getValidator(base).getPotentialInvalidValues(property.toString(), value);
            }
        }
    }

    class Key {
        private Class validatableClass;
        private Locale locale;

        public Key(Class validatableClass, Locale locale) {
            this.validatableClass = validatableClass;
            this.locale = locale;
        }

        public boolean equals(Object other) {
            Key key = (Key)other;
            return key.validatableClass.equals(this.validatableClass) && key.locale.equals(this.locale);
        }

        public int hashCode() {
            return this.validatableClass.hashCode() + this.locale.hashCode();
        }
    }
}

