/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.vindoz;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.runtime.api.Framework;

public class InstallAfterRestart {
    protected static List<String> pkgIds = new ArrayList<String>();
    public static final String FILE_NAME = "installAfterRestart.log";
    public static final String FAKE_VIDOZ = "org.nuxeo.fake.vindoz";
    protected static Log log = LogFactory.getLog(InstallAfterRestart.class);

    public static boolean isNeeded() {
        if ("true".equals(Framework.getProperty((String)FAKE_VIDOZ, (String)"false"))) {
            return true;
        }
        return InstallAfterRestart.isVindozBox();
    }

    public static boolean isNeededForPackage(Package pkg) {
        return !PackageType.STUDIO.equals((Object)pkg.getType()) && InstallAfterRestart.isNeeded();
    }

    protected static boolean isVindozBox() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static void addPackage(String pkgId) {
        if (!pkgIds.contains(pkgId)) {
            pkgIds.add(pkgId);
            InstallAfterRestart.savePkgList();
        }
    }

    public static boolean isMarkedForInstallAfterRestart(String pkgId) {
        return pkgIds.contains(pkgId);
    }

    protected static void savePkgList() {
        String path = Framework.getProperty((String)"nuxeo.data.dir");
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        File installFile = new File(path + FILE_NAME);
        try {
            FileUtils.writeLines((File)installFile, pkgIds);
        }
        catch (IOException e) {
            log.error((Object)"Unable to same listing of packages to install on restart", (Throwable)e);
        }
    }
}

