/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.htmlsanitizer;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.htmlsanitizer.FieldDescriptor;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerAntiSamyDescriptor;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerDescriptor;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;

public class HtmlSanitizerServiceImpl
extends DefaultComponent
implements HtmlSanitizerService {
    private static final Log log = LogFactory.getLog(HtmlSanitizerServiceImpl.class);
    public static final String ANTISAMY_XP = "antisamy";
    public static final String SANITIZER_XP = "sanitizer";
    public LinkedList<HtmlSanitizerAntiSamyDescriptor> allPolicies = new LinkedList();
    public Policy policy;
    public List<HtmlSanitizerDescriptor> allSanitizers = new ArrayList<HtmlSanitizerDescriptor>(1);
    public List<HtmlSanitizerDescriptor> sanitizers = new ArrayList<HtmlSanitizerDescriptor>(1);

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (ANTISAMY_XP.equals(extensionPoint)) {
            if (!(contribution instanceof HtmlSanitizerAntiSamyDescriptor)) {
                log.error((Object)("Contribution " + contribution + " is not of type " + HtmlSanitizerAntiSamyDescriptor.class.getName()));
                return;
            }
            HtmlSanitizerAntiSamyDescriptor desc = (HtmlSanitizerAntiSamyDescriptor)contribution;
            log.info((Object)("Registering AntiSamy policy: " + desc.policy));
            this.addAntiSamy(desc);
        } else if (SANITIZER_XP.equals(extensionPoint)) {
            if (!(contribution instanceof HtmlSanitizerDescriptor)) {
                log.error((Object)("Contribution " + contribution + " is not of type " + HtmlSanitizerDescriptor.class.getName()));
                return;
            }
            HtmlSanitizerDescriptor desc = (HtmlSanitizerDescriptor)contribution;
            log.info((Object)("Registering HTML sanitizer: " + desc));
            this.addSanitizer(desc);
        } else {
            log.error((Object)("Contribution extension point should be 'sanitizer' but is: " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (ANTISAMY_XP.equals(extensionPoint)) {
            if (!(contribution instanceof HtmlSanitizerAntiSamyDescriptor)) {
                return;
            }
            HtmlSanitizerAntiSamyDescriptor desc = (HtmlSanitizerAntiSamyDescriptor)contribution;
            log.info((Object)("Unregistering AntiSamy policy: " + desc.policy));
            this.removeAntiSamy(desc);
        } else if (SANITIZER_XP.equals(extensionPoint)) {
            if (!(contribution instanceof HtmlSanitizerDescriptor)) {
                return;
            }
            HtmlSanitizerDescriptor desc = (HtmlSanitizerDescriptor)contribution;
            log.info((Object)("Unregistering HTML sanitizer: " + desc));
            this.removeSanitizer(desc);
        }
    }

    protected void addAntiSamy(HtmlSanitizerAntiSamyDescriptor desc) {
        if (Thread.currentThread().getContextClassLoader().getResourceAsStream(desc.policy) == null) {
            log.error((Object)("Cannot find AntiSamy policy: " + desc.policy));
            return;
        }
        this.allPolicies.add(desc);
        this.refreshPolicy();
    }

    protected void removeAntiSamy(HtmlSanitizerAntiSamyDescriptor desc) {
        this.allPolicies.remove(desc);
        this.refreshPolicy();
    }

    protected void refreshPolicy() {
        if (this.allPolicies.isEmpty()) {
            this.policy = null;
        } else {
            HtmlSanitizerAntiSamyDescriptor desc = this.allPolicies.removeLast();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(desc.policy);
            try {
                this.policy = Policy.getInstance((InputStream)is);
            }
            catch (PolicyException e) {
                this.policy = null;
                throw new RuntimeException("Cannot parse AntiSamy policy: " + desc.policy, e);
            }
        }
    }

    protected Policy getPolicy() {
        return this.policy;
    }

    protected void addSanitizer(HtmlSanitizerDescriptor desc) {
        if (desc.fields.isEmpty()) {
            log.error((Object)("Sanitizer has no fields: " + desc));
            return;
        }
        this.allSanitizers.add(desc);
        this.refreshSanitizers();
    }

    protected void removeSanitizer(HtmlSanitizerDescriptor desc) {
        this.allSanitizers.remove(desc);
        this.refreshSanitizers();
    }

    protected void refreshSanitizers() {
        this.sanitizers.clear();
        for (HtmlSanitizerDescriptor sanitizer : this.allSanitizers) {
            Iterator<HtmlSanitizerDescriptor> it = this.sanitizers.iterator();
            while (it.hasNext()) {
                HtmlSanitizerDescriptor s = it.next();
                if (!s.name.equals(sanitizer.name)) continue;
                it.remove();
                break;
            }
            if (!sanitizer.enabled) continue;
            this.sanitizers.add(sanitizer);
        }
    }

    protected List<HtmlSanitizerDescriptor> getSanitizers() {
        return this.sanitizers;
    }

    @Override
    public void sanitizeDocument(DocumentModel doc) throws ClientException {
        if (this.policy == null) {
            log.error((Object)"Cannot sanitize, no policy registered");
            return;
        }
        for (HtmlSanitizerDescriptor sanitizer : this.sanitizers) {
            if (!sanitizer.types.isEmpty() && !sanitizer.types.contains(doc.getType())) continue;
            for (FieldDescriptor field : sanitizer.fields) {
                Property prop;
                String fieldName = field.getContentField();
                String filterField = field.getFilterField();
                if (filterField != null) {
                    Property filterProp;
                    try {
                        filterProp = doc.getProperty(filterField);
                    }
                    catch (PropertyNotFoundException e) {
                        continue;
                    }
                    if (!field.getFilterValue().equals(filterProp.getValue().toString())) continue;
                }
                try {
                    prop = doc.getProperty(fieldName);
                }
                catch (PropertyNotFoundException e) {
                    continue;
                }
                Serializable value = prop.getValue();
                if (value == null) continue;
                if (!(value instanceof String)) {
                    log.debug((Object)("Cannot sanitize non-string field: " + field));
                    continue;
                }
                String info = "doc " + doc.getPathAsString() + " (" + doc.getId() + ") field " + field;
                String newValue = this.sanitizeString((String)((Object)value), info);
                if (newValue.equals(value)) continue;
                prop.setValue((Object)newValue);
            }
        }
    }

    @Override
    public String sanitizeString(String string, String info) {
        if (this.policy == null) {
            log.error((Object)"Cannot sanitize, no policy registered");
            return string;
        }
        try {
            CleanResults cr = new AntiSamy().scan(string, this.policy);
            for (Object err : cr.getErrorMessages()) {
                log.debug((Object)String.format("Sanitizing %s: %s", info == null ? "" : info, err));
            }
            return cr.getCleanHTML();
        }
        catch (Exception e) {
            log.error((Object)String.format("Cannot sanitize %s: %s", info == null ? "" : info, e));
            return string;
        }
    }
}

