/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PageProviderServiceImpl
extends DefaultComponent
implements PageProviderService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PageProviderServiceImpl.class);
    public static final String PROVIDER_EP = "providers";
    Map<String, PageProviderDefinition> providers = new HashMap<String, PageProviderDefinition>();

    @Override
    public PageProviderDefinition getPageProviderDefinition(String name) {
        return this.providers.get(name);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        PageProvider<DocumentModel> pageProvider;
        if (desc == null) {
            return null;
        }
        if (desc instanceof CoreQueryPageProviderDescriptor) {
            pageProvider = new CoreQueryDocumentPageProvider();
        } else if (desc instanceof GenericPageProviderDescriptor) {
            Class<PageProvider<?>> klass = ((GenericPageProviderDescriptor)desc).getPageProviderClass();
            try {
                pageProvider = klass.newInstance();
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        } else {
            throw new ClientException(String.format("Invalid page definition with name '%s'", name));
        }
        pageProvider.setName(name);
        pageProvider.setDefinition(desc);
        HashMap<String, Object> allProps = new HashMap<String, Object>();
        Map<String, String> localProps = desc.getProperties();
        if (localProps != null) {
            allProps.putAll(localProps);
        }
        if (properties != null) {
            allProps.putAll(properties);
        }
        pageProvider.setProperties(properties);
        pageProvider.setSortable(desc.isSortable());
        pageProvider.setParameters(parameters);
        if (sortInfos == null) {
            pageProvider.setSortInfos(desc.getSortInfos());
        } else {
            pageProvider.setSortInfos(sortInfos);
        }
        if (pageSize == null || pageSize < 0L) {
            pageProvider.setPageSize(desc.getPageSize());
        } else {
            pageProvider.setPageSize(pageSize);
        }
        if (currentPage != null && currentPage > 0L) {
            pageProvider.setCurrentPage(currentPage);
        }
        return pageProvider;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        PageProviderDefinition desc = this.providers.get(name);
        return this.getPageProvider(name, desc, sortInfos, pageSize, currentPage, properties, parameters);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            String name = desc.getName();
            if (name == null) {
                log.error((Object)"Cannot register page provider without a name");
                return;
            }
            boolean enabled = desc.isEnabled();
            if (this.providers.containsKey(name)) {
                log.info((Object)("Overriding page provider with name " + name));
                if (!enabled) {
                    this.providers.remove(name);
                    log.info((Object)("Disabled page provider with name " + name));
                }
            }
            if (enabled) {
                log.info((Object)("Registering page provider with name " + name));
                this.providers.put(name, desc);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            String name = desc.getName();
            this.providers.remove(name);
            log.info((Object)("Unregistering page provider with name " + name));
        }
    }
}

