/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.export.io.WidgetTypeDefinitionComparator;

public class WidgetTypeDefinitionJsonExporter {
    private static final Log log = LogFactory.getLog(WidgetTypeDefinitionJsonExporter.class);

    public static final void export(WidgetTypeDefinition def, OutputStream out) throws IOException {
        JSONObject res = WidgetTypeDefinitionJsonExporter.exportToJson(def);
        out.write(res.toString(2).getBytes("UTF-8"));
    }

    public static final void export(List<WidgetTypeDefinition> defs, OutputStream out) throws IOException {
        JSONObject res = new JSONObject();
        if (defs != null) {
            Collections.sort(defs, new WidgetTypeDefinitionComparator());
        }
        for (WidgetTypeDefinition def : defs) {
            res.element(def.getName(), (Map)WidgetTypeDefinitionJsonExporter.exportToJson(def));
        }
        out.write(res.toString(2).getBytes("UTF-8"));
    }

    protected static JSONObject exportToJson(WidgetTypeDefinition def) {
        JSONObject json = new JSONObject();
        json.element("name", (Object)def.getName());
        json.element("handlerClassName", (Object)def.getHandlerClassName());
        json.element("properties", (Map)WidgetTypeDefinitionJsonExporter.exportStringPropsToJson(def.getProperties()));
        WidgetTypeConfiguration conf = def.getConfiguration();
        if (conf != null) {
            json.element("configuration", (Map)WidgetTypeDefinitionJsonExporter.exportToJson(conf));
        }
        return json;
    }

    protected static JSONObject exportToJson(WidgetTypeConfiguration conf) {
        JSONObject json = new JSONObject();
        json.element("title", (Object)conf.getTitle());
        json.element("description", (Object)conf.getDescription());
        JSONObject fields = new JSONObject();
        fields.element("list", conf.isList());
        fields.element("complex", conf.isComplex());
        JSONArray supportedTypes = new JSONArray();
        List confSupportedTypes = conf.getSupportedFieldTypes();
        if (confSupportedTypes != null) {
            supportedTypes.addAll((Collection)confSupportedTypes);
        }
        fields.element("supportedTypes", (Collection)supportedTypes);
        JSONArray defaultTypes = new JSONArray();
        List confDefaultTypes = conf.getDefaultFieldTypes();
        if (confDefaultTypes != null) {
            defaultTypes.addAll((Collection)confDefaultTypes);
        }
        fields.element("defaultTypes", (Collection)defaultTypes);
        json.element("fields", (Map)fields);
        JSONArray cats = new JSONArray();
        List confCats = conf.getCategories();
        if (confCats != null) {
            cats.addAll((Collection)confCats);
        }
        json.element("categories", (Collection)cats);
        JSONObject props = new JSONObject();
        Map confLayouts = conf.getPropertyLayouts();
        if (confLayouts != null) {
            ArrayList modes = new ArrayList(confLayouts.keySet());
            Collections.sort(modes);
            JSONObject layouts = new JSONObject();
            for (String mode : modes) {
                JSONArray modeLayouts = new JSONArray();
                for (LayoutDefinition layoutDef : (List)confLayouts.get(mode)) {
                    modeLayouts.add((Object)WidgetTypeDefinitionJsonExporter.exportToJson(layoutDef));
                }
                layouts.element(mode, (Collection)modeLayouts);
            }
            props.element("layouts", (Map)layouts);
        }
        json.element("properties", (Map)props);
        return json;
    }

    protected static JSONObject exportToJson(LayoutDefinition layoutDef) {
        JSONObject json = new JSONObject();
        json.element("name", (Object)layoutDef.getName());
        json.element("templates", (Map)WidgetTypeDefinitionJsonExporter.exportStringPropsToJson(layoutDef.getTemplates()));
        json.element("properties", (Map)WidgetTypeDefinitionJsonExporter.exportPropsByModeToJson(layoutDef.getProperties()));
        JSONArray rows = new JSONArray();
        LayoutRowDefinition[] defRows = layoutDef.getRows();
        ArrayList<String> widgetsToExport = new ArrayList<String>();
        if (defRows != null) {
            for (LayoutRowDefinition layoutRowDef : defRows) {
                rows.add((Object)WidgetTypeDefinitionJsonExporter.exportToJson(layoutRowDef));
                String[] widgets = layoutRowDef.getWidgets();
                if (widgets == null) continue;
                for (String widget : widgets) {
                    widgetsToExport.add(widget);
                }
            }
        }
        json.element("rows", (Collection)rows);
        JSONArray widgets = new JSONArray();
        for (String widgetName : widgetsToExport) {
            WidgetDefinition widgetDef = layoutDef.getWidgetDefinition(widgetName);
            if (widgetDef == null) {
                log.error((Object)String.format("No local definition found for widget '%s' in layout '%s' => cannot export", widgetName, layoutDef.getName()));
                continue;
            }
            widgets.add((Object)WidgetTypeDefinitionJsonExporter.exportToJson(widgetDef));
        }
        json.element("widgets", (Collection)widgets);
        return json;
    }

    protected static JSONObject exportToJson(LayoutRowDefinition layoutRowDef) {
        JSONObject json = new JSONObject();
        String name = layoutRowDef.getName();
        if (name != null) {
            json.element("name", (Object)name);
        }
        json.element("properties", (Map)WidgetTypeDefinitionJsonExporter.exportPropsByModeToJson(layoutRowDef.getProperties()));
        JSONArray widgets = new JSONArray();
        String[] defWidgets = layoutRowDef.getWidgets();
        if (defWidgets != null) {
            for (String widget : defWidgets) {
                widgets.add((Object)widget);
            }
        }
        json.element("widgets", (Collection)widgets);
        return json;
    }

    protected static JSONObject exportToJson(WidgetDefinition widgetDef) {
        JSONObject json = new JSONObject();
        json.element("name", (Object)widgetDef.getName());
        json.element("type", (Object)widgetDef.getType());
        json.element("labels", (Map)WidgetTypeDefinitionJsonExporter.exportStringPropsToJson(widgetDef.getLabels()));
        json.element("helpLabels", (Map)WidgetTypeDefinitionJsonExporter.exportStringPropsToJson(widgetDef.getHelpLabels()));
        json.element("translated", widgetDef.isTranslated());
        json.element("widgetModes", (Map)WidgetTypeDefinitionJsonExporter.exportStringPropsToJson(widgetDef.getModes()));
        JSONArray fields = new JSONArray();
        FieldDefinition[] fieldDefs = widgetDef.getFieldDefinitions();
        if (fieldDefs != null) {
            for (FieldDefinition fieldDef : fieldDefs) {
                fields.add((Object)WidgetTypeDefinitionJsonExporter.exportToJson(fieldDef));
            }
        }
        json.element("fields", (Collection)fields);
        JSONArray subWidgets = new JSONArray();
        WidgetDefinition[] subWidgetDefs = widgetDef.getSubWidgetDefinitions();
        if (subWidgetDefs != null) {
            for (WidgetDefinition wDef : subWidgetDefs) {
                subWidgets.add((Object)WidgetTypeDefinitionJsonExporter.exportToJson(wDef));
            }
        }
        json.element("subWidgets", (Collection)subWidgets);
        json.element("properties", (Map)WidgetTypeDefinitionJsonExporter.exportPropsByModeToJson(widgetDef.getProperties()));
        json.element("propertiesByWidgetMode", (Map)WidgetTypeDefinitionJsonExporter.exportPropsByModeToJson(widgetDef.getWidgetModeProperties()));
        return json;
    }

    protected static JSONObject exportToJson(FieldDefinition fieldDef) {
        JSONObject json = new JSONObject();
        json.element("fieldName", (Object)fieldDef.getFieldName());
        json.element("schemaName", (Object)fieldDef.getSchemaName());
        json.element("propertyName", (Object)fieldDef.getPropertyName());
        return json;
    }

    protected static JSONObject exportPropsByModeToJson(Map<String, Map<String, Serializable>> propsByMode) {
        JSONObject props = new JSONObject();
        if (propsByMode != null) {
            ArrayList<String> defModes = new ArrayList<String>(propsByMode.keySet());
            Collections.sort(defModes);
            for (String defMode : defModes) {
                props.element(defMode, (Map)WidgetTypeDefinitionJsonExporter.exportPropsToJson(propsByMode.get(defMode)));
            }
        }
        return props;
    }

    protected static JSONObject exportPropsToJson(Map<String, Serializable> defProps) {
        JSONObject props = new JSONObject();
        if (defProps != null) {
            ArrayList<String> defPropNames = new ArrayList<String>(defProps.keySet());
            Collections.sort(defPropNames);
            for (String defPropName : defPropNames) {
                JSONArray array;
                Serializable value = defProps.get(defPropName);
                if (value instanceof Collection) {
                    array = new JSONArray();
                    array.addAll((Collection)((Object)value));
                    props.element(defPropName, (Collection)array);
                    continue;
                }
                if (value instanceof Object[]) {
                    array = new JSONArray();
                    for (Object item : (Object[])value) {
                        array.add(item);
                    }
                    props.element(defPropName, (Collection)array);
                    continue;
                }
                props.element(defPropName, (Object)value);
            }
        }
        return props;
    }

    protected static JSONObject exportStringPropsToJson(Map<String, String> defProps) {
        JSONObject props = new JSONObject();
        if (defProps != null) {
            ArrayList<String> defPropNames = new ArrayList<String>(defProps.keySet());
            Collections.sort(defPropNames);
            for (String defPropName : defPropNames) {
                props.element(defPropName, (Object)defProps.get(defPropName));
            }
        }
        return props;
    }
}

