/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerAdapter;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationDefinition;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.filter.TypeFilter;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointerFactory;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.i18n.TranslationConstants;

public class NewAnnotationPopup
extends PopupPanel {
    private final AnnotationController controller;
    public String selectedAnnotationType = null;
    private final ListBox listBox = new ListBox();
    private final List<ListBox> fieldListBoxes = new ArrayList<ListBox>();
    private final VerticalPanel verticalPanel = new VerticalPanel();
    private final DockPanel dockPanel = new DockPanel();
    private final AnnotationTextArea annotationTextArea = new AnnotationTextArea();
    private final HorizontalPanel flowPanel = new HorizontalPanel();
    private final Button submit;
    private final Button cancel;
    private final Element element;
    private final boolean removeOnCancel;

    public NewAnnotationPopup(Element element, AnnotationController controller, boolean removeOnCancel, String annotationType) {
        this(element, controller, removeOnCancel, annotationType, null);
    }

    public NewAnnotationPopup(Element element, AnnotationController controller, boolean removeOnCancel, String annotationType, String annotationName) {
        this.controller = controller;
        this.element = element;
        this.removeOnCancel = removeOnCancel;
        GWT.log((String)"creating new annotation pop up", null);
        int scroll = Document.get().getBody().getScrollTop();
        controller.setFrameScrollFromTop(scroll);
        this.dockPanel.setStyleName("annotationsNewAnnotationPopup");
        this.dockPanel.add((Widget)this.verticalPanel, DockPanel.NORTH);
        this.dockPanel.add((Widget)this.annotationTextArea, DockPanel.CENTER);
        this.dockPanel.add((Widget)this.flowPanel, DockPanel.SOUTH);
        if (annotationName != null) {
            this.selectedAnnotationType = annotationName;
            this.verticalPanel.add((Widget)new Label(this.selectedAnnotationType));
            Map<String, String[]> fields = controller.getWebConfiguration().getAnnotationDefinition(annotationName).getFields();
            for (String fieldName : fields.keySet()) {
                ListBox fieldListBox = new ListBox();
                fieldListBox.setName(fieldName);
                for (String choice : fields.get(fieldName)) {
                    fieldListBox.addItem(choice);
                }
                this.fieldListBoxes.add(fieldListBox);
                this.verticalPanel.add((Widget)fieldListBox);
            }
        } else {
            WebConfiguration webConf = controller.getWebConfiguration();
            List<AnnotationDefinition> annotationDefs = webConf.getAnnotationDefinitions(new TypeFilter(annotationType));
            if (annotationDefs.size() == 1) {
                this.selectedAnnotationType = annotationDefs.get(0).getName();
                this.verticalPanel.add((Widget)new Label(this.selectedAnnotationType));
            } else {
                for (AnnotationDefinition annotationDef : annotationDefs) {
                    this.listBox.addItem(annotationDef.getName());
                }
                this.verticalPanel.add((Widget)this.listBox);
            }
        }
        TranslationConstants translationContants = (TranslationConstants)GWT.create(TranslationConstants.class);
        this.submit = new Button(translationContants.submit());
        this.submit.setEnabled(false);
        this.flowPanel.add((Widget)this.submit);
        this.cancel = new Button(translationContants.cancel());
        this.flowPanel.add((Widget)this.cancel);
        this.submit.addClickListener((ClickListener)new CommitListener(element, annotationName));
        this.cancel.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                NewAnnotationPopup.this.cancel();
            }
        });
        this.add((Widget)this.dockPanel);
    }

    public void cancel() {
        if (this.removeOnCancel) {
            this.element.getParentElement().removeChild((Node)this.element);
        }
        this.controller.setCancelNewAnnotation();
        this.controller.removeSelectedTextDecoration();
        this.hide();
    }

    public void show() {
        Log.debug((String)("popup.show: " + Window.getScrollTop() + 50));
        this.setPopupPosition(50 + Window.getScrollLeft(), Window.getScrollTop() + 50);
        this.controller.openCreationPopup();
        super.show();
    }

    public void hide() {
        this.controller.closeCreationPopup();
        super.hide();
    }

    public void onLoad() {
        super.onLoad();
        this.annotationTextArea.setFocus(true);
    }

    private String getType() {
        if (this.selectedAnnotationType != null) {
            return this.selectedAnnotationType;
        }
        return this.listBox.getItemText(this.listBox.getSelectedIndex());
    }

    private class CommitListener
    implements ClickListener {
        public final Element element;

        public CommitListener(Element element, String annotationName) {
            this.element = element;
        }

        public void onClick(Widget sender) {
            String text = NewAnnotationPopup.this.annotationTextArea.getText();
            if (text.length() > 2000) {
                Window.alert((String)"Your annotation must not exceed 2000 characters long.");
                return;
            }
            Annotation annotation = NewAnnotationPopup.this.controller.getNewAnnotation();
            annotation.setBody(text);
            annotation.setType(NewAnnotationPopup.this.getType());
            for (ListBox fieldListBox : NewAnnotationPopup.this.fieldListBoxes) {
                annotation.getFields().put(fieldListBox.getName(), fieldListBox.getItemText(fieldListBox.getSelectedIndex()));
            }
            if (XPointerFactory.isImageRange(annotation.getXpointer().getXpointerString()) && this.element != null) {
                this.element.getParentNode().removeChild((Node)this.element);
            }
            NewAnnotationPopup.this.controller.removeSelectedTextDecoration();
            NewAnnotationPopup.this.controller.submitNewAnnotation();
            NewAnnotationPopup.this.hide();
        }
    }

    private class AnnotationTextArea
    extends TextArea {
        public AnnotationTextArea() {
            this.addKeyboardListener((KeyboardListener)new KeyboardListenerAdapter(){

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    String content = AnnotationTextArea.this.getText();
                    if (content.trim().equals("")) {
                        NewAnnotationPopup.this.submit.setEnabled(false);
                    } else {
                        NewAnnotationPopup.this.submit.setEnabled(true);
                    }
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                    TextArea ta = (TextArea)sender;
                    String content = ta.getText();
                    if ((Character.isLetterOrDigit(keyCode) || Character.isSpace(keyCode)) && content.length() >= 2000) {
                        ta.cancelKey();
                    }
                }
            });
            this.setCharacterWidth(30);
            this.setVisibleLines(6);
        }
    }
}

