/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.NoSuchPropertyException;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;

public class CompatVersioningService
extends StandardVersioningService {
    private static final Log log = LogFactory.getLog(CompatVersioningService.class);

    @Override
    public String getVersionLabel(DocumentModel doc) {
        try {
            return this.getMajor(doc) + "." + this.getMinor(doc);
        }
        catch (PropertyNotFoundException e) {
            return "";
        }
        catch (ClientException e) {
            log.debug((Object)"No version label", (Throwable)e);
            return "";
        }
    }

    @Override
    protected void setInitialVersion(Document doc) throws DocumentException {
        this.setVersion(doc, 1L, 0L);
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment) throws DocumentException {
        boolean increment;
        boolean bl = increment = (option = this.validateOption(doc, option)) != VersioningOption.NONE;
        if (increment && doc.isCheckedOut()) {
            doc.checkIn(null, checkinComment);
        }
        if (!doc.isCheckedOut() && (isDirty || increment)) {
            doc.checkOut();
        }
        return option;
    }

    @Override
    public void doPostSave(Document doc, VersioningOption option, String checkinComment) throws DocumentException {
        if (!doc.isCheckedOut()) {
            return;
        }
        this.incrementByOption(doc, option);
        this.followTransitionByOption(doc, option);
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) throws DocumentException {
        return doc.checkIn(null, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) throws DocumentException {
        doc.checkOut();
        try {
            Document last = doc.getLastVersion();
            if (last != null) {
                this.setVersion(doc, this.getMajor(last), this.getMinor(last) + 1L);
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
    }
}

