/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.JBossConfigurator;
import org.nuxeo.launcher.config.JettyConfigurator;
import org.nuxeo.launcher.config.ServerConfigurator;
import org.nuxeo.launcher.config.TomcatConfigurator;
import org.nuxeo.log4j.Log4JHelper;

public class ConfigurationGenerator {
    private static final Log log = LogFactory.getLog(ConfigurationGenerator.class);
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_CONF = "nuxeo.conf";
    protected static final String TEMPLATES = "templates";
    protected static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    @Deprecated
    public static final String PARAM_TEMPLATE_NAME = "nuxeo.template";
    public static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    public static final String PARAM_TEMPLATE_DBNAME = "nuxeo.dbtemplate";
    public static final String PARAM_TEMPLATES_NODB = "nuxeo.nodbtemplates";
    public static final String PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.templates.parsing.extensions";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    public static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    public static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final List<String> DB_LIST = Arrays.asList("default", "postgresql", "oracle", "mysql", "mssql");
    public static final String PARAM_WIZARD_DONE = "nuxeo.wizard.done";
    public static final String PARAM_WIZARD_RESTART_PARAMS = "wizard.restart.params";
    public static final String PARAM_FAKE_WINDOWS = "org.nuxeo.fake.vindoz";
    private final File nuxeoHome;
    private final File nuxeoConf;
    private final List<File> includedTemplates = new ArrayList<File>();
    private File nuxeoDefaultConf;
    public boolean isJBoss;
    public boolean isJetty;
    public boolean isTomcat;
    private ServerConfigurator serverConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private Properties userConfig;
    private boolean configurable = false;
    private boolean onceGeneration = false;
    private String templates;
    private boolean setOnceToFalse = true;
    private boolean setFalseToOnce = false;
    private String wizardParam = null;

    public boolean isConfigurable() {
        return this.configurable;
    }

    public ConfigurationGenerator() {
        File userDir;
        String nuxeoHomePath = System.getProperty(NUXEO_HOME);
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        this.nuxeoHome = nuxeoHomePath != null ? new File(nuxeoHomePath) : ("bin".equalsIgnoreCase((userDir = new File(System.getProperty("user.dir"))).getName()) ? userDir.getParentFile() : userDir);
        this.nuxeoConf = nuxeoConfPath != null ? new File(nuxeoConfPath) : new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF);
        this.nuxeoDefaultConf = new File(this.nuxeoHome, TEMPLATES + File.separator + NUXEO_DEFAULT_CONF);
        this.isJBoss = System.getProperty("jboss.home.dir") != null;
        this.isJetty = System.getProperty("jetty.home") != null;
        boolean bl = this.isTomcat = System.getProperty("tomcat.home") != null;
        if (!(this.isJBoss || this.isJetty || this.isTomcat)) {
            String[] files;
            this.isJBoss = new File(this.nuxeoHome, "bin/run.jar").exists();
            this.isTomcat = new File(this.nuxeoHome, "bin/bootstrap.jar").exists();
            for (String file : files = this.nuxeoHome.list()) {
                if (!file.startsWith("nuxeo-runtime-launcher")) continue;
                this.isJetty = true;
                break;
            }
        }
        if (this.isJBoss) {
            this.serverConfigurator = new JBossConfigurator(this);
        } else if (this.isTomcat) {
            this.serverConfigurator = new TomcatConfigurator(this);
        } else if (this.isJetty) {
            this.serverConfigurator = new JettyConfigurator(this);
        }
        if (Logger.getRootLogger().getAllAppenders() instanceof NullEnumeration) {
            this.serverConfigurator.initLogs();
        }
        log.info((Object)("Nuxeo home:          " + this.nuxeoHome.getPath()));
        log.info((Object)("Nuxeo configuration: " + this.nuxeoConf.getPath()));
    }

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public Properties getUserConfig() {
        return this.userConfig;
    }

    public final ServerConfigurator getServerConfigurator() {
        return this.serverConfigurator;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.serverConfigurator.isConfigured()) {
                log.info((Object)"No current configuration, generating files...");
                this.generateFiles();
            } else if (this.forceGeneration) {
                log.info((Object)("Configuration files generation (nuxeo.force.generation=" + this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false") + ")..."));
                this.generateFiles();
            } else {
                log.info((Object)"Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        if (this.serverConfigurator == null) {
            log.warn((Object)"Unrecognized server. Considered as already configured.");
            this.configurable = false;
        } else if (!this.nuxeoConf.exists()) {
            log.info((Object)("Missing " + this.nuxeoConf));
            this.configurable = false;
        } else if (this.userConfig == null) {
            try {
                this.setBasicConfiguration();
                this.configurable = true;
            }
            catch (ConfigurationException e) {
                log.warn((Object)"Error reading basic configuration.", (Throwable)e);
                this.configurable = false;
            }
        } else {
            this.configurable = true;
        }
        return this.configurable;
    }

    public void changeTemplates(String newTemplates) {
        try {
            this.includedTemplates.clear();
            this.templates = newTemplates;
            this.setBasicConfiguration();
            this.configurable = true;
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Error reading basic configuration.", (Throwable)e);
            this.configurable = false;
        }
    }

    public void changeDBTemplate(String dbTemplate) {
        this.changeTemplates(this.rebuildTemplatesStr(dbTemplate));
    }

    private void setBasicConfiguration() throws ConfigurationException {
        try {
            this.defaultConfig = new Properties();
            this.defaultConfig.load(new FileInputStream(this.nuxeoDefaultConf));
            this.userConfig = new Properties(this.defaultConfig);
            this.userConfig.putAll((Map<?, ?>)System.getProperties());
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                this.replaceBackslashes();
            }
            this.userConfig.load(new FileInputStream(this.nuxeoConf));
            this.onceGeneration = "once".equals(this.userConfig.getProperty(PARAM_FORCE_GENERATION));
            this.forceGeneration = this.onceGeneration || Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
            this.setDirectoryWithProperty("nuxeo.data.dir");
            this.setDirectoryWithProperty("nuxeo.log.dir");
            this.setDirectoryWithProperty("nuxeo.pid.dir");
            this.setDirectoryWithProperty("nuxeo.tmp.dir");
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + this.nuxeoDefaultConf + " or " + this.nuxeoConf, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            if (this.templates == null) {
                this.templates = this.getUserTemplates();
            }
            this.extractDatabaseTemplateName();
            this.includeTemplates(this.templates);
            log.debug((Object)("Loaded configuration: " + this.userConfig));
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
    }

    protected void replaceBackslashes() throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*:\\\\.*")) {
                    line = line.replaceAll("\\\\", "/");
                }
                sb.append(line + System.getProperty("line.separator"));
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(sb.toString());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    public void setDirectoryWithProperty(String key) {
        String directory = this.userConfig.getProperty(key);
        if (directory == null) {
            this.userConfig.setProperty(key, this.serverConfigurator.getDirectory(key).getPath());
        } else {
            this.serverConfigurator.setDirectory(key, directory);
        }
    }

    private String getUserTemplates() {
        String userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        if (userTemplatesList == null) {
            userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATE_NAME);
        }
        return userTemplatesList;
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.serverConfigurator.parseAndCopy(this.userConfig);
            this.serverConfigurator.dumpProperties(this.userConfig);
            log.info((Object)"Configuration files generated.");
            if (this.onceGeneration) {
                this.setOnceToFalse = true;
                this.writeConfiguration(this.loadConfiguration());
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure", e);
        }
    }

    private void writeConfiguration(StringBuffer configuration) throws ConfigurationException {
        this.writeConfiguration(configuration, null);
    }

    private void includeTemplates(String templatesList) throws IOException {
        StringTokenizer st = new StringTokenizer(templatesList, ",");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists() || !chosenTemplate.getPath().equals(chosenTemplate.getAbsolutePath())) {
                chosenTemplate = new File(this.nuxeoDefaultConf.getParentFile(), nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug((Object)("Already included " + nextToken));
                continue;
            }
            if (chosenTemplate.exists()) {
                File chosenTemplateConf = new File(chosenTemplate, NUXEO_DEFAULT_CONF);
                if (chosenTemplateConf.exists()) {
                    Properties subTemplateConf = new Properties();
                    subTemplateConf.load(new FileInputStream(chosenTemplateConf));
                    String subTemplatesList = subTemplateConf.getProperty(PARAM_INCLUDED_TEMPLATES);
                    if (subTemplatesList != null && subTemplatesList.length() > 0) {
                        this.includeTemplates(subTemplatesList);
                    }
                    this.defaultConfig.load(new FileInputStream(chosenTemplateConf));
                    log.info((Object)("Include template: " + chosenTemplate.getPath()));
                } else {
                    log.debug((Object)("No default configuration for template " + nextToken));
                }
                this.includedTemplates.add(chosenTemplate);
                continue;
            }
            log.error((Object)String.format("Template '%s' not found with relative or absolute path (%s). Check your %s parameter, and %s for included files.", nextToken, chosenTemplate, PARAM_TEMPLATES_NAME, PARAM_INCLUDED_TEMPLATES));
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoDefaultConf() {
        return this.nuxeoDefaultConf;
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }

    public static void main(String[] args) throws ConfigurationException {
        new ConfigurationGenerator().run();
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.setOnceToFalse = false;
        this.setFalseToOnce = true;
        this.wizardParam = changedParameters.remove(PARAM_WIZARD_DONE);
        this.writeConfiguration(this.loadConfiguration(), changedParameters);
    }

    public void saveFilteredConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.saveConfiguration(this.getChangedParameters(changedParameters));
    }

    public Map<String, String> getChangedParameters(Map<String, String> changedParameters) {
        HashMap<String, String> filteredChangedParameters = new HashMap<String, String>();
        for (String key : changedParameters.keySet()) {
            String oldParam = this.userConfig.getProperty(key);
            String newParam = changedParameters.get(key).trim();
            if ((oldParam != null || newParam.isEmpty()) && (oldParam == null || oldParam.trim().equals(newParam))) continue;
            filteredChangedParameters.put(key, changedParameters.get(key).trim());
        }
        return filteredChangedParameters;
    }

    private void writeConfiguration(StringBuffer newContent, Map<String, String> changedParameters) throws ConfigurationException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(newContent.toString());
            if (changedParameters != null && !changedParameters.isEmpty()) {
                writer.write("### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ### " + new Date().toString() + System.getProperty("line.separator"));
                for (String key : changedParameters.keySet()) {
                    writer.write("#" + key + "=" + this.userConfig.getProperty(key) + System.getProperty("line.separator"));
                    writer.write(key + "=" + changedParameters.get(key) + System.getProperty("line.separator"));
                }
                writer.write(BOUNDARY_END + System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    private StringBuffer loadConfiguration() throws ConfigurationException {
        StringBuffer newContent = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                if (!onConfiguratorContent) {
                    if (!line.startsWith(BOUNDARY_BEGIN)) {
                        if (line.startsWith(PARAM_FORCE_GENERATION)) {
                            if (this.setOnceToFalse && this.onceGeneration) {
                                line = "nuxeo.force.generation=false";
                            }
                            if (this.setFalseToOnce && !this.forceGeneration) {
                                line = "nuxeo.force.generation=once";
                            }
                        } else if (line.startsWith(PARAM_WIZARD_DONE) && this.wizardParam != null) {
                            line = "nuxeo.wizard.done=" + this.wizardParam;
                        }
                        newContent.append(line + System.getProperty("line.separator"));
                        continue;
                    }
                    onConfiguratorContent = true;
                    continue;
                }
                if (!line.startsWith(BOUNDARY_END)) continue;
                onConfiguratorContent = false;
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        return newContent;
    }

    public String extractDatabaseTemplateName() {
        String dbTemplate = "unknown";
        String nodbTemplates = "";
        StringTokenizer st = new StringTokenizer(this.templates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (DB_LIST.contains(template)) {
                dbTemplate = template;
                continue;
            }
            nodbTemplates = nodbTemplates + template;
        }
        this.userConfig.put(PARAM_TEMPLATES_NODB, nodbTemplates);
        this.userConfig.put(PARAM_TEMPLATE_DBNAME, dbTemplate);
        return dbTemplate;
    }

    public File getNuxeoConf() {
        return this.nuxeoConf;
    }

    public void initLogs() {
        this.serverConfigurator.initLogs();
    }

    public File getLogDir() {
        return this.serverConfigurator.getLogDir();
    }

    public File getPidDir() {
        return this.serverConfigurator.getPidDir();
    }

    public File getDataDir() {
        return this.serverConfigurator.getDataDir();
    }

    public void verifyInstallation() throws ConfigurationException {
        if (!System.getProperty("java.version").startsWith("1.6")) {
            String message = "Nuxeo requires Java 1.6 (detected " + System.getProperty("java.version") + ").";
            if ("nofail".equalsIgnoreCase(System.getProperty("jvmcheck", "fail"))) {
                log.error((Object)message);
            } else {
                throw new ConfigurationException(message);
            }
        }
        this.ifNotExistsAndIsDirectoryThenCreate(this.getLogDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getPidDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getDataDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getTmpDir());
        this.serverConfigurator.checkPaths();
        this.serverConfigurator.removeExistingLocks();
        this.serverConfigurator.removeHotfixesAtUpgrade();
    }

    public File getTmpDir() {
        return this.serverConfigurator.getTmpDir();
    }

    private void ifNotExistsAndIsDirectoryThenCreate(File directory) {
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    public ArrayList<String> getLogFiles() {
        File log4jConfFile = this.serverConfigurator.getLogConfFile();
        System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
        return Log4JHelper.getFileAppendersFiles(log4jConfFile);
    }

    public boolean isWizardRequired() {
        return !"true".equalsIgnoreCase(this.getUserConfig().getProperty(PARAM_WIZARD_DONE, "true")) && this.serverConfigurator.isWizardAvailable();
    }

    public String rebuildTemplatesStr(String dbTemplate) {
        String nodbTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NODB);
        if (nodbTemplates == null) {
            this.extractDatabaseTemplateName();
            nodbTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NODB);
        }
        String newTemplates = nodbTemplates.isEmpty() ? dbTemplate : dbTemplate + "," + nodbTemplates;
        return newTemplates;
    }

    public File getConfigDir() {
        return this.serverConfigurator.getConfigDir();
    }

    public void prepareWizardStart() {
        this.serverConfigurator.prepareWizardStart();
    }

    public void cleanupPostWizard() {
        this.serverConfigurator.cleanupPostWizard();
    }

    public File getRuntimeHome() {
        return this.serverConfigurator.getRuntimeHome();
    }

    public boolean isInstallInProgress() {
        return this.getInstallFile().exists();
    }

    public File getInstallFile() {
        return new File(this.serverConfigurator.getDataDir(), "installAfterRestart.log");
    }
}

