/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.core.Function;
import com.gwtext.client.widgets.Tool;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.gwtext.client.widgets.portal.Portlet;
import java.util.ArrayList;
import org.nuxeo.opensocial.container.client.ContainerConstants;
import org.nuxeo.opensocial.container.client.ContainerEntryPoint;
import org.nuxeo.opensocial.container.client.ContainerMessages;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.view.ContainerPortal;
import org.nuxeo.opensocial.container.client.view.GadgetForm;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;

public class GadgetTools {
    private static final ContainerConstants CST = (ContainerConstants)GWT.create(ContainerConstants.class);
    private static final ContainerMessages MSG = (ContainerMessages)GWT.create(ContainerMessages.class);
    private GadgetForm form;
    private GadgetPortlet portlet;
    private String title;

    public GadgetTools(GadgetPortlet portlet) {
        this.portlet = portlet;
        this.title = portlet.getTitle();
    }

    public Tool[] getButtons() {
        if (this.portlet.getView().equals("canvas")) {
            return this.getCanvasButtons();
        }
        return this.getDefaultButtons();
    }

    private Tool[] getCanvasButtons() {
        Tool min = new Tool(Tool.MINIMIZE, new Function(){

            public void execute() {
                GadgetTools.this.minimize();
            }
        });
        return new Tool[]{min};
    }

    public void minimize() {
        ContainerPortal portal = ContainerEntryPoint.getContainerPortal();
        PortalColumn maximizedCol = portal.getMaximizedCol();
        maximizedCol.remove(this.portlet.getId(), true);
        GadgetTools.showManager();
        for (PortalColumn col : portal.getPortalColumns()) {
            col.show();
        }
        maximizedCol.hide();
        this.updateLayoutSizeForMin("970px");
    }

    private native void updateLayoutSizeForMin(String var1);

    private Tool[] getDefaultButtons() {
        final GadgetBean gadget = this.portlet.getGadgetBean();
        Tool gear = new Tool(Tool.GEAR, new Function(){

            public void execute() {
                GadgetTools.this.launchGear();
            }
        });
        Tool close = new Tool(Tool.CLOSE, new Function(){

            public void execute() {
                if (Window.confirm((String)MSG.askedDeleteGadget(GadgetTools.this.title != null ? GadgetTools.this.title : ""))) {
                    GadgetTools.this.portlet.hide();
                    ContainerEntryPoint.getService().removeGadget(gadget, ContainerEntryPoint.getGwtParams(), new AsyncCallback<GadgetBean>(){

                        public void onFailure(Throwable arg0) {
                            ContainerPortal.showErrorMessage(CST.error(), CST.deleteError());
                        }

                        public void onSuccess(GadgetBean gadget) {
                            ContainerEntryPoint.getContainerPortal().removeGadgetPortlet(GadgetTools.this.portlet.getId());
                        }
                    });
                }
            }
        });
        Tool max = new Tool(Tool.MAXIMIZE, new Function(){

            public void execute() {
                GadgetTools.this.maximize("canvas");
            }
        });
        ArrayList<Tool> tools = new ArrayList<Tool>();
        if (gadget.getView("canvas") != null) {
            tools.add(max);
        }
        if (gadget.isConfigurable()) {
            tools.add(gear);
        }
        if (gadget.isEditable()) {
            tools.add(close);
        }
        Tool[] array = tools.toArray(new Tool[tools.size()]);
        return array;
    }

    public void maximize(String view) {
        GadgetBean gadget = this.portlet.getGadgetBean();
        ContainerPortal portal = ContainerEntryPoint.getContainerPortal();
        PortalColumn maximizedCol = portal.getMaximizedCol();
        GadgetPortlet canvas = new GadgetPortlet(gadget, view);
        ContainerPortal.setMaximizedPortlet(canvas);
        maximizedCol.add((Portlet)canvas);
        GadgetTools.hideManager();
        for (PortalColumn col : portal.getPortalColumns()) {
            col.hide();
        }
        maximizedCol.show();
        canvas.show();
        canvas.updateGadgetPortlet();
        canvas.doLayout();
        maximizedCol.doLayout();
        this.updateLayoutSizeForMax(canvas.getId());
        if (gadget.isCollapsed()) {
            canvas.unCollapseGadget();
            gadget.setCollapsed(true);
        }
    }

    private native void updateLayoutSizeForMax(String var1);

    public void setGadgetForm(GadgetForm form) {
        this.form = form;
    }

    private static native void hideManager();

    private static native void showManager();

    public void launchGear() {
        if (this.form != null) {
            this.form.showForm();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

