/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutDescriptors;

@XObject(value="configuration")
public class WidgetTypeConfigurationDescriptor
implements WidgetTypeConfiguration {
    private static final long serialVersionUID = 1L;
    @XNode(value="title")
    String title;
    @XNode(value="description")
    String description;
    @XNode(value="fields/list")
    boolean list = false;
    @XNode(value="fields/complex")
    boolean complex = false;
    @XNodeList(value="fields/supportedTypes", type=ArrayList.class, componentType=String.class)
    List<String> supportedFieldTypes;
    @XNodeList(value="fields/defaultTypes", type=ArrayList.class, componentType=String.class)
    List<String> defaultFieldTypes;
    @XNodeList(value="categories/category", type=ArrayList.class, componentType=String.class)
    List<String> categories;
    @XNodeMap(value="properties/layouts", key="@mode", type=HashMap.class, componentType=LayoutDescriptors.class)
    Map<String, LayoutDescriptors> propertyLayouts;

    public List<String> getCategories() {
        return this.categories;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isList() {
        return this.list;
    }

    public List<String> getDefaultFieldTypes() {
        return this.defaultFieldTypes;
    }

    public List<String> getSupportedFieldTypes() {
        return this.supportedFieldTypes;
    }

    public List<LayoutDefinition> getPropertyLayouts(String mode, String additionalMode) {
        if (this.propertyLayouts != null) {
            List<LayoutDefinition> modeLayoutsList;
            LayoutDescriptors modeLayouts;
            List<LayoutDefinition> defaultLayoutsList;
            LayoutDescriptors defaultLayouts;
            ArrayList<LayoutDefinition> res = new ArrayList<LayoutDefinition>();
            if (additionalMode != null && (defaultLayouts = this.propertyLayouts.get(additionalMode)) != null && (defaultLayoutsList = defaultLayouts.getLayouts()) != null) {
                res.addAll(defaultLayoutsList);
            }
            if ((modeLayouts = this.propertyLayouts.get(mode)) != null && (modeLayoutsList = modeLayouts.getLayouts()) != null) {
                res.addAll(modeLayoutsList);
            }
            return res;
        }
        return null;
    }

    public Map<String, List<LayoutDefinition>> getPropertyLayouts() {
        if (this.propertyLayouts != null) {
            HashMap<String, List<LayoutDefinition>> res = new HashMap<String, List<LayoutDefinition>>();
            for (Map.Entry<String, LayoutDescriptors> entry : this.propertyLayouts.entrySet()) {
                res.put(entry.getKey(), entry.getValue().getLayouts());
            }
            return res;
        }
        return null;
    }
}

