/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentHandler;
import com.sun.facelets.tag.ui.IncludeHandler;
import com.sun.facelets.tag.ui.ParamHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.TagConfigFactory;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class LayoutTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute definition;
    protected final TagAttribute mode;
    protected final TagAttribute value;
    protected final TagAttribute template;
    protected final TagAttribute selectedRows;
    protected final TagAttribute selectedColumns;
    protected final TagAttribute selectAllByDefault;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "name", "definition", "mode", "value", "template", "selectedRows", "selectedColumns", "selectAllByDefault"};

    public LayoutTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getAttribute("name");
        this.definition = this.getAttribute("definition");
        if (this.name == null && this.definition == null) {
            throw new TagException(this.tag, "At least one of attributes 'name', 'definition' or 'layout' is required");
        }
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getRequiredAttribute("value");
        this.template = this.getAttribute("template");
        this.selectedRows = this.getAttribute("selectedRows");
        this.selectedColumns = this.getAttribute("selectedColumns");
        if (this.selectedRows != null && this.selectedColumns != null) {
            throw new TagException(this.tag, "Attributes 'selectedRows' and 'selectedColumns' are aliases: only one of them should be filled");
        }
        this.selectAllByDefault = this.getAttribute("selectAllByDefault");
        this.vars = this.tag.getAttributes().getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        WebLayoutManager layoutService;
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (layoutService == null) {
            throw new FacesException("Layout service not found");
        }
        String modeValue = this.mode.getValue(ctx);
        String valueName = this.value.getValue();
        if (ComponentTagUtils.isValueReference((String)valueName)) {
            valueName = valueName.substring(2, valueName.length() - 1);
        }
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        Map<String, ValueExpression> variables = this.getVariablesForLayoutBuild(ctx, modeValue);
        String layoutName = null;
        Layout layoutInstance = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        try {
            for (Map.Entry<String, ValueExpression> var : variables.entrySet()) {
                vm.setVariable(var.getKey(), var.getValue());
            }
            List selectedRowsValue = null;
            if (this.selectedRows != null || this.selectedColumns != null) {
                if (this.selectedRows != null) {
                    selectedRowsValue = (List)this.selectedRows.getObject(ctx, List.class);
                } else if (this.selectedColumns != null) {
                    selectedRowsValue = (List)this.selectedColumns.getObject(ctx, List.class);
                }
            }
            boolean selectAllByDefaultValue = false;
            if (this.selectAllByDefault != null) {
                selectAllByDefaultValue = this.selectAllByDefault.getBoolean(ctx);
            }
            if (this.name != null) {
                layoutName = this.name.getValue(ctx);
                layoutInstance = layoutService.getLayout(ctx, layoutName, modeValue, valueName, (List<String>)selectedRowsValue, selectAllByDefaultValue);
            } else if (this.definition != null) {
                LayoutDefinition layoutDef = (LayoutDefinition)this.definition.getObject(ctx, LayoutDefinition.class);
                if (layoutDef == null) {
                    String errMsg = "Layout definition resolved to null";
                    log.error((Object)errMsg);
                    ComponentHandler output = helper.getErrorComponentHandler(errMsg);
                    output.apply(ctx, parent);
                    return;
                }
                layoutName = layoutDef.getName();
                layoutInstance = layoutService.getLayout(ctx, layoutDef, modeValue, valueName, (List<String>)selectedRowsValue, selectAllByDefaultValue);
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
        if (layoutInstance == null) {
            String errMsg = String.format("Layout '%s' not found", layoutName);
            log.error((Object)errMsg);
            ComponentHandler output = helper.getErrorComponentHandler(errMsg);
            output.apply(ctx, parent);
            return;
        }
        layoutInstance.setId(helper.generateLayoutId(layoutInstance.getName()));
        List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
        for (TagAttribute var : this.vars) {
            String localName = var.getLocalName();
            if (reservedVars.contains(localName)) continue;
            layoutInstance.setProperty(localName, (Serializable)((Object)var.getValue()));
        }
        String templateValue = null;
        if (this.template != null) {
            templateValue = this.template.getValue(ctx);
        }
        if (templateValue == null || "".equals(templateValue)) {
            templateValue = layoutInstance.getTemplate();
        }
        if (templateValue != null && !"".equals(templateValue)) {
            TagConfig config = TagConfigFactory.createTagConfig(this.config, FaceletHandlerHelper.getTagAttributes(helper.createAttribute("src", templateValue)), this.getNextHandler(ctx, this.config, helper, layoutInstance));
            IncludeHandler includeHandler = new IncludeHandler(config);
            variables.putAll(this.getVariablesForLayout(ctx, layoutInstance));
            FaceletHandler handler = helper.getAliasTagHandler(variables, (FaceletHandler)includeHandler);
            handler.apply(ctx, parent);
        } else {
            log.error((Object)("Missing template property for layout " + layoutName));
        }
    }

    protected Map<String, ValueExpression> getVariablesForLayoutBuild(FaceletContext ctx, String modeValue) {
        HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
        ValueExpression valueExpr = this.value.getValueExpression(ctx, Object.class);
        variables.put(RenderVariables.globalVariables.value.name(), valueExpr);
        variables.put(RenderVariables.globalVariables.document.name(), valueExpr);
        variables.put(RenderVariables.globalVariables.layoutValue.name(), valueExpr);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression modeVe = eFactory.createValueExpression((Object)modeValue, String.class);
        variables.put(RenderVariables.globalVariables.layoutMode.name(), modeVe);
        variables.put(RenderVariables.globalVariables.mode.name(), modeVe);
        return variables;
    }

    protected Map<String, ValueExpression> getVariablesForLayout(FaceletContext ctx, Layout layoutInstance) {
        HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression layoutVe = eFactory.createValueExpression((Object)layoutInstance, Layout.class);
        variables.put(RenderVariables.layoutVariables.layout.name(), layoutVe);
        return variables;
    }

    protected FaceletHandler getNextHandler(FaceletContext ctx, TagConfig tagConfig, FaceletHandlerHelper helper, Layout layoutInstance) throws WidgetException {
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        ArrayList<ParamHandler> paramHandlers = new ArrayList<ParamHandler>();
        TagAttribute name = helper.createAttribute("name", RenderVariables.layoutVariables.layout.name());
        TagAttribute value = helper.createAttribute("value", "#{layout}");
        TagConfig config = TagConfigFactory.createTagConfig(tagConfig, FaceletHandlerHelper.getTagAttributes(name, value), leaf);
        paramHandlers.add(new ParamHandler(config));
        for (Map.Entry prop : layoutInstance.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            TagAttribute name2 = helper.createAttribute("name", String.format("%s_%s", RenderVariables.layoutVariables.layoutProperty.name(), key));
            Serializable valueInstance = (Serializable)prop.getValue();
            TagAttribute value2 = !helper.shouldCreateReferenceAttribute(key, valueInstance) ? helper.createAttribute("value", (String)((Object)valueInstance)) : helper.createAttribute("value", String.format("#{%s.properties.%s}", RenderVariables.layoutVariables.layout.name(), key));
            TagConfig config2 = TagConfigFactory.createTagConfig(tagConfig, FaceletHandlerHelper.getTagAttributes(name2, value2), leaf);
            paramHandlers.add(new ParamHandler(config2));
        }
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(paramHandlers);
        children.add(this.nextHandler);
        return new CompositeFaceletHandler(children.toArray(new FaceletHandler[0]));
    }
}

