/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.CmisAtomPubConstants;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAcl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAllowableActions;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomBase;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.RepositoryWorkspace;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.ServiceDoc;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisProperty;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyId;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDocumentDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeFolderDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypePolicyDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeRelationshipDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomPubParser
implements CmisAtomPubConstants {
    public static final String LINK_REL_CONTENT = "@@content@@";
    private InputStream fStream;
    private AtomBase fParseResult;

    public AtomPubParser(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("No stream.");
        }
        this.fStream = stream;
    }

    public void parse() throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(this.fStream);
        do {
            int event;
            if ((event = parser.getEventType()) != 1) continue;
            QName name = parser.getName();
            if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                if ("feed".equals(name.getLocalPart())) {
                    this.fParseResult = this.parseFeed(parser);
                } else {
                    if (!"entry".equals(name.getLocalPart())) continue;
                    this.fParseResult = this.parseEntry(parser);
                }
            } else if ("http://docs.oasis-open.org/ns/cmis/core/200908/".equals(name.getNamespaceURI())) {
                if ("allowableActions".equals(name.getLocalPart())) {
                    this.fParseResult = this.parseAllowableActions(parser);
                } else {
                    if (!"acl".equals(name.getLocalPart())) continue;
                    this.fParseResult = this.parseACL(parser);
                }
            } else {
                if (!"http://www.w3.org/2007/app".equals(name.getNamespaceURI()) || !"service".equals(name.getLocalPart())) continue;
                this.fParseResult = this.parseServiceDoc(parser);
            }
            break;
        } while (this.next(parser));
        parser.close();
    }

    public AtomBase getResults() {
        return this.fParseResult;
    }

    private ServiceDoc parseServiceDoc(XMLStreamReader parser) throws Exception {
        ServiceDoc result = new ServiceDoc();
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI())) {
                    if ("workspace".equals(name.getLocalPart())) {
                        result.addWorkspace(this.parseWorkspace(parser));
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        return result;
    }

    private RepositoryWorkspace parseWorkspace(XMLStreamReader parser) throws Exception {
        RepositoryWorkspace workspace = new RepositoryWorkspace();
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                AtomElement element = this.parseWorkspaceElement(parser);
                if (element != null && element.getObject() instanceof CmisRepositoryInfoType) {
                    workspace.setId(((CmisRepositoryInfoType)element.getObject()).getRepositoryId());
                }
                workspace.addElement(element);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
        return workspace;
    }

    private AtomFeed parseFeed(XMLStreamReader parser) throws Exception {
        AtomFeed result = new AtomFeed();
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("link".equals(name.getLocalPart())) {
                        result.addElement(this.parseLink(parser));
                        continue;
                    }
                    if ("entry".equals(name.getLocalPart())) {
                        result.addEntry(this.parseEntry(parser));
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if ("numItems".equals(name.getLocalPart())) {
                        result.addElement(this.parseBigInteger(parser));
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
        return result;
    }

    private AtomEntry parseEntry(XMLStreamReader parser) throws Exception {
        AtomEntry result = new AtomEntry();
        this.next(parser);
        block0: while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                AtomElement element = this.parseElement(parser);
                if (element == null) continue;
                result.addElement(element);
                if (element.getObject() instanceof CmisObjectType) {
                    Iterator i$ = ((CmisObjectType)element.getObject()).getProperties().getProperty().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block0;
                        CmisProperty prop = (CmisProperty)i$.next();
                        if (!EnumPropertiesBase.CMIS_OBJECT_ID.value().equals(prop.getPropertyDefinitionId())) continue;
                        result.setId((String)((CmisPropertyId)prop).getValue().get(0));
                    }
                }
                if (!(element.getObject() instanceof CmisTypeDefinitionType)) continue;
                result.setId(((CmisTypeDefinitionType)element.getObject()).getId());
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
        return result;
    }

    private AtomAllowableActions parseAllowableActions(XMLStreamReader parser) throws Exception {
        AtomElement elemenet = this.unmarshalElement(parser, CmisAllowableActionsType.class);
        return new AtomAllowableActions((CmisAllowableActionsType)elemenet.getObject());
    }

    private AtomAcl parseACL(XMLStreamReader parser) throws Exception {
        AtomElement elemenet = this.unmarshalElement(parser, CmisAccessControlListType.class);
        return new AtomAcl((CmisAccessControlListType)elemenet.getObject());
    }

    private AtomElement parseElement(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("object".equals(name.getLocalPart())) {
                return this.unmarshalElement(parser, CmisObjectType.class);
            }
            if ("pathSegment".equals(name.getLocalPart()) || "relativePathSegment".equals(name.getLocalPart())) {
                return this.parseText(parser);
            }
            if ("type".equals(name.getLocalPart())) {
                String typeAttr = parser.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (typeAttr == null) {
                    return this.unmarshalElement(parser, CmisTypeDefinitionType.class);
                }
                if (typeAttr.endsWith(ATTR_DOCUMENT_TYPE)) {
                    return this.unmarshalElement(parser, CmisTypeDocumentDefinitionType.class);
                }
                if (typeAttr.endsWith(ATTR_FOLDER_TYPE)) {
                    return this.unmarshalElement(parser, CmisTypeFolderDefinitionType.class);
                }
                if (typeAttr.endsWith(ATTR_RELATIONSHIP_TYPE)) {
                    return this.unmarshalElement(parser, CmisTypeRelationshipDefinitionType.class);
                }
                if (typeAttr.endsWith(ATTR_POLICY_TYPE)) {
                    return this.unmarshalElement(parser, CmisTypePolicyDefinitionType.class);
                }
                throw new CmisRuntimeException("Cannot read type definition!");
            }
            if ("children".equals(name.getLocalPart())) {
                return this.parseChildren(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return this.parseLink(parser);
            }
            if ("content".equals(name.getLocalPart())) {
                return this.parseAtomContentSrc(parser);
            }
        }
        this.skip(parser);
        return null;
    }

    private <T> AtomElement unmarshalElement(XMLStreamReader parser, Class<T> cmisType) throws Exception {
        QName name = parser.getName();
        Unmarshaller u = JaxBHelper.createUnmarshaller();
        JAXBElement object = u.unmarshal(parser, cmisType);
        return new AtomElement(name, object.getValue());
    }

    private AtomElement parseChildren(XMLStreamReader parser) throws Exception {
        AtomElement result = null;
        QName childName = parser.getName();
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("feed".equals(name.getLocalPart())) {
                        result = new AtomElement(childName, this.parseFeed(parser));
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
        return result;
    }

    private AtomElement parseWorkspaceElement(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("repositoryInfo".equals(name.getLocalPart())) {
                return this.unmarshalElement(parser, CmisRepositoryInfoType.class);
            }
            if ("uritemplate".equals(name.getLocalPart())) {
                return this.parseTemplate(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return this.parseLink(parser);
            }
        } else if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI()) && "collection".equals(name.getLocalPart())) {
            return this.parseCollection(parser);
        }
        this.skip(parser);
        return null;
    }

    private AtomElement parseCollection(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("href", parser.getAttributeValue(null, "href"));
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName tagName = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI()) && "collectionType".equals(tagName.getLocalPart())) {
                    result.put("collectionType", this.readText(parser));
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
        return new AtomElement(name, result);
    }

    private AtomElement parseTemplate(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName tagName = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI())) {
                    if ("template".equals(tagName.getLocalPart())) {
                        result.put("template", this.readText(parser));
                        continue;
                    }
                    if ("type".equals(tagName.getLocalPart())) {
                        result.put("type", this.readText(parser));
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
        return new AtomElement(name, result);
    }

    private AtomElement parseLink(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        AtomLink result = new AtomLink();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if ("rel".equals(parser.getAttributeLocalName(i))) {
                result.setRel(parser.getAttributeValue(i));
                continue;
            }
            if ("href".equals(parser.getAttributeLocalName(i))) {
                result.setHref(parser.getAttributeValue(i));
                continue;
            }
            if (!"type".equals(parser.getAttributeLocalName(i))) continue;
            result.setType(parser.getAttributeValue(i));
        }
        this.skip(parser);
        return new AtomElement(name, result);
    }

    private AtomElement parseAtomContentSrc(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        AtomLink result = new AtomLink();
        result.setRel(LINK_REL_CONTENT);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!"src".equals(parser.getAttributeLocalName(i))) continue;
            result.setHref(parser.getAttributeValue(i));
        }
        this.skip(parser);
        return new AtomElement(name, result);
    }

    private AtomElement parseText(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        return new AtomElement(name, this.readText(parser));
    }

    private AtomElement parseBigInteger(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        return new AtomElement(name, new BigInteger(this.readText(parser)));
    }

    private String readText(XMLStreamReader parser) throws Exception {
        int event;
        StringBuilder sb = new StringBuilder();
        this.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    sb.append(s);
                }
            } else if (event == 1) {
                throw new RuntimeException("Unexpected tag: " + parser.getName());
            }
            if (this.next(parser)) continue;
            break;
        }
        this.next(parser);
        return sb.toString();
    }

    private void skip(XMLStreamReader parser) throws Exception {
        int level = 1;
        while (this.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        this.next(parser);
    }

    private boolean next(XMLStreamReader parser) throws Exception {
        if (parser.hasNext()) {
            parser.next();
            return true;
        }
        return false;
    }
}

