/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.Base64;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtils {
    private static final Log log = LogFactory.getLog(HttpUtils.class);
    private static final int BUFFER_SIZE = 0x200000;

    private HttpUtils() {
    }

    public static Response invokeGET(UrlBuilder url, Session session) {
        return HttpUtils.invoke(url, "GET", null, null, session, null, null);
    }

    public static Response invokeGET(UrlBuilder url, Session session, BigInteger offset, BigInteger length) {
        return HttpUtils.invoke(url, "GET", null, null, session, offset, length);
    }

    public static Response invokePOST(UrlBuilder url, String contentType, Output writer, Session session) {
        return HttpUtils.invoke(url, "POST", contentType, writer, session, null, null);
    }

    public static Response invokePUT(UrlBuilder url, String contentType, Output writer, Session session) {
        return HttpUtils.invoke(url, "PUT", contentType, writer, session, null, null);
    }

    public static Response invokeDELETE(UrlBuilder url, Session session) {
        return HttpUtils.invoke(url, "DELETE", null, null, session, null, null);
    }

    private static Response invoke(UrlBuilder url, String method, String contentType, Output writer, Session session, BigInteger offset, BigInteger length) {
        try {
            Map<String, List<String>> httpHeaders;
            AbstractAuthenticationProvider authProvider;
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + " " + url));
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(writer != null);
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            if ((authProvider = CmisBindingsHelper.getAuthenticationProvider(session)) != null && (httpHeaders = authProvider.getHTTPHeaders(url.toString())) != null) {
                for (Map.Entry<String, List<String>> header : httpHeaders.entrySet()) {
                    if (header.getValue() == null) continue;
                    for (String value : header.getValue()) {
                        conn.setRequestProperty(header.getKey(), value);
                    }
                }
            }
            if (offset != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (offset == null || offset.signum() == -1) {
                    offset = BigInteger.ZERO;
                }
                sb.append(offset.toString());
                sb.append("-");
                if (length != null && length.signum() == 1) {
                    sb.append(offset.add(length.subtract(BigInteger.ONE)).toString());
                }
                conn.setRequestProperty("Range", sb.toString());
            }
            if (writer != null) {
                conn.setChunkedStreamingMode(0x200000);
                BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream(), 0x200000);
                writer.write(out);
                ((OutputStream)out).flush();
            }
            conn.connect();
            int respCode = conn.getResponseCode();
            InputStream inputStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = conn.getInputStream();
            }
            return new Response(respCode, conn.getResponseMessage(), conn.getHeaderFields(), inputStream, conn.getErrorStream());
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot access " + url + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static interface Output {
        public void write(OutputStream var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response {
        private int responseCode;
        private String responseMessage;
        private Map<String, List<String>> headers;
        private InputStream stream;
        private String errorContent;
        private BigInteger length;

        public Response(int responseCode, String responseMessage, Map<String, List<String>> headers, InputStream stream, InputStream errorStream) {
            String encoding;
            String lengthStr;
            String contentType;
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.stream = stream;
            this.headers = new HashMap<String, List<String>>();
            if (headers != null) {
                for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                    this.headers.put(e.getKey() == null ? null : e.getKey().toLowerCase(), e.getValue());
                }
            }
            if (errorStream != null && (contentType = this.getContentTypeHeader()) != null && contentType.toLowerCase().startsWith("text/")) {
                StringBuilder sb = new StringBuilder();
                try {
                    int b;
                    InputStreamReader reader = new InputStreamReader(errorStream);
                    char[] buffer = new char[4096];
                    while ((b = reader.read(buffer)) > -1) {
                        sb.append(buffer, 0, b);
                    }
                    reader.close();
                    this.errorContent = sb.toString();
                }
                catch (IOException e) {
                    this.errorContent = "Unable to retrieve content: " + e.getMessage();
                }
            }
            if ((lengthStr = this.getHeader("Content-Length")) != null) {
                try {
                    this.length = new BigInteger(lengthStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (stream != null && (encoding = this.getContentTransferEncoding()) != null && encoding.toLowerCase().trim().equals("base64")) {
                this.length = null;
                this.stream = new Base64.InputStream(stream);
            }
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getHeader(String name) {
            List<String> list = this.headers.get(name.toLowerCase(Locale.US));
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }

        public String getContentTypeHeader() {
            return this.getHeader("Content-Type");
        }

        public BigInteger getContentLengthHeader() {
            String lengthStr = this.getHeader("Content-Length");
            if (lengthStr == null) {
                return null;
            }
            try {
                return new BigInteger(lengthStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String getLocactionHeader() {
            return this.getHeader("Location");
        }

        public String getContentLocactionHeader() {
            return this.getHeader("Content-Location");
        }

        public String getContentTransferEncoding() {
            return this.getHeader("Content-Transfer-Encoding");
        }

        public BigInteger getContentLength() {
            return this.length;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getErrorContent() {
            return this.errorContent;
        }
    }
}

