/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin;

import java.io.Serializable;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.ecm.webengine.session.SessionException;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="Engine")
@Produces(value={"text/html;charset=UTF-8"})
public class EngineService
extends DefaultObject {
    private static final Log log = LogFactory.getLog(EngineService.class);

    @GET
    public Object getIndex() {
        return this.getView("index");
    }

    @GET
    @javax.ws.rs.Path(value="reload")
    public Response doReload() {
        this.ctx.getEngine().reload();
        return this.redirect(this.path);
    }

    @GET
    @javax.ws.rs.Path(value="test")
    public String doTest() {
        try {
            System.out.println("open session1");
            CoreSession session1 = EngineService.openSession("default");
            System.out.println("open session2");
            CoreSession session2 = EngineService.openSession("default");
            Path path = new Path("/default-domain/workspaces");
            System.out.println("modify doc in session1 without saving");
            DocumentModel w1 = session1.getDocument((DocumentRef)new PathRef(path.toString()));
            w1.setPropertyValue("dc:title", (Serializable)((Object)"test1"));
            System.out.println("saving doc in session 1");
            session1.saveDocument(w1);
            System.out.println("modify doc in session2 and then save session");
            DocumentModel w2 = session2.getDocument((DocumentRef)new PathRef(path.toString()));
            w2.setPropertyValue("dc:title", (Serializable)((Object)"test2"));
            session2.saveDocument(w2);
            session2.save();
            System.out.println("session2 SAVE OK ");
            System.out.println("trying to save session 1 ...");
            session1.save();
            System.out.println("session 1 saved => Test OK");
            return "Test OK";
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            throw WebException.wrap((Throwable)t);
        }
    }

    @GET
    @javax.ws.rs.Path(value="test2")
    public String doTest2() {
        try {
            System.out.println("open session1");
            CoreSession session1 = EngineService.openSession("default");
            System.out.println("open session2");
            CoreSession session2 = EngineService.openSession("default");
            Path path = new Path("/default-domain/workspaces");
            System.out.println("modify doc in session1 without saving");
            DocumentModelImpl doc = new DocumentModelImpl(path.toString(), "doc1", "Folder");
            doc = session1.createDocument((DocumentModel)doc);
            System.out.println("creating doc in session 1 " + doc.getName());
            System.out.println("creating doc in session2 and then save session");
            doc = new DocumentModelImpl(path.toString(), "doc2", "Folder");
            doc = session2.createDocument((DocumentModel)doc);
            session2.save();
            System.out.println("session2 SAVE OK ");
            System.out.println("trying to save session 1 ...");
            session1.save();
            System.out.println("session 1 saved => Test OK");
            return "Test OK";
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            throw WebException.wrap((Throwable)t);
        }
    }

    public static CoreSession openSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = null;
        repo = repoName == null ? rm.getDefaultRepository() : rm.getRepository(repoName);
        if (repo == null) {
            throw new SessionException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }
}

