/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.api.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;

public class JSONMetadataExporter
implements PropertyVisitor {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
    private JSONObject result;

    public JSONObject getResult() {
        return this.result;
    }

    public JSONObject run(DocumentModel doc) throws ClientException {
        this.result = new JSONObject();
        for (DocumentPart dp : doc.getParts()) {
            dp.accept((PropertyVisitor)this, (Object)this.result);
        }
        return this.result;
    }

    public boolean acceptPhantoms() {
        return false;
    }

    public Object visit(DocumentPart property, Object arg) throws PropertyException {
        return arg;
    }

    public Object visit(MapProperty property, Object arg) throws PropertyException {
        Serializable value = null;
        value = property.isContainer() ? new JSONObject() : property.getValue();
        if (property.getParent().isList()) {
            ((JSONArray)arg).put((Object)value);
        } else {
            try {
                ((JSONObject)arg).put(property.getField().getName().getPrefixedName(), (Object)value);
            }
            catch (JSONException e) {
                throw new PropertyException("Failed to put value", (Throwable)e);
            }
        }
        return value;
    }

    public Object visit(ListProperty property, Object arg) throws PropertyException {
        Serializable value = null;
        value = property.isContainer() ? new JSONArray() : property.getValue();
        if (property.getParent().isList()) {
            ((JSONArray)arg).put((Object)value);
        } else {
            try {
                ((JSONObject)arg).put(property.getField().getName().getPrefixedName(), (Object)value);
            }
            catch (JSONException e) {
                throw new PropertyException("Failed to put value", (Throwable)e);
            }
        }
        return value;
    }

    public Object visit(ScalarProperty property, Object arg) throws PropertyException {
        Object value = property.getValue();
        if (value instanceof Calendar) {
            value = this.dateFormat.format(((Calendar)value).getTime());
        }
        if (property.getParent().isList()) {
            ((JSONArray)arg).put(value);
        } else {
            try {
                ((JSONObject)arg).put(property.getField().getName().getPrefixedName(), value);
            }
            catch (JSONException e) {
                throw new PropertyException("Failed to put value", (Throwable)e);
            }
        }
        return null;
    }
}

