/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.dashboard;

import java.util.Date;
import java.util.List;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItem;

public class DashBoardItemImpl
implements DashBoardItem {
    private static final long serialVersionUID = 919752175741886376L;
    protected final Long id;
    protected final String name;
    protected final String description;
    protected final Date startDate;
    protected final Date dueDate;
    protected final boolean expired;
    protected final String directive;
    protected final DocumentModel document;
    protected final TaskInstance task;
    protected String comment;

    public DashBoardItemImpl(TaskInstance task, DocumentModel document) {
        this.task = task;
        this.document = document;
        this.id = task.getId();
        this.name = task.getName();
        this.description = task.getDescription();
        this.dueDate = task.getDueDate();
        this.startDate = task.getCreate();
        this.directive = (String)task.getVariableLocally(JbpmService.TaskVariableName.directive.name());
        List comments = task.getComments();
        this.comment = comments != null && !comments.isEmpty() ? ((Comment)comments.get(comments.size() - 1)).getMessage() : null;
        if (this.dueDate != null) {
            Date today = new Date();
            this.expired = this.dueDate.before(today);
        } else {
            this.expired = false;
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DocumentRef getDocRef() {
        return this.document.getRef();
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDirective() {
        return this.directive;
    }

    @Override
    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public TaskInstance getTaskInstance() {
        return this.task;
    }
}

