/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.ImageModel;
import it.tidalwave.image.jai.ImplementationFactoryJAI;
import it.tidalwave.image.op.ImplementationFactory;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageModelJAI
extends ImageModel {
    static final long serialVersionUID = 7039150248239203504L;
    private static Logger logger = Logger.getLogger(ImageModelJAI.class.getName());
    private transient PlanarImage planarImage;

    public ImageModelJAI() {
    }

    public ImageModelJAI(Object planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException("planarImage is null");
        }
        if (planarImage instanceof RenderedImage) {
            planarImage = PlanarImage.wrapRenderedImage((RenderedImage)((RenderedImage)planarImage));
        }
        if (!(planarImage instanceof PlanarImage)) {
            throw new IllegalArgumentException("planarImage is not an instance of PlanarImage or RenderedImage");
        }
        this.planarImage = (PlanarImage)planarImage;
    }

    public ImplementationFactory getFactory() {
        return ImplementationFactoryJAI.getInstance();
    }

    public static EditableImage createImage(RenderedImage renderedImage) {
        return new EditableImage((ImageModel)new ImageModelJAI(renderedImage));
    }

    public Object getImage() {
        return this.planarImage;
    }

    public void setImage(Object model) {
        super.setImage(model);
        this.planarImage = (PlanarImage)model;
    }

    public int getWidth() {
        return this.planarImage.getWidth();
    }

    public int getHeight() {
        return this.planarImage.getHeight();
    }

    public int getBandCount() {
        return this.planarImage.getSampleModel().getNumBands();
    }

    public EditableImage.DataType getDataType() {
        return EditableImage.DataType.valueOf((int)this.planarImage.getSampleModel().getDataType());
    }

    public void dispose() {
        this.planarImage.dispose();
        this.planarImage = null;
    }

    public ColorModel getColorModel() {
        return this.planarImage.getColorModel();
    }

    public EditableImage createCopy(boolean copyContents) {
        TiledImage image2 = new TiledImage((RenderedImage)this.planarImage, false);
        if (copyContents) {
            image2.setData(this.planarImage.getData());
        }
        return ImageModelJAI.createImage((RenderedImage)image2);
    }

    public <T> T getInnerProperty(Class<T> propertyClass) {
        if (propertyClass.equals(PlanarImage.class)) {
            return (T)this.planarImage;
        }
        if (propertyClass.equals(SampleModel.class)) {
            return (T)this.planarImage.getSampleModel();
        }
        if (propertyClass.equals(ColorModel.class)) {
            return (T)this.planarImage.getColorModel();
        }
        throw new IllegalArgumentException(propertyClass.getName());
    }

    public void writeExternal(DataOutputStream out) throws IOException {
        if (this.planarImage != null) {
            ImageIO.write((RenderedImage)this.planarImage.getAsBufferedImage(), "TIFF", out);
        }
    }

    public void readExternal(DataInputStream in) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(in);
        if (bufferedImage == null) {
            throw new IOException("Null bufferedImage read from the stream");
        }
        this.planarImage = PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage);
    }

    public String toString() {
        return "ImageModelJAI[image: " + this.planarImage + "]";
    }
}

