/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.TranslateOp;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Logger;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateJAIOp
extends OperationImplementation<TranslateOp, PlanarImage> {
    private static final String CLASS = TranslateJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(TranslateOp operation, PlanarImage planarImage) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(planarImage);
        pb.add(operation.getDeltaX());
        pb.add(operation.getDeltaY());
        if (operation.getInterpolationType() == TranslateOp.InterpolationType.BICUBIC) {
            pb.add(new InterpolationBicubic(8));
        }
        planarImage = JAI.create((String)"translate", (ParameterBlock)pb);
        JAIUtils.logImage((Logger)logger, (String)">>>> TranslateJAIOp() returning", (RenderedImage)planarImage);
        return planarImage;
    }
}

