/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoBinding;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObjectFactory;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;

public class NuxeoSession
implements Session {
    public static final OperationContext DEFAULT_CONTEXT = new OperationContextImpl(null, false, true, false, IncludeRelationships.NONE, null, true, null, true, 10);
    private final CoreSession coreSession;
    private final String repositoryId;
    private final NuxeoObjectFactory objectFactory;
    private final NuxeoCmisService service;
    private final NuxeoBinding binding;
    private OperationContext defaultContext = DEFAULT_CONTEXT;

    public NuxeoSession(CoreSession coreSession, NuxeoRepository repository, CallContext context) {
        this.coreSession = coreSession;
        this.repositoryId = repository.getId();
        this.objectFactory = new NuxeoObjectFactory(this);
        this.service = new NuxeoCmisService(repository, context, coreSession);
        this.binding = new NuxeoBinding(this.service);
    }

    public NuxeoObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public NuxeoBinding getBinding() {
        return this.binding;
    }

    public NuxeoCmisService getService() {
        return this.service;
    }

    protected CoreSession getCoreSession() {
        return this.coreSession;
    }

    public void clear() {
    }

    public void cancel() {
        throw new UnsupportedOperationException();
    }

    public void save() {
        try {
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void setDefaultContext(OperationContext defaultContext) {
        this.defaultContext = defaultContext;
    }

    public OperationContext getDefaultContext() {
        return this.defaultContext;
    }

    protected String getRepositoryId() {
        return this.coreSession.getRepositoryName();
    }

    public ObjectId createObjectId(String id) {
        return new ObjectIdImpl(id);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, folderId, contentStream, versioningState, null, null, null);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId) {
        return this.createFolder(properties, folderId, null, null, null);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public OperationContext createOperationContext() {
        throw new UnsupportedOperationException();
    }

    public OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId) {
        return this.createPolicy(properties, folderId, null, null, null);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createRelationship(Map<String, ?> properties) {
        return this.createRelationship(properties, null, null, null);
    }

    public ObjectId createRelationship(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, folderId, versioningState, null, null, null);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems) {
        return this.getContentChanges(changeLogToken, includeProperties, maxNumItems, this.getDefaultContext());
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public CmisObject getObject(ObjectId objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(DocumentModel doc, OperationContext context) {
        NuxeoObjectData data = new NuxeoObjectData(this.service, doc, context);
        return this.objectFactory.convertObject(data, context);
    }

    public CmisObject getObject(ObjectId objectId, OperationContext context) {
        if (objectId == null || objectId.getId() == null) {
            throw new CmisInvalidArgumentException("Missing object or ID");
        }
        if (context == null) {
            throw new CmisInvalidArgumentException("Missing operation context");
        }
        NuxeoObjectData data = this.service.getObject(this.getRepositoryId(), objectId.getId(), context.getFilterString(), context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), context.isIncludePolicies(), context.isIncludeAcls(), null);
        return this.objectFactory.convertObject(data, context);
    }

    public CmisObject getObjectByPath(String path) {
        return this.getObjectByPath(path, this.getDefaultContext());
    }

    public CmisObject getObjectByPath(String path, OperationContext context) {
        if (path == null || !path.startsWith("/")) {
            throw new CmisInvalidArgumentException("Invalid path: " + path);
        }
        if (context == null) {
            throw new CmisInvalidArgumentException("Missing operation context");
        }
        ObjectData data = this.service.getObjectByPath(this.getRepositoryId(), path, context.getFilterString(), context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), context.isIncludePolicies(), context.isIncludeAcls(), null);
        return this.getObjectFactory().convertObject(data, context);
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.service.getRepositoryInfo(this.repositoryId, null);
    }

    public Folder getRootFolder() {
        return this.getRootFolder(this.getDefaultContext());
    }

    public Folder getRootFolder(OperationContext context) {
        String id = this.getRepositoryInfo().getRootFolderId();
        CmisObject folder = this.getObject(this.createObjectId(id), context);
        if (!(folder instanceof Folder)) {
            throw new CmisRuntimeException("Root object is not a Folder but: " + folder.getClass().getName());
        }
        return (Folder)folder;
    }

    public ItemIterable<ObjectType> getTypeChildren(String typeId, boolean includePropertyDefinitions) {
        throw new UnsupportedOperationException();
    }

    public ObjectType getTypeDefinition(String typeId) {
        TypeDefinition typeDefinition = this.service.getTypeDefinition(this.getRepositoryId(), typeId, null);
        return this.objectFactory.convertTypeDefinition(typeDefinition);
    }

    public List<Tree<ObjectType>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<QueryResult> query(String statement, boolean searchAllVersions) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<QueryResult> query(String statement, boolean searchAllVersions, OperationContext context) {
        throw new UnsupportedOperationException();
    }
}

