/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.SynchronousBundleListener;

public class WebEngineActivator
implements BundleActivator,
FrameworkListener {
    private static final Log log = LogFactory.getLog(WebEngineActivator.class);
    protected final Set<String> deployedBundles = new HashSet<String>();
    protected BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.addFrameworkListener((FrameworkListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeFrameworkListener((FrameworkListener)this);
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployModules() throws Exception {
        final WebEngine engine = (WebEngine)Framework.getLocalService(WebEngine.class);
        this.context.addBundleListener((BundleListener)new SynchronousBundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent event) {
                try {
                    switch (event.getType()) {
                        case 2: {
                            Set<String> set = WebEngineActivator.this.deployedBundles;
                            synchronized (set) {
                                WebEngineActivator.this.deployModules(engine, event.getBundle());
                                break;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Failed to deploy web modules in bundle: " + event.getBundle().getSymbolicName()), e);
                }
            }
        });
        Set<String> set = this.deployedBundles;
        synchronized (set) {
            for (Bundle b : this.context.getBundles()) {
                if (b.getState() != 32) continue;
                try {
                    this.deployModules(engine, b);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to deploy web modules in bundle: " + b.getSymbolicName()), t);
                }
            }
        }
    }

    protected void deployModules(WebEngine engine, Bundle b) throws Exception {
        String id = b.getSymbolicName();
        if (this.deployedBundles.contains(id)) {
            return;
        }
        if (engine.getApplicationManager().deployApplication(b)) {
            this.deployedBundles.add(id);
            return;
        }
        URL url = b.getEntry("module.xml");
        if (url == null) {
            return;
        }
        File bf = Framework.getRuntime().getBundleFile(b);
        if (bf == null) {
            log.warn((Object)("Bundle type not supported - cannot be resolved to a file. Bundle: " + b.getSymbolicName()));
            return;
        }
        this.deployedBundles.add(id);
        this.deployModule(engine, id, bf, url);
    }

    protected void deployModule(WebEngine engine, String bundleId, File bundleFile, URL moduleConfig) throws IOException {
        if (this.checkHasNuxeoService(bundleId)) {
            throw new WebException("This webengine module should not define a Nuxeo Service, please split up.");
        }
        if (bundleFile.isDirectory()) {
            File cfg = new File(bundleFile, "module.xml");
            engine.registerModule(cfg);
        } else {
            File moduleRoot = new File(engine.getRootDirectory(), "modules/" + bundleId);
            File cfg = new File(moduleRoot, "module.xml");
            if (moduleRoot.exists()) {
                if (bundleFile.lastModified() < moduleRoot.lastModified()) {
                    engine.registerModule(cfg);
                    return;
                }
                moduleRoot.delete();
            }
            moduleRoot.mkdirs();
            ZipUtils.unzip((File)bundleFile, (File)moduleRoot);
            engine.registerModule(cfg);
        }
        log.info((Object)("Deployed web module found in bundle: " + bundleId));
    }

    protected boolean checkHasNuxeoService(String bundleId) {
        ComponentManager cpManager = Framework.getRuntime().getComponentManager();
        RegistrationInfo regInfo = cpManager.getRegistrationInfo(new ComponentName(bundleId));
        if (null == regInfo) {
            return false;
        }
        String[] serviceNames = regInfo.getProvidedServiceNames();
        return serviceNames != null && serviceNames.length != 0;
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (1 == event.getType()) {
            try {
                this.deployModules();
            }
            catch (Exception e) {
                log.error((Object)"Failed to deploy WebEngine modules", (Throwable)e);
            }
        }
    }
}

