/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.session;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.webengine.session.UserSession;

public class StatelessUserSession
extends UserSession {
    private static final long serialVersionUID = 1L;

    public StatelessUserSession(Principal principal) {
        super(principal);
    }

    public StatelessUserSession(Principal principal, String password) {
        super(principal, password);
    }

    public StatelessUserSession(Principal principal, Object credentials) {
        super(principal, credentials);
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public void terminateRequest(HttpServletRequest request) {
        super.terminateRequest(request);
        try {
            this.uninstall();
        }
        catch (Throwable t) {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "/";
            }
            String url = request.getRequestURL().toString();
            log.error((Object)("Uninstall failed for Stateless UserSession. PathInfo: " + pathInfo + "; URL: " + url), t);
            throw new RuntimeException(t);
        }
    }
}

