/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.session;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.webengine.session.Component;
import org.nuxeo.ecm.webengine.session.ComponentMap;
import org.nuxeo.ecm.webengine.session.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.session.SessionException;
import org.nuxeo.ecm.webengine.session.SessionProvider;
import org.nuxeo.ecm.webengine.session.StatefulUserSession;
import org.nuxeo.ecm.webengine.session.StatelessUserSession;
import org.nuxeo.runtime.api.Framework;

public abstract class UserSession
extends HashMap<String, Object> {
    public static final String CLEANUP_HANDLERS = "webengine.request.cleanup.handlers";
    private static final long serialVersionUID = 260562970988817064L;
    protected static final String WE_SESSION_KEY = "nuxeo.webengine.user_session";
    protected static final Log log = LogFactory.getLog(UserSession.class);
    protected Map<Class<?>, ComponentMap<?>> comps = new HashMap();
    protected final Subject subject;
    protected final Principal principal;
    @Deprecated
    protected final Object credentials;
    protected String defaultRepository;
    protected SessionProvider sessionProvider = new SessionProvider();

    public static UserSession tryGetCurrentSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        UserSession us = null;
        us = (UserSession)request.getAttribute(WE_SESSION_KEY);
        if (us == null && session != null) {
            us = (UserSession)session.getAttribute(WE_SESSION_KEY);
        }
        return us;
    }

    public static UserSession getCurrentSession(HttpServletRequest request) {
        UserSession us = UserSession.tryGetCurrentSession(request);
        if (us == null) {
            log.warn((Object)"Unable to find UserSession");
        }
        return us;
    }

    public static UserSession register(HttpServletRequest request, boolean stateful) {
        UserSession us;
        if (stateful) {
            log.debug((Object)"Creating Stateful UserSession");
            HttpSession session = request.getSession(true);
            us = (UserSession)session.getAttribute(WE_SESSION_KEY);
            if (us == null) {
                us = new StatefulUserSession(request.getUserPrincipal());
                session.setAttribute(WE_SESSION_KEY, (Object)us);
            }
        } else {
            log.debug((Object)"Creating Stateless UserSession");
            us = new StatelessUserSession(request.getUserPrincipal());
            request.setAttribute(WE_SESSION_KEY, (Object)us);
        }
        us.defaultRepository = request.getHeader("X-NXRepository");
        if (us.defaultRepository == null) {
            us.defaultRepository = request.getParameter("nxrepository");
        }
        return us;
    }

    protected UserSession(Principal principal) {
        this(principal, null);
    }

    protected UserSession(Principal principal, String password) {
        this(principal, password == null ? new char[]{} : password.toCharArray());
    }

    protected UserSession(Principal principal, Object credentials) {
        this.principal = principal;
        this.credentials = credentials;
        HashSet<Principal> principals = new HashSet<Principal>();
        HashSet<Object> publicCredentials = new HashSet<Object>();
        HashSet privateCredentials = new HashSet();
        principals.add(principal);
        publicCredentials.add(credentials);
        this.subject = new Subject(true, principals, publicCredentials, privateCredentials);
    }

    public abstract boolean isStateful();

    public String getDefaultRepository() {
        return this.defaultRepository;
    }

    public CoreSession getCoreSession(String repoName) {
        try {
            return this.sessionProvider.getSession(repoName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to open core session for repository: " + repoName), (Throwable)e);
            return null;
        }
    }

    public CoreSession getCoreSession() {
        return this.getCoreSession(this.defaultRepository);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public static CoreSession openSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = null;
        repo = repoName == null ? rm.getDefaultRepository() : rm.getRepository(repoName);
        if (repo == null) {
            throw new SessionException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }

    protected void install() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Installing user session");
        }
    }

    protected synchronized void uninstall() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Uninstalling user session");
        }
        for (Map.Entry<Class<?>, ComponentMap<?>> entry : this.comps.entrySet()) {
            try {
                entry.getValue().destroy(this);
            }
            catch (SessionException e) {
                log.error((Object)("Failed to destroy component: " + entry.getKey()), (Throwable)e);
            }
        }
        this.comps = new HashMap();
        SessionProvider oldSessionProvider = this.sessionProvider;
        this.sessionProvider = null;
        try {
            oldSessionProvider.destroy(this.principal);
        }
        catch (Exception e) {
            log.error((Object)"Failed to destroy regisered core sessions", (Throwable)e);
        }
        oldSessionProvider = null;
    }

    public synchronized <T extends Component> T findComponent(Class<T> type, String name) {
        ComponentMap<?> map = this.comps.get(type);
        if (map == null) {
            return null;
        }
        if (name == null) {
            return (T)map.getComponent();
        }
        return (T)((Component)type.cast(map.get(name)));
    }

    public synchronized <T extends Component> T getComponent(Class<T> type, String name) throws SessionException {
        Object comp;
        ComponentMap<Object> map = this.comps.get(type);
        if (map == null) {
            map = new ComponentMap();
            this.comps.put(type, map);
        } else {
            comp = name == null ? map.getComponent() : (Component)type.cast(map.get(name));
            if (comp != null) {
                return (T)comp;
            }
        }
        try {
            comp = (Component)type.newInstance();
        }
        catch (Exception e) {
            throw new SessionException("Failed to instantiate component: " + type, e);
        }
        comp.initialize(this, name);
        if (name == null) {
            map.setComponent(comp);
        } else {
            map.put(name, comp);
        }
        return (T)((Component)type.cast(comp));
    }

    public <T extends Component> T getComponent(Class<T> type) throws SessionException {
        return this.getComponent(type, null);
    }

    public <T extends Component> T getComponent(String typeName, String name) throws SessionException {
        try {
            Class<?> type = Class.forName(typeName);
            return (T)this.getComponent(type, name);
        }
        catch (ClassNotFoundException e) {
            throw new SessionException("Could not find component class: " + typeName, e);
        }
    }

    public <T extends Component> T getComponent(String id) throws SessionException {
        int p = id.lastIndexOf(35);
        if (p > -1) {
            return this.getComponent(id.substring(0, p), id.substring(p + 1));
        }
        return this.getComponent(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateRequest(HttpServletRequest request) {
        try {
            List handlers = (List)request.getAttribute(CLEANUP_HANDLERS);
            if (handlers != null) {
                for (RequestCleanupHandler handler : handlers) {
                    handler.cleanup(request);
                }
                request.setAttribute(CLEANUP_HANDLERS, null);
            }
        }
        finally {
            request.removeAttribute(WE_SESSION_KEY);
            request.removeAttribute(CLEANUP_HANDLERS);
        }
    }

    public static void addRequestCleanupHandler(HttpServletRequest request, RequestCleanupHandler handler) {
        ArrayList<RequestCleanupHandler> handlers = (ArrayList<RequestCleanupHandler>)request.getAttribute(CLEANUP_HANDLERS);
        if (handlers == null) {
            handlers = new ArrayList<RequestCleanupHandler>();
            request.setAttribute(CLEANUP_HANDLERS, handlers);
        }
        handlers.add(handler);
    }
}

