/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.guards;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.nuxeo.ecm.core.management.guards.Guarded;
import org.nuxeo.ecm.core.management.guards.GuardedServiceProvider;

public class GuardedServiceHandler<T>
implements InvocationHandler {
    protected T object;

    public static <T> T newProxy(T object, Class<T> itf) {
        GuardedServiceHandler<T> h = new GuardedServiceHandler<T>(object);
        return itf.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{itf}, h));
    }

    protected GuardedServiceHandler(T object) {
        this.object = object;
    }

    protected Guarded getAdministred(Method m) {
        if (m.isAnnotationPresent(Guarded.class)) {
            return m.getAnnotation(Guarded.class);
        }
        Class<?> declaringClass = m.getDeclaringClass();
        if (declaringClass.isAnnotationPresent(Guarded.class)) {
            return declaringClass.getAnnotation(Guarded.class);
        }
        return null;
    }

    protected void checkIsAdministred(Method m) {
        Guarded administred = this.getAdministred(m);
        if (administred == null) {
            return;
        }
        GuardedServiceProvider.INSTANCE.checkIsActive(m, administred.id());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkIsAdministred(method);
        try {
            return method.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

