/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.protocol.nxtheme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementRenderer;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeManager;

public final class Connection
extends URLConnection {
    private static final Log log = LogFactory.getLog(Connection.class);
    private final URL url;
    private final String host;

    protected Connection(URL url) {
        super(url);
        this.url = url;
        this.host = url.getHost();
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public long getLastModified() {
        if (this.host.equals("theme")) {
            return Manager.getThemeManager().getLastModified(this.url);
        }
        if (this.host.equals("element")) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Element rendered = null;
        boolean cache = true;
        ThemeManager themeManager = Manager.getThemeManager();
        if (this.host.equals("element")) {
            rendered = ThemeManager.getElementByUrl(this.url);
            cache = false;
        } else if (this.host.equals("theme")) {
            String themeName = ThemeManager.getThemeNameByUrl(this.url);
            ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName(themeName);
            if (themeDescriptor != null && !themeDescriptor.isLoaded()) {
                ThemeManager.loadTheme(themeDescriptor);
            }
            rendered = themeManager.getThemeByUrl(this.url);
        }
        if (rendered == null) {
            throw new IOException(String.format("Error while rendering %s", ThemeManager.getUrlDescription(this.url)));
        }
        RenderingInfo info = new RenderingInfo(rendered, this.url);
        String content = ElementRenderer.render(info, cache).getMarkup();
        if (this.host.equals("theme") && log.isTraceEnabled()) {
            log.trace((Object)String.format("NXThemes output for %s: \n%s\n", this.url.toString(), content));
        }
        return new ByteArrayInputStream(content.getBytes());
    }
}

