/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.relations;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.theme.relations.Predicate;
import org.nuxeo.theme.relations.Relate;
import org.nuxeo.theme.relations.Relation;
import org.nuxeo.theme.relations.RelationTypeFamily;

public abstract class AbstractRelation
implements Relation {
    public List<Relate> relates;
    private Predicate predicate;

    protected AbstractRelation(Predicate predicate) {
        this.predicate = predicate;
        this.relates = new ArrayList<Relate>();
    }

    @Override
    public abstract RelationTypeFamily getRelationTypeFamily();

    @Override
    public Relate getRelate(Integer position) {
        if (position > this.relates.size()) {
            // empty if block
        }
        return this.relates.get(position - 1);
    }

    @Override
    public String hash() {
        ArrayList<String> r = new ArrayList<String>();
        for (Relate relate : this.relates) {
            r.add(relate.hash());
        }
        return String.format(this.predicate.hash().replace("_", "%s"), r.toArray());
    }

    public String toString() {
        return "Relation {'" + this.hash() + "'}";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public final void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean hasPredicate(Predicate predicate) {
        return this.predicate.hash().equals(predicate.hash());
    }

    @Override
    public List<Relate> getRelates() {
        return this.relates;
    }

    public void setRelates(List<Relate> relates) {
        this.relates = relates;
    }
}

