/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.resources;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.resources.ImageInfo;
import org.nuxeo.theme.resources.PresetInfo;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.resources.SkinInfo;
import org.nuxeo.theme.resources.StyleInfo;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.UidManager;

@XObject(value="bank")
public class ResourceBank
implements Type {
    private static final Log log = LogFactory.getLog(ResourceBank.class);
    @XNode(value="@name")
    public String name;
    private String connectionUrl;

    @XNode(value="@url")
    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = Framework.expandVars((String)connectionUrl);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.RESOURCE_BANK;
    }

    public boolean checkStatus() {
        byte[] status;
        String src = String.format("%s/status", this.connectionUrl);
        try {
            status = Utils.fetchUrl(new URL(src));
        }
        catch (Exception e) {
            return false;
        }
        return status != null && "OK".equals(new String(status));
    }

    public byte[] getResourceContent(String collectionName, String typeName, String resourceId) {
        String src = String.format("%s/%s/%s/%s", this.connectionUrl, URIUtils.quoteURIPathComponent((String)collectionName, (boolean)true), URIUtils.quoteURIPathComponent((String)typeName, (boolean)true), URIUtils.quoteURIPathComponent((String)resourceId, (boolean)true));
        log.debug((Object)("Loading THEME " + typeName + " from: " + src));
        try {
            return Utils.fetchUrl(new URL(src));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve RESOURCE: " + src + " from THEME BANK: " + this.name));
            return null;
        }
    }

    public List<ImageInfo> getImages() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        String src = String.format("%s/json/images", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve image list: " + src + " from THEME BANK: " + this.name));
            return images;
        }
        for (Object object : JSONArray.fromObject((Object)list)) {
            JSONObject image = JSONObject.fromObject(object);
            images.add(new ImageInfo((String)image.get("name"), (String)image.get("collection")));
        }
        return images;
    }

    public List<String> getCollections() {
        ArrayList<String> paths = new ArrayList<String>();
        String src = String.format("%s/json/collections", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve collection list: " + src + " from THEME BANK: " + this.name));
            return paths;
        }
        for (Object path : JSONArray.fromObject((Object)list)) {
            paths.add((String)path);
        }
        return paths;
    }

    public List<SkinInfo> getSkins() {
        ArrayList<SkinInfo> skins = new ArrayList<SkinInfo>();
        String src = String.format("%s/json/skins", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve skin list: " + src + " from THEME BANK: " + this.name));
            return skins;
        }
        for (Object object : JSONArray.fromObject((Object)list)) {
            JSONObject skin = JSONObject.fromObject(object);
            skins.add(new SkinInfo((String)skin.get("name"), (String)skin.get("bank"), (String)skin.get("collection"), (String)skin.get("resource"), (String)skin.get("preview"), (Boolean)skin.get("base")));
        }
        return skins;
    }

    public List<StyleInfo> getStyles() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        String src = String.format("%s/json/styles", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve the style list: " + src + " from THEME BANK: " + this.name));
            return styles;
        }
        for (Object object : JSONArray.fromObject((Object)list)) {
            JSONObject style = JSONObject.fromObject(object);
            styles.add(new StyleInfo((String)style.get("name"), (String)style.get("bank"), (String)style.get("collection"), (String)style.get("resource"), (String)style.get("preview")));
        }
        return styles;
    }

    public List<PresetInfo> getPresets() {
        ArrayList<PresetInfo> presets = new ArrayList<PresetInfo>();
        String src = String.format("%s/json/presets", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve the preset list: " + src + " from THEME BANK: " + this.name));
            return presets;
        }
        for (Object object : JSONArray.fromObject((Object)list)) {
            JSONObject preset = JSONObject.fromObject(object);
            presets.add(new PresetInfo((String)preset.get("name"), (String)preset.get("bank"), (String)preset.get("collection"), (String)preset.get("category"), (String)preset.get("value")));
        }
        return presets;
    }

    public String getName() {
        return this.name;
    }

    public void connect(String themeName) throws ThemeException {
        this.loadRemotePresets();
        this.loadRemoteStyles(themeName);
    }

    public void disconnect(String themeName) throws ThemeException {
        this.unloadRemotePresets();
        this.unloadRemoteStyles(themeName);
    }

    private void loadRemotePresets() throws ThemeException {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (PresetInfo presetInfo : this.getPresets()) {
            String name;
            String label = name = presetInfo.getName();
            String category = presetInfo.getCategory();
            String group = String.format("%s %s", presetInfo.getCollection(), presetInfo.getCategory());
            String value = presetInfo.getValue();
            String typeName = String.format("%s (%s)", name, group);
            PresetType preset = PresetManager.getPresetByName(typeName);
            if (preset == null) {
                preset = new PresetType();
                preset.setName(name);
                preset.setGroup(group);
                typeRegistry.register(preset);
            }
            preset.setLabel(label);
            preset.setCategory(category);
            preset.setValue(value);
        }
    }

    private void loadRemoteStyles(String themeName) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        List<StyleInfo> bankStyles = this.getStyles();
        for (StyleInfo styleInfo : bankStyles) {
            String styleName = styleInfo.getName();
            Style style = (Style)themeManager.getNamedObject(themeName, "style", styleName);
            if (style == null) {
                style = themeManager.createStyle();
                style.setName(styleName);
                style.setRemote(true);
                themeManager.setNamedObject(themeName, "style", style);
            }
            String collectionName = styleInfo.getCollection();
            String resourceId = styleInfo.getResource();
            String cssSource = ResourceManager.getBankResource(this.name, collectionName, "style", resourceId);
            Utils.loadCss(style, cssSource, "*");
        }
    }

    private void unloadRemotePresets() throws ThemeException {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (PresetInfo presetInfo : this.getPresets()) {
            String name = presetInfo.getName();
            String group = String.format("%s %s", presetInfo.getCollection(), presetInfo.getCategory());
            String typeName = String.format("%s (%s)", name, group);
            PresetType preset = PresetManager.getPresetByName(typeName);
            if (preset == null) continue;
            typeRegistry.unregister(preset);
        }
    }

    private void unloadRemoteStyles(String themeName) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        UidManager uidManager = Manager.getUidManager();
        List<StyleInfo> bankStyles = this.getStyles();
        for (StyleInfo styleInfo : bankStyles) {
            String styleName = styleInfo.getName();
            Style style = (Style)themeManager.getNamedObject(themeName, "style", styleName);
            if (style == null || style.isCustomized()) continue;
            themeManager.removeNamedObject(themeName, "style", styleName);
            themeManager.deleteFormat(style);
            uidManager.unregister(style);
        }
    }
}

