/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.views;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.models.ModelType;
import org.nuxeo.theme.templates.TemplateEngineType;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.views.View;

@XObject(value="view")
public final class ViewType
implements Type {
    private static final Log log = LogFactory.getLog(ViewType.class);
    @XNode(value="@name")
    public String viewName = "*";
    @XNode(value="engine")
    public String engineName = "default";
    @XNode(value="@template-engine")
    private String templateEngine;
    @XNode(value="mode")
    public String mode = "*";
    @XNode(value="icon")
    public String icon;
    @XNode(value="element-type")
    public String elementTypeName = "*";
    @XNode(value="format-type")
    public String formatTypeName = "*";
    @XNode(value="model-type")
    public String modelTypeName = "*";
    @XNode(value="class")
    public String className;
    @XNode(value="template")
    public String template;
    @XNodeList(value="resource", type=String[].class, componentType=String.class)
    public String[] resources;
    private View view;

    public ViewType() {
    }

    public ViewType(String viewName, String className, String engineName, String templateEngine, String mode, String elementTypeName, String modelTypeName, String formatTypeName, String template, String[] resources) {
        this.viewName = viewName;
        this.elementTypeName = elementTypeName;
        this.modelTypeName = modelTypeName;
        this.formatTypeName = formatTypeName;
        this.engineName = engineName;
        this.templateEngine = templateEngine;
        this.mode = mode;
        this.className = className;
        this.template = template;
        this.resources = resources;
    }

    @Override
    public String getTypeName() {
        return ViewType.computeName(this.formatTypeName, this.elementTypeName, this.viewName, this.modelTypeName, this.engineName, this.mode, this.templateEngine);
    }

    public static String computeName(String formatTypeName, String elementTypeName, String viewName, String modelTypeName, String engineName, String mode, String templateEngineName) {
        return String.format("%s/%s/%s/%s/%s/%s/%s", formatTypeName, elementTypeName, viewName, modelTypeName, engineName, mode, templateEngineName);
    }

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.VIEW;
    }

    public String getViewName() {
        return this.viewName;
    }

    public View getView() {
        if (this.view != null) {
            return this.view;
        }
        if (this.className == null) {
            this.className = ((TemplateEngineType)Manager.getTypeRegistry().lookup(TypeFamily.TEMPLATE_ENGINE, this.templateEngine)).getTemplateView();
        }
        try {
            this.view = (View)Class.forName(this.className).newInstance();
            this.view.setViewType(this);
        }
        catch (Exception e) {
            log.error((Object)("Could not create view for: " + this.className));
            return null;
        }
        return this.view;
    }

    public ElementType getElementType() {
        return (ElementType)Manager.getTypeRegistry().lookup(TypeFamily.ELEMENT, this.elementTypeName);
    }

    public ModelType getModelType() {
        return (ModelType)Manager.getTypeRegistry().lookup(TypeFamily.MODEL, this.modelTypeName);
    }

    public FormatType getFormatType() {
        return (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, this.formatTypeName);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }
}

