/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.ecm.directory.IdGenerator;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.sql.PasswordHelper;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.ecm.directory.sql.repository.Column;
import org.nuxeo.ecm.directory.sql.repository.Delete;
import org.nuxeo.ecm.directory.sql.repository.Insert;
import org.nuxeo.ecm.directory.sql.repository.Select;
import org.nuxeo.ecm.directory.sql.repository.Table;
import org.nuxeo.ecm.directory.sql.repository.Update;

public class SQLSession
extends BaseSession
implements EntrySource {
    private static final String READ_ONLY_VOCABULARY_WARN = "This SQLDirectory is ReadOnly, you are not allowed to modify it.";
    private static final Log log = LogFactory.getLog(SQLSession.class);
    protected final Map<String, Field> schemaFieldMap;
    protected final List<String> storedFieldNames;
    protected final Set<String> emptySet = Collections.emptySet();
    final String schemaName;
    final Table table;
    private final SQLDirectoryDescriptor.SubstringMatchType substringMatchType;
    String dataSourceName;
    final String idField;
    final String passwordField;
    final String passwordHashAlgorithm;
    IdGenerator idGenerator;
    final SQLDirectory directory;
    protected SQLStaticFilter[] staticFilters;
    String sid;
    Connection sqlConnection;
    private final boolean managedSQLSession;
    private final Dialect dialect;

    public SQLSession(SQLDirectory directory, SQLDirectoryDescriptor config, IdGenerator idGenerator, boolean managedSQLSession) throws DirectoryException {
        this.directory = directory;
        this.schemaName = config.getSchemaName();
        this.table = directory.getTable();
        this.idField = config.getIdField();
        this.passwordField = config.getPasswordField();
        this.passwordHashAlgorithm = config.passwordHashAlgorithm;
        this.schemaFieldMap = directory.getSchemaFieldMap();
        this.storedFieldNames = directory.getStoredFieldNames();
        this.dialect = directory.getDialect();
        this.acquireConnection();
        this.sid = String.valueOf(SIDGenerator.next());
        this.managedSQLSession = managedSQLSession;
        this.substringMatchType = config.getSubstringMatchType();
        this.idGenerator = idGenerator;
        this.staticFilters = config.getStaticFilters();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String id = String.valueOf(fieldMap.get(this.getIdField()));
        try {
            DocumentModel docModel = BaseSession.createEntryModel((String)this.sid, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            return docModel;
        }
        catch (PropertyException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void acquireConnection() throws DirectoryException {
        try {
            if (this.sqlConnection == null || this.sqlConnection.isClosed()) {
                this.sqlConnection = this.directory.getDataSource().getConnection();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("updateConnection failed", (Throwable)e);
        }
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws ClientException {
        DocumentModel entry;
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
        }
        this.acquireConnection();
        if (this.idGenerator != null) {
            Integer idValue = this.idGenerator.nextId();
            fieldMap.put(this.idField, idValue);
        } else {
            Object rawId = fieldMap.get(this.idField);
            if (rawId == null) {
                throw new DirectoryException("Missing id");
            }
            String id = String.valueOf(rawId);
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists", id));
            }
        }
        ArrayList<Column> columnList = new ArrayList<Column>(this.table.getColumns());
        Iterator i = columnList.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            String columnName = column.getName();
            if (fieldMap.get(columnName) != null) continue;
            i.remove();
        }
        Insert insert = new Insert(this.dialect, this.table, columnList);
        String sql = insert.getStatement();
        PreparedStatement ps = null;
        try {
            ps = this.sqlConnection.prepareStatement(sql);
            int index = 1;
            for (Column column : columnList) {
                String fieldName = column.getName();
                Object value = fieldMap.get(fieldName);
                this.setFieldValue(ps, index, fieldName, value);
                ++index;
            }
            ps.execute();
            entry = this.fieldMapToDocumentModel(fieldMap);
        }
        catch (SQLException e) {
            throw new DirectoryException("createEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        String sourceId = entry.getId();
        for (Reference reference : this.getDirectory().getReferences()) {
            List targetIds = (List)fieldMap.get(reference.getFieldName());
            if (reference instanceof TableReference) {
                TableReference tableReference = (TableReference)reference;
                tableReference.maybeInitialize(this);
                tableReference.addLinks(sourceId, targetIds, this);
                continue;
            }
            reference.addLinks(sourceId, targetIds);
        }
        this.directory.invalidateCaches();
        return entry;
    }

    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getEntry(id, true);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        return this.directory.getCache().getEntry(id, (EntrySource)this, fetchReferences);
    }

    protected String addFilterWhereClause(String whereClause) throws DirectoryException {
        if (this.staticFilters.length == 0) {
            return whereClause;
        }
        whereClause = whereClause != null && whereClause.trim().length() > 0 ? whereClause + " AND " : "";
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            whereClause = whereClause + filter.getDirectoryColumn().getQuotedName(this.dialect);
            whereClause = whereClause + " " + filter.getOperator() + " ";
            whereClause = whereClause + "? ";
            if (i >= this.staticFilters.length - 1) continue;
            whereClause = whereClause + " AND ";
        }
        return whereClause;
    }

    protected void addFilterValues(PreparedStatement ps, int startIdx) throws DirectoryException {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            this.setFieldValue(ps, startIdx + i, filter.getColumn(), filter.getValue());
        }
    }

    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) throws DirectoryException {
        this.acquireConnection();
        Select select = new Select(this.dialect);
        select.setFrom(this.table.getQuotedName(this.dialect));
        select.setWhat("*");
        String whereClause = this.table.getPrimaryColumn().getQuotedName(this.dialect) + " = ?";
        whereClause = this.addFilterWhereClause(whereClause);
        select.setWhere(whereClause);
        String sql = select.getStatement();
        PreparedStatement ps = null;
        try {
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue(ps, 1, this.idField, id);
            this.addFilterValues(ps, 2);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            for (String fieldName : this.storedFieldNames) {
                Object value = this.getFieldValue(rs, fieldName);
                fieldMap.put(fieldName, value);
            }
            DocumentModel entry = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                for (Reference reference : this.directory.getReferences()) {
                    List targetIds = reference.getTargetIdsForSource(entry.getId());
                    try {
                        entry.setProperty(this.schemaName, reference.getFieldName(), (Object)targetIds);
                    }
                    catch (ClientException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            DocumentModel documentModel = entry;
            return documentModel;
        }
        catch (SQLException e) {
            throw new DirectoryException("getEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public DocumentModelList getEntries() throws ClientException {
        Map<String, Serializable> emptyMap = Collections.emptyMap();
        return this.query(emptyMap);
    }

    public void updateEntry(DocumentModel docModel) throws ClientException {
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
            return;
        }
        this.acquireConnection();
        LinkedList<Column> storedColumnList = new LinkedList<Column>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        DataModel dataModel = docModel.getDataModel(this.schemaName);
        for (String fieldName : this.schemaFieldMap.keySet()) {
            if (fieldName.equals(this.idField) || !dataModel.isDirty(fieldName)) continue;
            if (this.directory.isReference(fieldName)) {
                referenceFieldList.add(fieldName);
                continue;
            }
            storedColumnList.add(this.table.getColumn(fieldName));
        }
        if (!storedColumnList.isEmpty()) {
            Update update = new Update(this.dialect);
            update.setTable(this.table);
            update.setColumns(storedColumnList);
            String whereString = this.table.getPrimaryColumn().getQuotedName(this.dialect) + " = ?";
            update.setWhere(whereString);
            String sql = update.getStatement();
            PreparedStatement ps = null;
            try {
                ps = this.sqlConnection.prepareStatement(sql);
                int index = 1;
                for (Column column : storedColumnList) {
                    String fieldName = column.getName();
                    this.setFieldValue(ps, index, fieldName, dataModel.getData(fieldName));
                    ++index;
                }
                this.setFieldValue(ps, index, this.idField, docModel.getId());
                ps.execute();
            }
            catch (SQLException e) {
                throw new DirectoryException("updateEntry failed for " + docModel.getId(), (Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sqle) {
                    throw new DirectoryException((Throwable)sqle);
                }
            }
        }
        for (String referenceFieldName : referenceFieldList) {
            Reference reference = this.directory.getReference(referenceFieldName);
            List targetIds = (List)docModel.getProperty(this.schemaName, referenceFieldName);
            if (reference instanceof TableReference) {
                TableReference tableReference = (TableReference)reference;
                tableReference.setTargetIdsForSource(docModel.getId(), targetIds, this);
                continue;
            }
            reference.setTargetIdsForSource(docModel.getId(), targetIds);
        }
        this.directory.invalidateCaches();
    }

    public void deleteEntry(DocumentModel docModel) throws ClientException {
        this.deleteEntry(docModel.getId());
    }

    public void deleteEntry(String id) throws ClientException {
        this.acquireConnection();
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
            return;
        }
        for (Reference reference : this.getDirectory().getReferences()) {
            if (reference instanceof TableReference) {
                TableReference tableReference = (TableReference)reference;
                tableReference.removeLinksForSource(id, this);
                continue;
            }
            reference.removeLinksForSource(id);
        }
        Statement ps = null;
        try {
            Delete delete = new Delete(this.dialect);
            delete.setTable(this.table);
            String whereString = this.table.getPrimaryColumn().getQuotedName(this.dialect) + " = ?";
            delete.setWhere(whereString);
            String sql = delete.getStatement();
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue((PreparedStatement)ps, 1, this.idField, id);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        this.directory.invalidateCaches();
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
            return;
        }
        this.acquireConnection();
        Statement ps = null;
        try {
            Delete delete = new Delete(this.dialect);
            delete.setTable(this.table);
            StringBuilder whereClause = new StringBuilder();
            ArrayList<String> values = new ArrayList<String>(1 + map.size());
            whereClause.append(this.table.getPrimaryColumn().getQuotedName(this.dialect));
            whereClause.append(" = ?");
            values.add(id);
            for (Map.Entry<String, String> e : map.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                whereClause.append(" AND ");
                Column col = this.table.getColumn(key);
                if (col == null) {
                    throw new IllegalArgumentException("Unknown column " + key);
                }
                whereClause.append(col.getQuotedName(this.dialect));
                if (value == null) {
                    whereClause.append(" IS NULL");
                    continue;
                }
                whereClause.append(" = ?");
                values.add(value);
            }
            delete.setWhere(whereClause.toString());
            ps = this.sqlConnection.prepareStatement(delete.getStatement());
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    this.setFieldValue((PreparedStatement)ps, 1, this.idField, values.get(i));
                    continue;
                }
                ps.setString(1 + i, (String)values.get(i));
            }
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        this.directory.invalidateCaches();
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws ClientException {
        return this.query(filter, fulltext, orderBy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws ClientException {
        DocumentModelListImpl documentModelListImpl;
        block38: {
            this.acquireConnection();
            LinkedHashMap<String, Serializable> filterMap = new LinkedHashMap<String, Serializable>(filter);
            StringBuilder whereClause = new StringBuilder();
            String separator = "";
            LinkedList<String> orderedFields = new LinkedList<String>();
            for (String columnName : filterMap.keySet()) {
                String operator;
                if (this.directory.isReference(columnName)) {
                    log.warn((Object)(columnName + " is a reference and will be ignored" + " as a query criterion"));
                    continue;
                }
                Object value = filterMap.get(columnName);
                Column column = this.table.getColumn(columnName);
                if (null == column) {
                    throw new ClientException("cannot find column '" + columnName + "' for table: " + this.table);
                }
                String leftSide = column.getQuotedName(this.dialect);
                if (value != null) {
                    if (fulltext != null && fulltext.contains(columnName)) {
                        String searchedValue = null;
                        switch (this.substringMatchType) {
                            case subany: {
                                searchedValue = '%' + String.valueOf(value).toLowerCase() + '%';
                                break;
                            }
                            case subinitial: {
                                searchedValue = String.valueOf(value).toLowerCase() + '%';
                                break;
                            }
                            case subfinal: {
                                searchedValue = '%' + String.valueOf(value).toLowerCase();
                            }
                        }
                        filterMap.put(columnName, (Serializable)((Object)searchedValue));
                        if (this.dialect instanceof PostgreSQLDialect) {
                            operator = " ILIKE ";
                        } else {
                            leftSide = this.dialect.getLowercaseFunction() + '(' + leftSide + ')';
                            operator = " LIKE ";
                        }
                    } else {
                        operator = " = ";
                    }
                } else {
                    operator = " IS NULL";
                }
                whereClause.append(separator).append(leftSide).append(operator);
                if (value != null) {
                    whereClause.append('?');
                    orderedFields.add(columnName);
                }
                separator = " AND ";
            }
            int queryLimitSize = this.directory.getConfig().getQuerySizeLimit();
            if (queryLimitSize != 0) {
                Statement ps = null;
                try {
                    Select select = new Select(this.dialect);
                    select.setWhat("count(*)");
                    select.setFrom(this.table.getQuotedName(this.dialect));
                    String where = whereClause.toString();
                    where = this.addFilterWhereClause(where);
                    select.setWhere(where);
                    String countQuery = select.getStatement();
                    ps = this.sqlConnection.prepareStatement(countQuery);
                    int index = 1;
                    for (String fieldName : orderedFields) {
                        Object value = filterMap.get(fieldName);
                        this.setFieldValue((PreparedStatement)ps, index, fieldName, value);
                        ++index;
                    }
                    this.addFilterValues((PreparedStatement)ps, index);
                    ResultSet rs = ps.executeQuery();
                    rs.next();
                    int count = rs.getInt(1);
                    if (count > queryLimitSize) {
                        throw new SizeLimitExceededException("too many rows in result: " + count);
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            Select select = new Select(this.dialect);
            select.setWhat("*");
            select.setFrom(this.table.getQuotedName(this.dialect));
            String where = whereClause.toString();
            where = this.addFilterWhereClause(where);
            select.setWhere(where);
            StringBuilder orderby = new StringBuilder(128);
            if (orderBy != null) {
                Iterator<Map.Entry<String, String>> it = orderBy.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    orderby.append(this.dialect.openQuote()).append(entry.getKey()).append(this.dialect.closeQuote()).append(' ').append(entry.getValue());
                    if (!it.hasNext()) continue;
                    orderby.append(',');
                }
            }
            select.setOrderBy(orderby.toString());
            String query = select.getStatement();
            PreparedStatement ps = null;
            try {
                ps = this.sqlConnection.prepareStatement(query);
                int index = 1;
                for (String fieldName : orderedFields) {
                    Object value = filterMap.get(fieldName);
                    this.setFieldValue(ps, index, fieldName, value);
                    ++index;
                }
                this.addFilterValues(ps, index);
                ResultSet rs = ps.executeQuery();
                DocumentModelListImpl list = new DocumentModelListImpl();
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String fieldName : this.storedFieldNames) {
                        Object o = this.getFieldValue(rs, fieldName);
                        map.put(fieldName, o);
                    }
                    DocumentModel docModel = this.fieldMapToDocumentModel(map);
                    if (fetchReferences) {
                        for (Reference reference : this.directory.getReferences()) {
                            List targetIds = reference.getTargetIdsForSource(docModel.getId());
                            docModel.setProperty(this.schemaName, reference.getFieldName(), (Object)targetIds);
                        }
                    }
                    list.add((Object)docModel);
                }
                documentModelListImpl = list;
                if (ps == null) break block38;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    try {
                        this.sqlConnection.close();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    throw new DirectoryException("query failed", (Throwable)e);
                }
            }
            ps.close();
        }
        return documentModelListImpl;
    }

    public DocumentModelList query(Map<String, Serializable> filter) throws ClientException {
        return this.query(filter, this.emptySet);
    }

    private Object getFieldValue(ResultSet rs, String fieldName) throws DirectoryException {
        try {
            Field field = this.schemaFieldMap.get(fieldName);
            String typeName = field.getType().getName();
            Column column = this.table.getColumn(fieldName);
            if (column == null) {
                throw new DirectoryException(String.format("Column '%s' does not exist in table '%s'", fieldName, this.table.getName()));
            }
            String columnName = column.getName();
            if ("string".equals(typeName)) {
                return rs.getString(columnName);
            }
            if ("integer".equals(typeName) || "long".equals(typeName)) {
                return rs.getLong(columnName);
            }
            if ("date".equals(typeName)) {
                Timestamp ts = rs.getTimestamp(columnName);
                if (ts == null) {
                    return null;
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(ts.getTime());
                return cal;
            }
            throw new DirectoryException("Field type not supported in directories: " + typeName);
        }
        catch (SQLException e) {
            throw new DirectoryException("getFieldValue failed", (Throwable)e);
        }
    }

    private void setFieldValue(PreparedStatement ps, int index, String fieldName, Object value) throws DirectoryException {
        block24: {
            this.acquireConnection();
            try {
                Field field = this.schemaFieldMap.get(fieldName);
                String typeName = "string";
                if (field == null) {
                    for (SQLStaticFilter filter : this.staticFilters) {
                        if (!filter.getColumn().equals(fieldName)) continue;
                        typeName = filter.type;
                        break;
                    }
                } else {
                    typeName = field.getType().getName();
                }
                if ("string".equals(typeName)) {
                    if (value != null) {
                        if (fieldName.equals(this.idField)) {
                            if (this.table.getPrimaryColumn().getSqlType() == -5 || this.table.getPrimaryColumn().getSqlType() == 4 || this.table.getPrimaryColumn().getSqlType() == 5) {
                                ps.setInt(index, Integer.parseInt((String)value));
                            } else {
                                ps.setString(index, (String)value);
                            }
                        } else if (fieldName.equals(this.passwordField)) {
                            String password = (String)value;
                            if (!PasswordHelper.isHashed(password)) {
                                password = PasswordHelper.hashPassword(password, this.passwordHashAlgorithm);
                            }
                            ps.setString(index, password);
                        } else {
                            ps.setString(index, (String)value);
                        }
                    } else {
                        ps.setNull(index, 12);
                    }
                    break block24;
                }
                if ("integer".equals(typeName) || "long".equals(typeName)) {
                    if (value instanceof Integer) {
                        long longValue = ((Integer)value).intValue();
                        ps.setLong(index, longValue);
                        break block24;
                    }
                    if (value instanceof Long) {
                        long longValue = (Long)value;
                        ps.setLong(index, longValue);
                        break block24;
                    }
                    if (value instanceof String) {
                        long longValue = Long.valueOf((String)value);
                        ps.setLong(index, longValue);
                        break block24;
                    }
                    if (value == null) {
                        ps.setNull(index, 4);
                        break block24;
                    }
                    throw new DirectoryException("setFieldValue: invalid value type");
                }
                if ("date".equals(typeName)) {
                    if (value instanceof Calendar) {
                        ps.setTimestamp(index, new Timestamp(((Calendar)value).getTimeInMillis()));
                        break block24;
                    }
                    if (value == null) {
                        ps.setNull(index, 93);
                        break block24;
                    }
                    throw new DirectoryException("setFieldValue: invalid value type");
                }
                throw new DirectoryException("Field type not supported in directories: " + typeName);
            }
            catch (SQLException e) {
                throw new DirectoryException("setFieldValue failed", (Throwable)e);
            }
        }
    }

    public void commit() throws DirectoryException {
        try {
            if (!this.managedSQLSession) {
                this.sqlConnection.commit();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("commit failed", (Throwable)e);
        }
    }

    public void rollback() throws DirectoryException {
        try {
            this.sqlConnection.rollback();
        }
        catch (SQLException e) {
            throw new DirectoryException("rollback failed", (Throwable)e);
        }
    }

    public void close() throws DirectoryException {
        try {
            this.sqlConnection.close();
            this.directory.removeSession((Session)this);
        }
        catch (SQLException e) {
            throw new DirectoryException("close failed", (Throwable)e);
        }
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws ClientException {
        DocumentModelList docList = this.query(filter, fulltext);
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentModel docModel : docList) {
            Object obj = docModel.getProperty(this.schemaName, columnName);
            String propValue = obj instanceof String ? (String)obj : String.valueOf(obj);
            result.add(propValue);
        }
        return result;
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws ClientException {
        return this.getProjection(filter, this.emptySet, columnName);
    }

    public boolean authenticate(String username, String password) throws ClientException {
        DocumentModel entry = this.getEntry(username);
        if (entry == null) {
            return false;
        }
        String storedPassword = (String)entry.getProperty(this.schemaName, this.getPasswordField());
        return PasswordHelper.verifyPassword(password, storedPassword);
    }

    public boolean isAuthenticating() throws ClientException {
        return this.schemaFieldMap.containsKey(this.getPasswordField());
    }

    public String getIdField() {
        return this.directory.getConfig().getIdField();
    }

    public String getPasswordField() {
        return this.directory.getConfig().getPasswordField();
    }

    public boolean isReadOnly() {
        return Boolean.TRUE.equals(this.directory.getConfig().getReadOnly());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        return this.query(filter, fulltext, new HashMap<String, String>());
    }

    public DocumentModel createEntry(DocumentModel entry) throws ClientException {
        Map fieldMap = entry.getProperties(this.schemaName);
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) throws ClientException {
        this.acquireConnection();
        Select select = new Select(this.dialect);
        select.setFrom(this.table.getQuotedName(this.dialect));
        select.setWhat("*");
        select.setWhere(this.table.getPrimaryColumn().getQuotedName(this.dialect) + " = ?");
        String sql = select.getStatement();
        PreparedStatement ps = null;
        try {
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue(ps, 1, this.idField, id);
            ResultSet rs = ps.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException("hasEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public Connection getSqlConnection() {
        return this.sqlConnection;
    }
}

