/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.component.UISelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;

public class UIDirectorySelectItem
extends UISelectItem {
    private static final Log log = LogFactory.getLog(UIDirectorySelectItem.class);
    public static final String COMPONENT_TYPE = UIDirectorySelectItem.class.getName();
    protected String directoryName;

    public String getDirectoryName() {
        if (this.directoryName != null) {
            return this.directoryName;
        }
        ValueExpression ve = this.getValueExpression("directoryName");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    protected Session getDirectorySession() {
        String dirName = this.getDirectoryName();
        Session directorySession = null;
        if (dirName != null) {
            try {
                DirectoryService service = DirectoryHelper.getDirectoryService();
                directorySession = service.open(dirName);
            }
            catch (Exception e) {
                log.error((Object)String.format("Error when retrieving directory %s", dirName), (Throwable)e);
            }
        }
        return directorySession;
    }

    protected static void closeDirectorySession(Session directorySession) {
        if (directorySession != null) {
            try {
                directorySession.close();
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getValue() {
        Object value = super.getValue();
        return this.createSelectItem(value);
    }

    @Override
    protected SelectItem createSelectItem(Object value) {
        SelectItem item = null;
        if (value instanceof SelectItem) {
            item = (SelectItem)value;
        } else if (value instanceof String) {
            String entryId = (String)value;
            this.putIteratorToRequestParam(value);
            Session directorySession = this.getDirectorySession();
            if (directorySession != null) {
                try {
                    DocumentModel entry = directorySession.getEntry(entryId);
                    if (entry != null) {
                        this.putIteratorToRequestParam(entry);
                        item = this.createSelectItem();
                        this.removeIteratorFromRequestParam();
                    }
                }
                catch (DirectoryException e) {}
            } else {
                log.error((Object)"No session provided for directory, returning empty selection");
            }
            UIDirectorySelectItem.closeDirectorySession(directorySession);
            this.removeIteratorFromRequestParam();
        }
        return item;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.directoryName};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.directoryName = (String)values[1];
    }
}

