/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="restHelper")
@Scope(value=ScopeType.EVENT)
public class RestHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    transient NavigationContext navigationContext;
    @In(create=true)
    transient WebActions webActions;
    private DocumentView docView;
    private String baseURL = "";

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String initContextFromRestRequest(DocumentView docView) throws ClientException {
        DocumentLocation docLoc;
        String serverName;
        String outcome = null;
        if (docView != null && (serverName = (docLoc = docView.getDocumentLocation()).getServerName()) != null) {
            DocumentRef docRef = docLoc.getDocRef();
            RepositoryLocation repoLoc = new RepositoryLocation(serverName);
            if (docRef != null) {
                outcome = this.navigationContext.navigateTo(repoLoc, docRef);
            } else {
                this.navigationContext.setCurrentServerLocation(repoLoc);
            }
        }
        return outcome;
    }

    public void setDocumentView(DocumentView docView) {
        this.docView = docView;
    }

    public DocumentView getNewDocumentView() {
        DocumentViewImpl docView = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(currentDocument);
            TypeInfo typeInfo = (TypeInfo)currentDocument.getAdapter(TypeInfo.class);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tabId", this.webActions.getCurrentTabId());
            params.put("subTabId", this.webActions.getCurrentSubTabId());
            if (currentDocument.isVersion()) {
                params.put("version", "true");
            }
            docView = new DocumentViewImpl((DocumentLocation)docLoc, typeInfo.getDefaultView(), params);
        }
        return docView;
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public static Manager getConversationManager() {
        if (Contexts.isEventContextActive()) {
            return Manager.instance();
        }
        return null;
    }

    protected static String addConversationRequestParameters(String url, Manager conversationManager, String conversationId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(conversationManager.getConversationIdParameter(), conversationId);
        return conversationManager.encodeParameters(url, params);
    }

    public static String addCurrentConversationParameters(String url) {
        Manager conversationManager = RestHelper.getConversationManager();
        if (conversationManager == null) {
            return url;
        }
        return conversationManager.encodeConversationId(url);
    }

    public static String addMainConversationParameters(String url) {
        Manager conversationManager = RestHelper.getConversationManager();
        if (conversationManager == null) {
            return url;
        }
        String conversationId = conversationManager.isNestedConversation() ? conversationManager.getParentConversationId() : conversationManager.getCurrentConversationId();
        return RestHelper.addConversationRequestParameters(url, conversationManager, conversationId);
    }

    @Factory(value="baseURL", scope=ScopeType.CONVERSATION)
    public String getBaseURL() {
        if (this.baseURL.equals("")) {
            this.baseURL = BaseURL.getBaseURL();
        }
        return this.baseURL;
    }

    @Factory(value="contextPath", scope=ScopeType.CONVERSATION)
    public String getContextPath() {
        return BaseURL.getContextPath();
    }

    public String doPrint(String defaultTheme) throws IOException {
        return this.doPrint(this.navigationContext.getCurrentDocument(), defaultTheme);
    }

    public String doPrint(DocumentModel doc, String defaultTheme) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        HttpServletResponse response = RestHelper.getHttpServletResponse();
        if (response != null) {
            RestHelper.handleRedirect(response, this.getPrintUrl(doc, defaultTheme));
        }
        return null;
    }

    public String getPrintUrl(String defaultTheme) {
        return this.getPrintUrl(this.navigationContext.getCurrentDocument(), defaultTheme);
    }

    public String getPrintUrl(DocumentModel doc, String defaultTheme) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int separatorIndex = defaultTheme.indexOf("/");
        if (separatorIndex != -1) {
            defaultTheme = defaultTheme.substring(0, separatorIndex);
            StringBuilder sb = new StringBuilder();
            sb.append(defaultTheme);
            sb.append("/print");
            parameters.put("theme", sb.toString());
        }
        return DocumentModelFunctions.documentUrl(null, doc, null, parameters, false, null);
    }

    public static HttpServletResponse getHttpServletResponse() {
        ServletResponse response = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            response = (ServletResponse)facesContext.getExternalContext().getResponse();
        }
        if (response != null && response instanceof HttpServletResponse) {
            return (HttpServletResponse)response;
        }
        return null;
    }

    public static HttpServletRequest getHttpServletRequest() {
        ServletRequest request = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            request = (ServletRequest)facesContext.getExternalContext().getRequest();
        }
        if (request != null && request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        return null;
    }

    public static void handleRedirect(HttpServletResponse response, String url) throws IOException {
        response.resetBuffer();
        response.sendRedirect(url);
        response.flushBuffer();
        RestHelper.getHttpServletRequest().setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
        FacesContext.getCurrentInstance().responseComplete();
    }
}

