/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.fn;

import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public final class Functions {
    public static final String I18N_DURATION_PREFIX = "label.duration.unit.";
    public static final String BIG_FILE_SIZE_LIMIT_PROPERTY = "org.nuxeo.big.file.size.limit";
    public static final long DEFAULT_BIG_FILE_SIZE_LIMIT = 0x500000L;
    private static UserManager userManager;
    private static final String FULLNAMES_MAP_KEY;
    static final Map<String, String> mapOfDateLength;

    private Functions() {
    }

    public static Object test(Boolean test, Object onSuccess, Object onFailure) {
        return test != false ? onSuccess : onFailure;
    }

    public static String join(String[] list, String separator) {
        return StringUtils.join((Object[])list, (String)separator);
    }

    public static String joinCollection(Collection<Object> collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), (String)separator);
    }

    public static String htmlEscape(String data) {
        return StringEscapeUtils.escapeHtml((String)data);
    }

    public static String joinCollectionWithFinalDelimiter(Collection<Object> collection, String separator, String finalSeparator) {
        return Functions.joinArrayWithFinalDelimiter(collection.toArray(), separator, finalSeparator);
    }

    public static String joinArrayWithFinalDelimiter(Object[] collection, String separator, String finalSeparator) {
        if (collection == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        for (Object object : collection) {
            result.append(object);
            if (++i == collection.length - 1) {
                separator = finalSeparator;
            }
            if (i == collection.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String formatDateUsingBasicFormatter(Date date) {
        return Functions.formatDate(date, Functions.basicDateFormater());
    }

    public static String formatDate(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String concat(String s1, String s2) {
        return s1 + s2;
    }

    public static String indentString(Integer level, String text) {
        StringBuilder label = new StringBuilder("");
        for (int i = 0; i < level; ++i) {
            label.append(text);
        }
        return label.toString();
    }

    public static boolean userIsMemberOf(String groupName) {
        FacesContext context = FacesContext.getCurrentInstance();
        NuxeoPrincipal principal = (NuxeoPrincipal)context.getExternalContext().getUserPrincipal();
        return principal.isMemberOf(groupName);
    }

    private static UserManager getUserManager() throws ClientException {
        if (userManager == null) {
            try {
                userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return userManager;
    }

    public static String userFullName(String username) {
        String fullName;
        Map session;
        HashMap<String, String> fullNames;
        Principal pal;
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if ((username == null || username.length() == 0) && (pal = externalContext.getUserPrincipal()) != null) {
            username = pal.getName();
        }
        if ((fullNames = (HashMap<String, String>)(session = externalContext.getSessionMap()).get(FULLNAMES_MAP_KEY)) != null && fullNames.containsKey(username)) {
            return (String)fullNames.get(username);
        }
        try {
            NuxeoPrincipal principal = Functions.getUserManager().getPrincipal(username);
            fullName = principal != null ? Functions.principalFullName(principal) : username;
        }
        catch (ClientException e) {
            fullName = username;
        }
        if (fullNames == null) {
            fullNames = new HashMap<String, String>();
            session.put(FULLNAMES_MAP_KEY, fullNames);
        }
        fullNames.put(username, fullName);
        return fullName;
    }

    public static String principalFullName(NuxeoPrincipal principal) {
        String first = principal.getFirstName();
        String last = principal.getLastName();
        return Functions.userDisplayName(principal.getName(), first, last);
    }

    public static String userDisplayName(String id, String first, String last) {
        if (first == null || first.length() == 0) {
            if (last == null || last.length() == 0) {
                return id;
            }
            return last;
        }
        if (last == null || last.length() == 0) {
            return first;
        }
        return first + ' ' + last;
    }

    public static String dateFormater(String formatLength) {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        DateFormat aDateFormat = DateFormat.getDateInstance(Integer.parseInt(mapOfDateLength.get(formatLength.toLowerCase())), locale);
        SimpleDateFormat format = (SimpleDateFormat)aDateFormat;
        return format.toPattern();
    }

    public static String basicDateFormater() {
        return Functions.dateFormater("short");
    }

    public static String dateAndTimeFormater(String formatLength) {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        DateFormat aDateFormat = DateFormat.getDateTimeInstance(Integer.parseInt(mapOfDateLength.get(formatLength.toLowerCase())), Integer.parseInt(mapOfDateLength.get(formatLength.toLowerCase())), locale);
        SimpleDateFormat format = (SimpleDateFormat)aDateFormat;
        return format.toPattern();
    }

    public static String basicDateAndTimeFormater() {
        return Functions.dateAndTimeFormater("short");
    }

    public static String printFileSize(String size) {
        return Functions.printFormatedFileSize(size, "SI", true);
    }

    public static String printFormatedFileSize(String sizeS, String format, Boolean isShort) {
        String msg;
        int ex;
        Integer size = sizeS == null || "".equals(sizeS) ? 0 : Integer.parseInt(sizeS);
        BytePrefix prefix = Enum.valueOf(BytePrefix.class, format);
        int base = prefix.getBase();
        String[] suffix = isShort != false ? prefix.getShortSuffixes() : prefix.getLongSuffixes();
        for (ex = 0; size > base - 1 || ex > suffix.length; ++ex) {
            size = size / base;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            Locale locale;
            String bundleName = context.getApplication().getMessageBundle();
            msg = I18NUtils.getMessageString((String)bundleName, (String)"label.bytes.suffix", null, (Locale)(locale = context.getViewRoot().getLocale()));
            if ("label.bytes.suffix".equals(msg)) {
                msg = "B";
            }
        } else {
            msg = "B";
        }
        return "" + size + " " + suffix[ex] + msg;
    }

    public static Integer integerDivision(Integer x, Integer y) {
        return x / y;
    }

    public static String printFormattedDuration(Object durationObj, Map<String, String> i18nLabels) {
        if (i18nLabels == null) {
            i18nLabels = new HashMap<String, String>();
        }
        double duration = 0.0;
        if (durationObj instanceof Float) {
            duration = ((Float)durationObj).doubleValue();
        } else if (durationObj instanceof Double) {
            duration = (Double)durationObj;
        } else if (durationObj instanceof Integer) {
            duration = ((Integer)durationObj).doubleValue();
        } else if (durationObj instanceof Long) {
            duration = ((Long)durationObj).doubleValue();
        } else if (durationObj instanceof String) {
            duration = Double.parseDouble((String)durationObj);
        }
        int days = (int)Math.floor(duration / 86400.0);
        int hours = (int)Math.floor(duration / 3600.0) - days * 24;
        int minutes = (int)Math.floor(duration / 60.0) - days * 24 * 60 - hours * 60;
        int seconds = (int)Math.floor(duration) - days * 24 * 3600 - hours * 3600 - minutes * 60;
        int[] components = new int[]{days, hours, minutes, seconds};
        String[] units = new String[]{"days", "hours", "minutes", "seconds"};
        String[] defaultLabels = new String[]{"d", "hr", "min", "sec"};
        String representation = null;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == 0 && i != components.length - 1) continue;
            String i18nLabel = i18nLabels.get(I18N_DURATION_PREFIX + units[i]);
            if (i18nLabel == null) {
                i18nLabel = defaultLabels[i];
            }
            representation = String.format("%d %s", components[i], i18nLabel);
            if (i >= components.length - 1) break;
            i18nLabel = i18nLabels.get(I18N_DURATION_PREFIX + units[i + 1]);
            if (i18nLabel == null) {
                i18nLabel = defaultLabels[i + 1];
            }
            representation = representation + String.format(" %d %s", components[i + 1], i18nLabel);
            break;
        }
        return representation;
    }

    public static String printFormattedDuration(Object durationObj) {
        return Functions.printFormattedDuration(durationObj, null);
    }

    public static long getBigFileSizeLimit() {
        return Functions.getFileSize(Framework.getProperty((String)BIG_FILE_SIZE_LIMIT_PROPERTY, (String)""));
    }

    public static long getFileSize(String value) {
        Pattern pattern = Pattern.compile("([1-9][0-9]*)([kmgi]*)", 2);
        Matcher m = pattern.matcher(value.trim());
        if (!m.matches()) {
            return 0x500000L;
        }
        long number = Long.valueOf(m.group(1));
        String multiplier = m.group(2);
        return Functions.getValueFromMultiplier(multiplier) * number;
    }

    public static long getValueFromMultiplier(String m) {
        if ("k".equalsIgnoreCase(m)) {
            return 1000L;
        }
        if ("Ki".equalsIgnoreCase(m)) {
            return 1024L;
        }
        if ("M".equalsIgnoreCase(m)) {
            return 1000000L;
        }
        if ("Mi".equalsIgnoreCase(m)) {
            return 0x100000L;
        }
        if ("G".equalsIgnoreCase(m)) {
            return 1000000000L;
        }
        if ("Gi".equalsIgnoreCase(m)) {
            return 0x40000000L;
        }
        return 1L;
    }

    static {
        FULLNAMES_MAP_KEY = Functions.class.getName() + ".FULLNAMES_MAP";
        mapOfDateLength = new HashMap<String, String>(){
            private static final long serialVersionUID = 8465772256977862352L;
            {
                this.put("short", String.valueOf(3));
                this.put("medium", String.valueOf(2));
                this.put("long", String.valueOf(1));
                this.put("full", String.valueOf(0));
            }
        };
    }

    public static enum BytePrefix {
        SI(1000, new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"}, new String[]{"", "kilo", "mega", "giga", "tera", "peta", "exa", "zetta", "yotta"}),
        IEC(1024, new String[]{"", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei", "Zi", "Yi"}, new String[]{"", "kibi", "mebi", "gibi", "tebi", "pebi", "exbi", "zebi", "yobi"}),
        JEDEC(1024, new String[]{"", "K", "M", "G"}, new String[]{"", "kilo", "mega", "giga"});

        private final int base;
        private final String[] shortSuffixes;
        private final String[] longSuffixes;

        private BytePrefix(int base, String[] shortSuffixes, String[] longSuffixes) {
            this.base = base;
            this.shortSuffixes = shortSuffixes;
            this.longSuffixes = longSuffixes;
        }

        public int getBase() {
            return this.base;
        }

        public String[] getShortSuffixes() {
            return this.shortSuffixes;
        }

        public String[] getLongSuffixes() {
            return this.longSuffixes;
        }
    }
}

